
/* Le bureau xdesktop permet d'étendre ces fonctionnalités grâce au 
    paradigme de la programmation orienté aspect (AOP)
    qui permet de traiter séparément les préoccupations transversales (en anglais, cross-cutting concerns), 
    qui relèvent souvent de la technique (aspect en anglais), des préoccupations métier, qui constituent le coeur d'une application
    (source wikipedia:http://fr.wikipedia.org/wiki/Programmation_orient%C3%A9e_aspect)
    
    La librairie AOP utilisé est la suivante
    https://github.com/victorcastroamigo/aopjs

    Ci-dessous un exemple de création d'un aspect <NOM du PLUGIN> doit contenir que des caractères alphanumeriques
    le nom du fichier doit être <NOM du PLUGIN>.js et posé dans le dossier enabled pour qu'il soit chargé

    Dans cet exemple <NOM DU PLUGIN> serait donc a remplacer par aspectSample car le nom du fichier est <NOM DU PLUGIN>.js

*/

aspects.<NOM DU PLUGIN>.create = function(){
  var __instance = new function()
  {
    this.version = "1.0";

    /* ====== ICI vos Advices (Greffon) */

    /* Exemple: On souhaite loger dans la console lorsque l'utilisateur lance une application */
    /* On vient donc 'décorer' la fonction $mxdesktop.openApp juste avant son execution 
       pour loger    
    */
    $mxdesktop.openApp=AOP.aspect($mxdesktop.openApp).before(function(f,args)
    {
        // $mxdesktop.openApp : prend en parrametre l'identifiant de l'application

        var appid=args[0];          // récupération de l'id
        var app=$mxdesktop.app()    // récupération de l'appli
        // et on log
        console.log("openApp appid: "+app.id+" nom="+app.nom)
    });


    /* ================================*/ 

  }

  return __instance;

}
