/* =============================================================
seshat : Module permettant de charger les ressources
         depuis seshat. Ce module permet ainsi de récupérer
         dans un même espace les items de
            - Arena (si Pers. Educ. Nat. )
            - Tous établissements d'affectation 

configuration : 

seshatEnvole.ini
{
 "url":"https://<SESHAT-ACADEMIQUE>/edispatcher/ressources.php",
 "nom":"Ressources Communes"
}

=================================================================*/

aspects.seshatEnvole.create = function(){
    var __instance =new function()
    {
        this.version = "1.2";

        // Avant l'initialisation on va modififer la ressource principale à charger
        $mxactions.recupererLesItemDeBureau=AOP.aspect($mxactions.recupererLesItemDeBureau).before(function()
        {
            if (__instance.already!=undefined) return;

            __instance.already=true;
            __instance.info("Load Ressource From Seshat")

            // Si c'est l'admin local on utilisera les ressources locales
            if ($mxdesktop.envole.uid == "admin") {
                __instance.info(" -> Admin user detected, loading local ressource")
                source=$mxdesktop.config.desktopitems[0]; 
                source.services_url="xdesktop/controllers/mxServices.php";               
                $mxdesktop.defaultCategorie="Aucune categorie"
                return    
            }

            // Récupération de la configuration
            __instance.getConfig(function(data) {
                if (data.length >0 && data[0].url != undefined)
                {
                    var conf=data[0]
                    url=conf.url+"?rne="+$mxdesktop.envole.rne+"&provenance="+$mxdesktop.envole.provenance;
		            // Ref: #9349, Un service a été créé pour récupérer les messages arena, 
		            // afin d'interpréter le balisage html ( Arena v1.1.1 ) 
                    $mxdesktop.config.desktopitems=[new Source({url:url,
						     messages_arena:conf.messages_arena || conf.url.replace("ressources.php","messages.php"),
                             nom:conf.nom || "Ressources Communes",
                             callback:"controllers/callback.php",type:"COMMUNE",
                             fallback:$mxdesktop.config.desktopitems[0]
                    })]
                    // Messages venant d'un xdesktop sur seshat
                    if (conf.messages && conf.messages.url) {
                        $mxdesktop.config.desktopitems.unshift(new Source({url:"",baseurl:conf.messages.url,
                                                               federer:conf.messages.url+"/xdesktop/api/session",
                                                               faicon:conf.faicon || "fa-envelope",type:"COMMUNE",
                                                               nom:conf.messages.nom || "Messages",noapps:true}))
                    }

                } else {
                    __instance.error("Aucune configuration valide pour seshat")
                }
            })
        });
    }    

    return __instance;
}

