<?php
    $VERSION="1.51";
    $BASEPATH="";
    include_once("include/jsmin.php");


    $CSS=array("bootstrap/dist/css/bootstrap.min.css","bootstrap/font-awesome/css/font-awesome.min.css",
               "bootstrap/assets/css/jquery.mCustomScrollbar.css",
               "style/mxdesktop.css","style/mxdesktop.local.css");  

    /* CSS suplémentaires pour l'administration */
    $CSS_ADMIN=array("bootstrap/assets/css/summernote-bs3.css","bootstrap/assets/css/bootstrap-datetimepicker.min.css",
		     "style/style.css","bootstrap/assets/css/chosen.css",
		     "bootstrap/assets/css/bootstrap-iconpicker.min.css");

    $JS=array(
	      /* jquery */
	      "bootstrap/assets/js/jquery.js",
	      "bootstrap/assets/js/jquery.md5.js",
	      "bootstrap/assets/js/jquery-ui.js",
	      /* bootstrap */
	      "bootstrap/dist/js/bootstrap.min.js",
          "bootstrap/assets/js/aop.js",
	      "bootstrap/assets/js/knockout.js",
	      "bootstrap/assets/js/knockout.reactor.js",
	      "bootstrap/assets/js/bootbox.min.js",
	      /* Appli*/
          "js/classes.js","js/mxdesktop.js","js/infosplus.js","js/notifications.js","js/ajax.js","js/local.js",
          "js/messages.js",
          /* piwik */
          "bootstrap/assets/js/piwik.js",
	      "bootstrap/assets/js/dust-full-0.3.0.min.js", /* template for piwik */
	      /* */
          "bootstrap/assets/js/jquery.mCustomScrollbar.min.js","bootstrap/assets/js/jquery.qtip-2.1.1.min.js",
          "bootstrap/assets/js/jquery.cookie.js",
          "bootstrap/assets/js/jquery.highlight.js",
          "bootstrap/assets/js/moment.min.js","bootstrap/assets/js/moment-fr.js");

    /* JS supplémentaires nécessaires pour l'administration */
    $JS_ADMIN=array(
		"bootstrap/assets/js/jquery.chosen.min.js",
		"bootstrap/assets/js/bootstrap-iconpicker.min.js",
		"bootstrap/assets/js/bootstrap-datetimepicker.min.js",
		"bootstrap/assets/js/summernote.min.js","bootstrap/assets/js/summernote-fr-FR.js");

    $CACHE_PATH="cache/";

function write_header($title="") {

echo <<<END
        <!DOCTYPE html>
        <html>

        <head>
            <meta charset="utf-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <meta name="description" content="">
            <meta name="author" content="">
            <link rel="shortcut icon" href="bootstrap/assets/ico/favicon.png">

            <title>$title</title>
END;

    write_assets_css();
            
    echo "</head>";


}

function write_assets_js($bAll=false,$badmin=false) {
    global $BASEPATH,$VERSION;
    if (isset($_GET["debug"])) {
        global $JS;
        if ($bAll) $JS[]="js/aspects.js";
        foreach($JS as $file) {echo '<script src="'.$file.'"></script>';}
	if ($badmin) {
		global $JS_ADMIN;
		foreach($JS_ADMIN as $file) {echo '<script src="'.$file.'"></script>';}
	}
    } else
    {
        $type="js";
        if ($bAll) $type="jsall";
	if ($badmin) $type=$type."admin";
        echo '<script src="'.$BASEPATH.'assets.php?'.$type.'&v='.$VERSION.'"></script>';
        echo "<script>var _COMPILED=true</script>";
    }
}

function write_assets_css() {
    global $BASEPATH,$VERSION;
    if (isset($_GET["debug"])) {
        global $CSS,$CSS_ADMIN;
	$CSS=array_merge($CSS,$CSS_ADMIN);
        foreach($CSS as $file) {echo '<link href="'.$file.'" rel="stylesheet">';}
    } else
    {
        echo '<link href="'.$BASEPATH.'assets.php?css&v='.$VERSION.'" rel="stylesheet">';
        echo "<script>var _COMPILEDCSS=true</script>";
    }
}

function compile($type,$ARRAY,$bMinify=false){

    global $CACHE_PATH;

    $ifModifiedSince=(isset($_SERVER['HTTP_IF_MODIFIED_SINCE']) ? $_SERVER['HTTP_IF_MODIFIED_SINCE'] : false);
    $cacheFILE=$CACHE_PATH."cache.$type";
    $cacheMD5=$CACHE_PATH."cache.$type.md5";

    if (file_exists($cacheFILE) && file_exists($cacheMD5))
    {
        $content = file_get_contents($cacheFILE);
        $etagFile=file_get_contents($cacheMD5);
       
    } else
    {
        $content="";
        foreach($ARRAY as $file) {
            if (file_exists($file))
            {
                $code=file_get_contents($file);
                if ($bMinify) {
                    $content.=\JShrink\Minifier::minify($code)."\n";
                } else {
                    $content.=$code;
                }
            }    
        }
        
        $etagFile=md5($content);
        file_put_contents($cacheFILE,$content);
        file_put_contents($cacheMD5,$etagFile);
        
    }


    $lastModified=filemtime($cacheFILE);

    header("Last-Modified: ".gmdate("D, d M Y H:i:s", $lastModified)." GMT");
    header('Content-Length: ' . strlen($content) );
    header("Etag: $etagFile");
    header('Cache-Control: public');

    if (@strtotime($_SERVER['HTTP_IF_MODIFIED_SINCE'])==$lastModified || trim($_SERVER['HTTP_IF_NONE_MATCH']) == $etagFile)
    {
       header("HTTP/1.1 304 Not Modified");
       exit;
    }

    echo $content;
}


// JS   
if (isset($_GET["jsall"]))  {
    header("Content-type: application/javascript");
    $JS[]="js/aspects.js";
    compile("jsall",$JS,true);
}
if (isset($_GET["js"])) {
    header("Content-type: application/javascript");
    compile("js",$JS,true);
}

if (isset($_GET["jsadmin"])) {
    header("Content-type: application/javascript");
    $JS=array_merge($JS,$JS_ADMIN);
    compile("jsadmin",$JS,true);
}

// CSS
if (isset($_GET["css"])) {
    header("Content-Type: text/css");
    compile("css",$CSS);
}

// CSS
if (isset($_GET["cssadmin"])) {
    header("Content-Type: text/css");
    $CSS=array_merge($CSS,$CSS_ADMIN);
    compile("cssadmin",$CSS);
}




?>
