<?php

$dir='../aspects/';
$dir_enabled=$dir.'enabled/';
$dir_config=$dir.'conf/';

function endsWith($haystack, $needle)
{
    return $needle === "" || substr($haystack, -strlen($needle)) === $needle;
}

// Récupération d'un script
if (isset($_GET["get"])) {
    
    $script=$_GET["get"];
    if (!ctype_alnum($script)) die("No a valid file");

    header("content-type: application/javascript");
    echo file_get_contents($dir_enabled.$script.".js");
    die();
}

// Récupération d'un script
if (isset($_GET["config"])) {
    
    $script=$_GET["config"];
    header("content-type: application/json");

    $arr=array();
    if ($handle = opendir($dir_config)) {
        while (false !== ($file = readdir($handle))) {
            if (filetype($dir_config . $file)=="dir") continue;
            if (strpos($file,$script)===false) continue;
            if (!endsWith($file,".ini"))   continue;
            $arr[]=file_get_contents($dir_config.$file);
        }
        $all=implode(",",$arr);
        echo "[$all]";
    }

    die();
}

// Vérification d'un cache
$rev="";
if (file_exists("$dir_enabled/version.txt")) {
	$rev=file_get_contents("$dir_enabled/version.txt");
	$CACHE="$dir_enabled/cache_$rev.js";	
	if (file_exists($CACHE)) {
		echo file_get_contents($CACHE);
		die();
	}
}

// Liste tous les scripts dispo
if ($handle = opendir($dir_enabled)) {

    header('Content-Type: application/json');
    $arr=array();
    while (false !== ($file = readdir($handle))) {
        // Un dossier ?, on passe au suivant
        if (filetype($dir_enabled . $file)=="dir") continue;
        // Vérifie que le script se termine bien par .js
        if (!endsWith($file,".js"))   continue;

        $script=str_replace(".js","",$file);
        $content=file_get_contents($dir_enabled.$file);
        $arr[]=array( "nom" => $script,"actif" => true,"content"=>$content);
    }
    array_multisort($arr, SORT_ASC);
    echo json_encode($arr);

    try {
    $rev=time();
    file_put_contents("$dir_enabled/version.txt",$rev);
    file_put_contents("$dir_enabled/cache_$rev.js",json_encode($arr));
    } catch (Exception $e) {}
}
?>
