<?php

namespace LDAP;

global $config;
if (isset($config['LDAPserver'])) {
    require_once('configCAS/ldap.inc.php');
}

function GetCustomUsers() {

    global $config;

    //TODO
    return  array();

}

function GetCustomGroups() {

    global $config;

    $a = array();
    if (!isset($config['LDAPserver'])) return $a;

    $base   =   $config['LDAPCustomGroupsBase'];
    $filter =   $config["LDAPCustomGroupsFilter"];

    $ds     = ldap_connect(__LDAP_HOST);
    $lds    = ldap_search($ds,$base,$filter,array("cn"));
    $ldge   = ldap_get_entries ($ds, $lds);

    if ($ldge["count"]>0) {
        $z=array();
        for ($n=0 ; $n < $ldge["count"] ; $n++){
            $z[]=$ldge[$n]["cn"][0];
        }
        sort($z);
        $a=array("label"=>$config["LDAPCustomGroupsName"],"children"=>$z);
    }

    return $a;


}

// retourne tous les groupes LDAP
function GetGroups() {
    global $config;

    $a=array();

    if (isset($config["LDAPCustomGroupsFilter"])) {
      $a[]=GetCustomGroups();
    }

    if (isset($config['GROUPES'])) {
      $a[]=$config['GROUPES'];
    }

    if (!isset($config['LDAPserver'])) return $a;

    $grps = [];
    if (__LDAP_HOST && __LDAP_BASE_DN_EXTENSION && __LDAP_BASE_DN ) {
      $ds=ldap_connect(__LDAP_HOST);
      if ($ds) {
        $gr_types = array('Classe', 'Option', 'Groupe','Matiere', 'Equipe','Niveau');
        try {
          foreach ($gr_types as $type) {
              $lds = ldap_search($ds, "ou=local,ou=groupes,".__LDAP_BASE_DN_EXTENSION.",".__LDAP_BASE_DN, "(&(objectclass=sambaGroupMapping)(objectclass=posixGroup)(type=$type))", array("cn"));
              $ldge = ldap_get_entries ($ds, $lds);

              if ($ldge["count"]>0) {
                  $z=array();
                  for ($n=0 ; $n < $ldge["count"] ; $n++){
                      $z[]=$ldge[$n]["cn"][0];
                  }
                  $a[]=array("label"=>$type,"children"=>$z);
              }
          }
        } catch (\Exception $e) {}
      }
    }

    return $a;
}

function GetUsers() {
    global $config;

    if (isset($config["LDAPCustomUsersFilter"])) return GetCustomUsers();

    if (!isset($config['LDAPserver'])) return array();

    $ds=ldap_connect(__LDAP_HOST);
    $lds = ldap_search($ds, "ou=utilisateurs,".__LDAP_BASE_DN_EXTENSION.",".__LDAP_BASE_DN, "(&(objectclass=ENTPerson)(objectclass=person))", array("uid","cn","ENTPersonProfils"));
    $ldge = ldap_get_entries ($ds, $lds);
    $a=array();
    for ($n=0 ; $n < $ldge["count"] ; $n++){
        // fixes #29087 Bug sur recherche LDAP si  entpersonprofils n'existe pas
        if (!isset($ldge[$n]["entpersonprofils"])) {continue;}

        $profil=$ldge[$n]["entpersonprofils"][0];
        if (!isset($a[$profil])) $a[$profil]=array();
        $a[$profil][]=array("uid"=>$ldge[$n]["uid"][0],"cn"=>$ldge[$n]["cn"][0]);
    }

    $z=array();
    foreach($a as $profil=>$uids) {
            $z[]=array("label"=>$profil,"children"=>$uids);
    }
    return $z;
}
