<?php

class ps_DB {
    var $lid = 0;           // Link ID for database connection
    var $qid = 0;           // Query ID for current query
    var $row;               // Current row in query result set
    var $record = array();  // Current row record data
    var $error = "";        // Error Message
    var $errno = "";        // Error Number
    var $dataname;          // Base


    // Database
    function dbname($dbhost,$dblogin,$dbpassword,$dbdata) {
        $this->dbhost=$dbhost;
        $this->dblogin=$dblogin;
        $this->dbpassword=$dbpassword;
        $this->dataname=$dbdata;
    }

    function close() {

      if ($this->lid) {
        if ($this->qid) {
            @mysqli_free_result($this->qid);
            $this->qid = 0;
        }

        mysqli_close($this->lid);
        $this->lid = 0;
      }
    }

    function escape($string) {
        if (!$this->lid) return "";
        return mysqli_real_escape_string($this->lid,$string);
    }

    // Connects to DB and returns DB lid
    function connect() {
        global $config;

        if (!$this->lid) {
            if(isset($this->dbhost)&&$this->dbhost!="") {
                $this->lid = mysqli_connect($this->dbhost,$this->dblogin,$this->dbpassword);
            }
            else {
                $this->lid = mysqli_connect($config['dbhost'],$config['dblogin'],$config['dbpassword']);
            }

            if (!$this->lid) {
                echo "Impossible de se connecter au host = ".$config['dbhost']."<br>";
                $this->halt("Impossible de se connecter au host = ".$config['dbhost']);
            }
        }

        if($this->dataname=="") {
            if (!@mysqli_select_db($this->lid,$config['dbname'])) {
                echo "Impossible de se connecter à la base de données = ".$config['dbname']."<br>";
                $this->halt("Impossible de se connecter à la base de données");
                return 0;
            }
        }
        else {
            if (!@mysqli_select_db($this->lid,$this->dataname)) {
                echo "Impossible de se connecter à la base de données = ".$this->dataname."<br>";
                $this->halt("Impossible de se connecter à la base de données");
                return 0;
            }
        }

        mysqli_query ($this->lid,"set character_set_client='utf8'");
        mysqli_query ($this->lid,"set character_set_results='utf8'");
        mysqli_query ($this->lid,"set collation_connection='utf8_general_ci'");

        return $this->lid;
    }


    // Runs query and sets up the query id for the class.
    function query($q) {
        if (empty($q))
            return 0;

        if (!$this->connect())
            return 0;

        if ($this->qid) {
            @mysqli_free_result($this->qid);
            $this->qid = 0;
        }

        $this->qid = @mysqli_query($this->lid,$q);
        $this->row   = 0;
        $this->errno = mysqli_errno($this->lid);
        $this->error = mysqli_error($this->lid);
        if (!$this->qid) {
            $this->halt("Requête invalide: ".$q);
        }

        return $this->qid;
    }


    // Return next record in result set
    function next_record() {
        if (!$this->qid) {
            $this->halt("Enregistrement suivant demandé sans requête.");
            return 0;
        }


        $this->record = @mysqli_fetch_array($this->qid);
        $this->row   += 1;
        $this->errno  = mysqli_errno($this->lid);
        $this->error  = mysqli_error($this->lid);

        $stat = is_array($this->record);
        return $stat;
    }


    // Field Value
    function f($field_name) {
        return stripslashes($this->record[$field_name]);
    }

    // Selective field value
    function sf($field_name) {
        global $vars, $default;

        if ($vars["error"] and $vars["$field_name"])
            return stripslashes($vars["$field_name"]);
        elseif ($default["$field_name"])
            return stripslashes($default["$field_name"]);
        else
            return stripslashes($this->record[$field_name]);
    }

    // Print field
    function p($field_name) {
        print stripslashes($this->record[$field_name]);
    }

    // Selective print field
    function sp($field_name) {
        global $vars, $default;

        if ($vars["error"] and $vars["$field_name"])
            print stripslashes($vars["$field_name"]);
        elseif ($default["$field_name"])
            print stripslashes($default["$field_name"]);
        else
        print stripslashes($this->record[$field_name]);
   }

    // Returns the number of rows in query
    function num_rows() {
    if ($this->lid)
        return @mysqli_num_rows($this->qid);
    else
        return 0;
    }

    // Halt and display error message
    function halt($msg) {
        $this->error = @mysqli_error($this->lid);
        $this->errno = @mysqli_errno($this->lid);
        if ($fp1 = @fopen("error.txt","a+")){
            $string1  = date("d-m-Y H:i")." Erreur de BD   :".$msg."\n";
            $string1 .= date("d-m-Y H:i")." Erreur MySQL :".$this->errno." -  ".$this->error.".\n";
            fputs($fp1,$string1);
        }
    }
}
?>
