<?php 
	$dbprofil = new ps_db;
    $dbprofil->dbname($config["dbhostprofil"],$config["dbloginprofil"],$config["dbpasswordprofil"],$config["dbnameprofil"]);

  $matchingAttributes = array();
	$matchingProfile    = array();
	$tbattrs 	= array();		// Liste des attributs associés à l'utilisateur
	$tbprofs 	= array();		// Liste des profils associés à l'utilisateur
	$tbitem		= array();		// Liste des items associés à l'utilisateur
	$tbalert	= array();		// Liste des alertes associés à l'utilisateur
	$tbcat		= array();		// Liste des catégories d'items associées à l'utilisateur
    $tbfav      = array();      // Liste des favoris associés à l'utilisateur

	$fgdebug  	= false;


    function FormatItem($libelle) {
        if ($libelle===NULL) return "";
		$libelle=str_replace("\n"    ," ",$libelle);
		$libelle=str_replace("<br>"  ," ",$libelle);
		$libelle=str_replace("<br />"," ",$libelle);
		$libelle=str_replace("<br/>" ," ",$libelle);

		return $libelle;
	}

    // On s'assure que tous les attributs son bien des tableaux
    // car sinon current échoue
    if (isset($user_datas["details"]["infos"])) {
        foreach($user_datas["details"]["infos"] as $key => $infos) {
            if (!is_array($infos)) {
                $user_datas["details"]["infos"][$key]=[""];
            }
        }
    }


	// Parcours de l'ensemble des informations détaillées de l'utilisateur
    if($fgdebug) echo "<br><br>LISTE DES ATTRIBUTS ASSOCIES";
    foreach($user_datas["details"]["infos"] as $key => $infos) {
        if($fgdebug) echo "<br><br><em>$key</em>";
        foreach($infos as $value) {
            if($fgdebug) echo "<br>".$value;

            // On recherche s'il exite un attribut parametré pour cette valeur
            $dbprofil->query("SELECT * FROM userattr WHERE attrname='".addslashes($key)."' AND attrvalue='".addslashes($value)."'");

            // Si oui on sauvegarde l'id de l'attribut
            if($dbprofil->next_record()) {
                array_push($tbattrs,$dbprofil->f('userattrid'));
                $matchingAttributes[$dbprofil->f('userattrid')] =  "$key|$value";
                if($fgdebug) echo "<span style='color: red;font_width: strong;'> >> OK</span> >> ".$dbprofil->f('userattrid');
            }            
        }
    }


	// Pour l'ensemble des attributs qui correspondent à l'utilisateur
	if($fgdebug) echo "<br><br>LISTE DES PROFILS ASSOCIES";
	$tbprofs=array();
	$tbprofsname=array();
	while ($idattr = current($tbattrs)) {
		// On parcourt l'ensemble des profils associés
		$dbprofil->query("SELECT * FROM userattrprofile, profile WHERE userattrid=$idattr AND userattrprofile.profileid=profile.profileid");
		while ($dbprofil->next_record()) {
			if(!in_array($dbprofil->f('profileid'),$tbprofs)) {
				if($fgdebug) echo "<br>".$dbprofil->f('name');
				array_push($tbprofs,$dbprofil->f('profileid'));
				array_push($tbprofsname,$dbprofil->f('name'));
				$matchingProfile[$dbprofil->f('profileid')] = $matchingAttributes[$dbprofil->f('userattrid')];
			}
		}
		next($tbattrs);
	}


	// Ajouter qu'il arrive l'utilisateur par défaut
	$dbprofil->query("SELECT * FROM profile WHERE name='main_user'");
	if ($dbprofil->next_record()) {
		if(!in_array($dbprofil->f('profileid'),$tbprofs)) {
			if($fgdebug) echo "<br>".$dbprofil->f('name');
			array_push($tbprofs,$dbprofil->f('profileid'));
			array_push($tbprofsname,$dbprofil->f('name'));
		}
	}

	// Initialiser les catégories d'item à 0 si catégorie est null
	$dbprofil->query("UPDATE desktopitem SET categorie=0 WHERE categorie IS NULL");

    // Protocole
    if(isset($_SERVER['HTTPS'])){
        $protocol = ($_SERVER['HTTPS'] && $_SERVER['HTTPS'] != "off") ? "https" : "http";
    }
    else{
        $protocol = 'http';
    }

	// Pour l'ensemble des items qui correspond à l'utilisateur
	if($fgdebug) echo "<br><br>LISTE DES ITEMS ASSOCIES";
	$tbidcat=array();
	$tbidite=array();
    while ($idprof = current($tbprofs)) {
		// On regarde s'il y a des items non rattachés à des catégories
		$dbprofil->query("SELECT * FROM profiledesktopitem, desktopitem WHERE profiledesktopitem.profileid=$idprof AND profiledesktopitem.desktopid=desktopitem.desktopid AND (desktopitem.categorie=0 OR desktopitem.categorie='') LIMIT 1");
		if ($dbprofil->next_record()) {
			if(!in_array(0,$tbidcat)) {
			if($fgdebug) echo "<br>CAT = Aucune Catégorie";
				array_push($tbidcat,'0');
				$tmpcat=array("id" => "0", "name" => "Aucune Catégorie", "icon" => "fa-square", "color" => "#929292","order" => 100);
				array_push($tbcat,$tmpcat);
			}
		}

		// On parcourt les catégories
		$dbprofil->query("SELECT * FROM profiledesktopitem, desktopitem, catitem WHERE profiledesktopitem.profileid=$idprof AND profiledesktopitem.desktopid=desktopitem.desktopid AND catitem.id=desktopitem.categorie ORDER BY catitem.order,catitem.name");
		while ($dbprofil->next_record()) {
			if(!in_array($dbprofil->f('id'),$tbidcat)) {
				if($fgdebug) echo "<br>CAT = ".str_replace("<br />"," ",$dbprofil->f('name'));
				array_push($tbidcat,$dbprofil->f('id'));
				$tmpcat=array("id" => $dbprofil->f('id'), "name" => $dbprofil->f('name'),"icon" => $dbprofil->f('icon'),"order" => $dbprofil->f('order'),"color"=>$dbprofil->f('color'));
				array_push($tbcat,$tmpcat);
			}
		}

        // avec la categorie
		$dbprofil->query("SELECT * FROM profiledesktopitem, desktopitem WHERE profiledesktopitem.profileid=$idprof AND profiledesktopitem.desktopid=desktopitem.desktopid ORDER BY desktopitem.indice, desktopitem.libelle");
		while ($dbprofil->next_record()) {
			if(!in_array($dbprofil->f('desktopid'),$tbidite)) {
				if($fgdebug) echo "<br>CAT = ".$dbprofil->f('categorie')." >> ITEM = ".str_replace("<br>"," ",str_replace("<br />"," ",$dbprofil->f('libelle')));

                $url=$dbprofil->f('url');
                if(stripos(" ".$url,"/")==1&&$dbprofil->f('weburl')!=$config['host']) {
                    $url=$protocol."://".$dbprofil->f('weburl').$url;
                }

                $tmpitem = array("id" => $dbprofil->f('desktopid'),
																 "name" => FormatItem($dbprofil->f('name')),
																 "libelle" => FormatItem($dbprofil->f('libelle')),
																 "url" => $url,"icon" => $dbprofil->f('icon'),
																 "categorie" => $dbprofil->f('categorie'),
																 "profile"  => $matchingProfile[$idprof],
																 "badge_type" => $dbprofil->f('badge_type'),"badge_url" => $dbprofil->f('badge_url'),"badge_message" => $dbprofil->f('badge_message'),"mode"=>$dbprofil->f('mode'));
                array_push($tbidite,$dbprofil->f('desktopid'));
				array_push($tbitem,$tmpitem);
			}
		}
		next($tbprofs);
	}

    // Prise en compte un attribut SSO 'applications' qui liste les applications pour le user
    // TODO: Rendre le paramètre 'applications' configurable
    if (array_key_exists("infos",$user_datas["details"]) &&
        array_key_exists("applications",$user_datas["details"]["infos"]))
    {
        $allCat=Array();
        $dbprofil->query("SELECT * FROM catitem");
        while ($dbprofil->next_record()) {
            array_push($tbidcat,$dbprofil->f('id'));
            $tmpcat=array("id" => $dbprofil->f('id'), "name" => $dbprofil->f('name'),"icon" => $dbprofil->f('icon'),"order" => $dbprofil->f('order'),"color"=>$dbprofil->f('color'));
            array_push($tbcat,$tmpcat);
         }

        $listeDesApps=$user_datas["details"]["infos"]["applications"];
        $apps='"' . implode('","', $listeDesApps) . '"';
        $dbprofil->query("SELECT * FROM desktopitem WHERE desktopitem.name in ($apps)");

        while ($dbprofil->next_record()) {
            $url=$dbprofil->f('url');
            if(stripos(" ".$url,"/")==1&&$dbprofil->f('weburl')!=$config['host']) {
                $url=$protocol."://".$dbprofil->f('weburl').$url;
            }
            $tmpitem = array("id"       => $dbprofil->f('desktopid'),
                             "name"     => FormatItem($dbprofil->f('name')),
                             "libelle"  => FormatItem($dbprofil->f('libelle')),
                             "url"      => $url,
														 "profile"  => "sso",
                             "icon"     => $dbprofil->f('icon'),
                             "categorie"=> $dbprofil->f('categorie'),
                             "badge_type"=>$dbprofil->f('badge_type'),"badge_url" => $dbprofil->f('badge_url'),"badge_message" => $dbprofil->f('badge_message'),
                             "mode"     => $dbprofil->f('mode'));
            array_push($tbitem,$tmpitem);
        }

    }


	// Pour l'ensemble des alertes qui correspond à l'utilisateur
	if($fgdebug) echo "<br><br>LISTE DES ALERTES ASSOCIES";
	$tbidalt=array();
	reset($tbprofs);
    while ($idprof = current($tbprofs)) {
		// On parcourt l'ensemble des onglets qui correspondent à l'utilisateur
        // avec la categorie
		$dbprofil->query("SELECT idalert,titrealert,typealert,rssalert,nbalert FROM profilealert, alert WHERE profilealert.profileid=$idprof AND profilealert.alertid=alert.idalert ORDER BY alert.orderalert");
		while ($dbprofil->next_record()) {
			if(!in_array($dbprofil->f('thumbid'),$tbidalt)) {
				if($fgdebug) echo "<br>Alert = ".str_replace("<br />"," ",$dbprofil->f('titrealert'));
                $tmpalert = array("id" => $dbprofil->f('idalert'),"titre" => $dbprofil->f('titrealert'),"type" => $dbprofil->f('typealert'),"rss" => $dbprofil->f('rssalert'),"maxrss" => $dbprofil->f('nbalert'));
				array_push($tbalert,$tmpalert);
			}
		}
		next($tbprofs);
	}

    // L'ensemble des favoris qui correspond à l'utilisateur
    if($fgdebug) echo "<br><br>LISTE DES FAVORIS";
    $tbfav=array();
    $dbprofil->query("SELECT * FROM bookmark WHERE login='".$_SESSION['user_login']."' ORDER BY indice, libelle");
    while ($dbprofil->next_record()) {
        if($fgdebug) echo "<br>Fav = ".str_replace("<br />"," ",$dbprofil->f('url'));
        $tmp=array('url'=>$dbprofil->f('url'),'libelle'=>$dbprofil->f('libelle'),'icon'=>$dbprofil->f('icon'));
        array_push($tbfav,$tmp);
    }

?>
