// VERSION : 1.1f


// Init $envole
$envole={}
$envole.xdesktop={}
$envole.xdesktop.callback="controllers/infosplus.php"

var postitTimeout=undefined                         // Timeout pour l'affichage du postit
var timerOfverificationDesSourcesChargees=undefined // Timer permettant de vérifier que toutes les sources sont chargées

$mxdesktop={

    currentSource:ko.observable({}),
    popups:ko.observableArray([]),
    config:[],

    appWaitTimeLoading:30,  // Temps d'attente (en secponde) du chargement d'une appli, avant de dire qu'elle est HS
    sourcesWaitTimeLoading:20,  // Temps d'attente (en seconde) d'attente pour vérifier les sources
    sourceTimeAlive:25,	       // Interval en minutes de vérification des sources

    appName:"Mes applications",
    allCategorie:"Toutes",
    favorisCategorie:"favoris",
    notificationsCategorie:"notifications",
    inprogressCategorie:"encours",
    categorieIcone:"fa-folder",
    searchCategorie:"search",
    defaultCategorieIcon:"fa-square",
    defaultCategorieColor:"#5d83aa",
    unableToLoadSourceMsg:"Impossible de charger les ressources pour cet établissement",
    mixedContentMessage:"<b>Pour des raisons de sécurité</b>,<br> les URL en http sont bloquées dans un environnement sécurisé en https.<br>Cette application, s'est donc ouverte dans un nouvel onglet de votre navigateur",
    appErrorMessage:"Une erreur est survenue au chargement de cette application, veuillez cliquer sur le lien suivant pour essayer de l'ouvrir dans une nouvelle fenêtre",
    appExternalMessage:"Cette application a été ouverte dans un nouvel onglet",
    appLoadingMessage:"<i class='fa fa-spinner fa-spin'></i> Veuillez patienter...",


    isSmall:ko.observable($(window).width()<960 ),
    fromCache:ko.observable(false),

    // Par défaut, pas de cache
    nocache:true,

    log: function(msg) {
        $(".starter-template .help").html(msg);
    },


    clearCache: function() {
        $.ajax({
            url: "api/user/profil/clear",method:"post"
        }).success(function(data) {
            console.log("Clear cache OK");
        })
    },

    // Retourne la valeur de la configuration
    CONF:function(key) {
        return MX.config[key];
    },

    // Retourne la valeur booléene de la configuration
    isCONF:function(key) {
        var val=MX.CONF(key)
        if (val==undefined) return false;
        try {
            return JSON.parse(val);
        } catch (ex) {
            return false;
        }
    },

    closeTips:function() {
        var arr=MX.categories();
        for (var z=0;z<arr.length;z++) {
            // Suppression des qtip, s'il existe
            for (var i=0;i<arr[z].apps().length;i++) {
                var a=arr[z].apps()[i];
                if (a.qtip) {
                    $("#qtip-"+a.id).destroy(true)
                    $("#qtip-"+a.id).remove();
                    a.qtip=undefined
                }
            }
        }
    },
 
    isFirefox:function() {
        return navigator.userAgent.indexOf("Firefox") != -1
    },

    // Export des applications
    save: function() {

        // Pas de sauvegarde du profil si cela vient du chache ou
        // si déja sauvegardé
        if ($mxdesktop.fromCache() || $mxdesktop.cacheSaved) return;

        console.log("Sauvegarde du profil")

        if ($mxdesktop.partial) {
            console.log("-> La sauvegarde est impossible, car le chargement est partiel")
            return;
        }

        // Servers
        var servers=[];
        for(var key in MX.servers) { 
            var server = MX.servers[key]; 
            servers.push(exportObject(server));
        }

        // Export des categories
        var categories=[];
        for (var i=0;i<this.categories().length;i++) {
            var c=exportObject(this.categories()[i]);
            categories.push(c)
        }

        // Export des sources avec les apps
        var sources=[];
        for (var i=0;i<this.sources().length;i++) {
            var source=this.sources()[i];

            if (source.error()) {
                console.log("La source "+source.nom+" est en erreur");
                console.log("Sauvegarde abandonnée");
                return;
            }

            if (source.apps().length==0 && ! source.noapps) {
                console.log("La source "+source.nom+" n'a remontée aucune application");
                console.log("Sauvegarde abandonnée");
                return;
            }

            var s=exportObject(source);

            var apps=source.apps();s.apps=[];
            for (var z=0;z<apps.length;z++)
            {
                s.apps.push(exportObject(apps[z]))
            }
            sources.push(s);
        }

        var data={servers:servers,categories:categories,sources:sources};
        console.log("Sauvegarde du profil applicatif");
        console.log(data);
        $mxdesktop.cacheSaved=true;

        $.ajax({
            url: "api/user/profil/"+($mxdesktop.profil || "local")+"/apps",method:"post",data:{apps:JSON.stringify(data)}
        }).success(function(data) {
            console.log("Sauvegarde OK");
            
        })

    },

    restore:function(data) {

        if ($mxdesktop.nocache) return;

        try  {

            if (!data.apps) {return}

            console.debug("Utilisation du cache");

            $mxdesktop.fromCache(true);
            data=JSON.parse(data.apps)
    
            $mxdesktop.categories.removeAll();
            $mxdesktop.applications.removeAll();

            // Récupération des servers
            var servers=data.servers;
            for (var i=0;i<servers.length;i++) {
                var server=new Server(servers[i]);
                $mxdesktop.servers[server.id]=server;
            }

            // Récupération des catégories
            var categories=data.categories;
            for (var i=0;i<categories.length;i++) {
                var categorie=new Categorie(categories[i]);
                $mxdesktop.listeDesCategories[categorie.id]=categorie;
            }

            // Récupérations des sources et appli
            var sources=data.sources;
            console.debug(sources.length+ " source(s) trouvées")
            for (var i=0;i<sources.length;i++) {
                var source=new Source(sources[i]);
                console.debug(" => Ajout d'une nouvelle source '"+sources[i].nom+"'")
                console.debug(sources[i])
                        
                // Récup des appli
                for (var z=0;z<sources[i].apps.length;z++) {
                    var a=sources[i].apps[z]
                    a.source=source;
                    var app=new App(a);
                            
                    if ($mxdesktop.listeDesCategories[app.categorie]) {
                        $mxdesktop.listeDesCategories[app.categorie].addApp(app);
                        if (app.favoris && app.categorie != $mxdesktop.favorisCategorie) {
                            console.log(app.nom + " add to fav");
                            $mxdesktop.listeDesCategories[$mxdesktop.favorisCategorie].addApp(app); 
                        }
                        //$mxdesktop.listeDesCategories[$mxdesktop.allCategorie].apps.push(app);
                        $mxdesktop.listeDesApplications[app.id]=app;
                    } else
                    {
                       console.log(app.nom+" categorie '"+app.categorie+"' introuvable");
                    }
                            
                } // Fin récup appli

                // Y a t'il une fédération à faire avant ?
                if (source.federationBefore)   
                {
                    console.log("FederationBefore: "+source.nom+" url="+source.federationBefore)
                    $frame=$('<iframe width=0 height=0 style="display:none;">');
                    $("body").append($frame)
                    $frame.attr("src",source.federationBefore)
                }

                $mxdesktop.listeDesSources[source.id]=source;
                $mxdesktop.sources.push(source)
                if (!source.lancerLaFederation()) source.getMessages();
                source.alive()
                source.loading(false);
                source.status(SOURCE_STATE.ENDED)


                // Activation de la source liée au portail xdesktop
                if (source.type != "COMMUNE") {
                    var bActive=MX.config["numero_etab"].toUpperCase() == source.uaj
                    for (var z=0;z<source.servers().length;z++) {if (source.servers()[z]) {source.servers()[z].selected(bActive)}}
                    if (bActive) MX.currentSource(source);
                }


            } // Fin récup sources

            
            $mxdesktop.verificationDesSourcesChargees()

            $envole.xdesktop.createInfosPlus(10); // Dans 10 ms

            // On demande en background de rafraichir le cache dans 1min
            setTimeout(function() {
                var sep="?";
                if (document.location.href.indexOf("?")!=-1) sep="&";
                $("#cache").attr("src",document.location.href+sep+"nocache&noui");
            },60000)

       } catch (ex) {
            console.log("Erreur lors du traitement du cache des apps")
            console.log(ex)
            // Si une erreur survient lors de la restauration du cache et qu'il y a au moins une source chargée
            // on va recharger la page sans utilisation du cache
            if ($mxdesktop.sources().length!=0) {
               window.location.href=window.location.href+'?nocache'
	    }
            $mxdesktop.fromCache(false);
            return false;
       }
       return true;
    },

    // Permet de selectionnier la source lié au portail actuel
    selectDefaultSource: function() {
        for (var i=0;i<MX.sources().length;i++)
        {
            if (MX.sources()[i].isCurrent()) MX.sources()[i].select()
        }
    },

    addSource: function(source) {
        var s=MX.getSource(source.id);
        if (s) {return}
        MX.sources.push(source);


        source.load()
    },

    validerSource: function() {
        var arrSources=MX.sources();
        for (var z=0;z<arrSources.length;z++) {
            arrSources[z].status(SOURCE_STATE.ENDED);
        }

    },

    // ==== Création d'un objet App : contient tous les attributs pour décrire une appli 
    createApp: function(attributs) {

	   // Si pas de libelle ou pas de nom on ne va pas créer d'application
	   if (!attributs.libelle || ! attributs.nom) return null;

           // Si icon commence par / on préfix par l'url de la source
           if (attributs.icon!=undefined && attributs.icon.indexOf("/")==0 && attributs.source.baseurl != undefined) {
                attributs.icon=attributs.source.baseurl+attributs.icon;
           }

           // Si url commence par / on préfix par l'url de la source
           var urlBase=attributs.url
           if (attributs.url && attributs.url.indexOf("/")==0 && attributs.source.baseurl != undefined) {
                urlBase=attributs.url;
                attributs.url=attributs.source.baseurl+attributs.url;
           }

           // Fixes: #8301, normalisation du nom des categories
           if (!attributs.categorie) attributs.categorie=""
           attributs.categorie=attributs.categorie.normalize()
    
           app= new App({libelle:attributs.libelle,
                   libellecours:attributs.libellecours || attributs.libelle,
                   icon:attributs.icon,
                   url:attributs.url,
                   urlBase:urlBase,
                   favurl:attributs.favurl || attributs.url,
                   listesDesUrl:[],
                   source:attributs.source,
                   nom:attributs.nom,
                   server:attributs.server,
                   infos:attributs.infos,
                   infosChecked:[],
                   favoris:false,
                   external:attributs.external || false,
                   categorie:attributs.categorie})
           return app;
    },

    toogleMode:function() {
        var b=MX.isModeReduit();
        MX.isModeReduit(!MX.isModeReduit());
    },

    modeNormal:function() {
        MX.isModeReduit(false)
    },

    modeReduit:function() {
        MX.isModeReduit(true)
    },

    selectAll:function() {
        $mxdesktop.allSelected(true);
        Categorie.selectAll(true);
        MX.appOpened(false);
        MX.isAccueil(false)
        // ref: #10382, lors de la selection de toutes les applis
        // on efface la zone de recherche
        MX.searchApp(""); 
        $mxdesktop.currentCategorie(MX.allCategorie)
        setTimeout(function() {MX.enableDragAndDrop();},500);

        // ref #9352, On va rafraichir les badges
        $envole.xdesktop.createInfosPlus(10);

    },

    // ref: #10382: Annulation de la recherche
    cancelSearch:function() {
       MX.searchApp("");
    },

    onAfterAddApp:function(domNode) {
        $(domNode).find(".badge-tool").tooltip({html:true,container:'body'})
        //console.log("Apps added")
    },

    closePopup:function() {MX.popups.removeAll();MX.popupClosed=true},

    closeAppInfos:function() {
        
    },

    Initialisation:function() {
        if ($mxdesktop.initialized) return;

        $mxdesktop.initialized=true
        $mxdesktop.log("Chargement...")
        $mxdesktop.title=$(".navbar-brand").html()



        $mxdesktop.listeDesApplications={}
        $mxdesktop.listeDesCategories={}
        $mxdesktop.listeDesSources={}
        
        $mxdesktop.listeDesUrl={}
        $mxdesktop.tableauDesReog=[]
        $mxdesktop.nomDesApplications={}
        $mxdesktop.servers={}

        // Création de la structure KO
        $mxdesktop.sources=ko.observableArray([]);
        $mxdesktop.categories=ko.observableArray([]);
        $mxdesktop.applications=ko.observableArray([]);
        $mxdesktop.encours=ko.observableArray([]);
        $mxdesktop.isAccueil=ko.observable(false);
        $mxdesktop.appOpened=ko.observable(false);
        $mxdesktop.appClosed=ko.computed(function() {return ! MX.appOpened()});
        $mxdesktop.currentApp=ko.observable(null);

        $mxdesktop.currentCategorie=ko.observable(MX.allCategorie)
        $mxdesktop.byCategorie=ko.observable(true)
        $mxdesktop.topWindow=(window==window.top);

        $mxdesktop.username=ko.observable("");

        // fixes: #11301 unresponsive script, permet de retarder les listeners sur applications 
	    $mxdesktop.applications.extend({ rateLimit: 500 });
        
        $mxdesktop.isModeReduit=ko.observable(false);
        $mxdesktop.appsInfosVisivle=ko.observable(true);

        $mxdesktop.allSelected=ko.observable(true);

        $mxdesktop.searchApp=ko.observable("");
        $mxdesktop.searchAppLeft=ko.observable("");

        // Enregistrement des éléments qui seront saugegardés---
        CONF.register("BY_CATEGORIE",$mxdesktop.byCategorie)
        CONF.register("MODE_REDUIT",$mxdesktop.isModeReduit)
        CONF.register("CURRENT_CATEGORIE",$mxdesktop.currentCategorie,function(categorie){
            var cat=MX.listeDesCategories[categorie]
            if (cat) {cat.select();}

            if (categorie == "ACCUEIL") {
                console.log("Callback CURRENT_CATEGORIE is " + cat)
                MX.accueil()
            }
        })

        // Juste un callback, lorsque le appOpened est appelé 
        CONF.register("!APP_OPENED",$mxdesktop.appOpened,function(value) {
            if (!value) MX.searchAppLeft("");
        });



        // ------------------------------------------------------
        
        catFav=new Categorie({id:$mxdesktop.favorisCategorie,name:"Mes Favoris",color:"#FF7c7c",icone:'fa-star',indice:-100});
        $mxdesktop.listeDesCategories[catFav.id]=catFav

        // Soyons à l'écoute des InfosPlus (récupération des badges)

        // Listener sur l'ajout d'un badge
        document.addEventListener("addinfosplusEvent", function(event) {$mxdesktop.OnAddInfoPlus(event)}, false);

        // Listener sur le chargement d'un badge
        document.addEventListener("startinfosplusEvent", function(event) {$mxdesktop.OnStartInfoPlus(event)}, false);

        // Listener sur la fin de chargement d'un badge
        document.addEventListener("stopinfosplusEvent", function(event) {$mxdesktop.OnStopInfoPlus(event)}, false);

        // Listener sur le changement de mode d'affichage (provenant du parent)
        document.addEventListener("modereduit", function(event) {$mxdesktop.modeReduit()}, false);
        document.addEventListener("modenormal", function(event) {$mxdesktop.modeNormal()}, false);

        window.modeReduit=$mxdesktop.modeReduit;
        window.modeNormal=$mxdesktop.modeNormal;
  
        setInterval(function()
        {
            for (var i=0;i<MX.encours().length;i++) {
                var app=MX.encours()[i]
                if (app.wnd!=undefined && app.wnd.closed) app.close();
            }
        },1000);

        // Récupération des infos sur le user
        $.ajax({
                url: "api/me",method:"get",async:"false",dataType: "json"
        }).success(function(data) {
            MX.user=data
            MX.username(MX.user.cn);
        })
  
        // On va lancer la récupération des items de bureau
        // Le menu sera construit après parsing du (ou des) xml reçu
        // On essaie d'abord de récupérer le cache
        if (!$mxdesktop.nocache) {
            $.ajax({
                url: "api/user/profil/"+($mxdesktop.profil || "local")+"/apps",method:"get",async:"false",dataType: "json"
            }).success(function(data) {
                if (!$mxdesktop.restore(data)) {
                    $mxactions.recupererLesItemDeBureau();
                }
            }).error(function() {
                $mxdesktop.nocache=true;
            })
        }
        // Pas de cache, chargement total
        if ($mxdesktop.nocache)
        {
            console.log("Chargement du bureau sans le cache")
            $mxdesktop.fromCache(false);
            $mxactions.recupererLesItemDeBureau();
        }

        if (!$mxdesktop.noui) {
            ko.applyBindings(MX,$("body")[0]);
        }

        CONF.load();
        
    },

    verificationDesSourcesChargees: function() {
      
        var arrSources=MX.sources();
        var bOK=true
        for (var z=0;z<arrSources.length;z++) {
            if (arrSources[z].status()!=SOURCE_STATE.ENDED) {
                console.log(arrSources[z].nom+" non chargé status="+arrSources[z].status()+"")
                bOK=false;break;
            }
        }

        MX.enableDragAndDrop();

	// Une seule source => on va la selectionner
        if (arrSources.length==1) {
            arrSources[0].select(true)
        }

        // Trie des catégories ( ref: #8322)
        $mxdesktop.categories.sort(function(a,b){return a.indice==b.indice?0:(a.indice<b.indice ? -1:1)});

        // Favoris : On enleve ici les apps dans leur categorie s'il sont aussi dans les favoris
        var catFav=MX.listeDesCategories[MX.favorisCategorie]
        var arr= catFav.apps();
        for (var z=0;z<arr.length;z++) {
            // fixes: #11303 : Si la categorie de l'app est celle des favoris on ne la retire pas
            if (arr[z].oCategorie.id==catFav.id) continue
            arr[z].oCategorie.apps.remove(arr[z])
        }

        // Trie des applis dans les catégories
        var arr= $mxdesktop.categories();
        for (var z=0;z<arr.length;z++) {
            arr[z].apps.sort(function(a,b){return a.libellecours==b.libellecours?0:(a.libellecours<b.libellecours ? -1:1)});
        }

        if (bOK) {
            $mxdesktop.save()
        }

    },

    enableDragAndDrop: function() {
        $("li.appli").draggable({helper: 'clone', appendTo: '.MyContainer',scroll: false});

        $("#liToutes").droppable({
          accept: "li[favoris='true']",activeClass: "ui-state-hover",hoverClass: "ui-state-active",
          drop: function( event, ui ) {
                appid=ui.draggable.attr("appid")
                var app=MX.app(appid);if (!app) return ; 
                app.removeFromFavoris()
          }
        })

        $("#lifavoris").droppable({
          accept: "li[favoris!='true']",activeClass: "ui-state-hover",hoverClass: "ui-state-active",
          drop: function( event, ui ) {
                appid=ui.draggable.attr("appid")
                var app=MX.app(appid);if (!app) return ; 
                app.addToFavoris()
          }
        })
    },

    reorganisationApp: function(newapp,app,affectation)
    {

       // Changement de categorie  
       if (newapp.categorie != undefined && newapp.categorie!="") 
       {
            
            newCategorie=$mxdesktop.listeDesCategories[newapp.categorie]    
            if (newCategorie != undefined && app.categorie!=newapp.categorie )
            {
                if (affectation) {
                    // Suppression de l'ancienne categorie
                    $mxdesktop.listeDesCategories[app.categorie].apps = jQuery.grep($mxdesktop.listeDesCategories[app.categorie].apps , 
                                                                    function (value) {return value.id != app.id;});
                    $mxdesktop.listeDesCategories[app.categorie].addApp(app)
                }
                app.categorie=newapp.categorie
                
            } 
        }
        if (newapp.icon!=undefined && newapp.icon!= ""  ) app.icon=newapp.icon
        if (newapp.nom!=undefined  && newapp.nom!= "" ) app.nom=newapp.nom
        if (newapp.url!=undefined  && newapp.url!= "" ) app.url=newapp.url
        if (newapp.libelle!=undefined  && newapp.libelle!= "" ) app.libelle=newapp.libelle
        if (newapp.libellecours!=undefined  && newapp.libellecours!= "" ) app.libellecours=newapp.libellecours 
        if (newapp.hidden!=undefined  && newapp.hidden!= "" ) app.hidden=newapp.hidden
        if (newapp.infos.url!=undefined  && newapp.infos.url!= "" ) app.infos.url=newapp.infos.url
        if (newapp.external!=undefined  && newapp.external!= "" ) app.external=$.parseJSON(newapp.external);
        
    },


    getSource:function(id) {
        return ko.utils.arrayFirst(MX.sources(), function(item) {return id === item.id;})
    },

    /* construit les categories depuis xml_string
     */
    GetCategories: function(xmlDoc,options) {
        //var xmlDoc = $.parseXML( xml_string )
        var $xml = $( xmlDoc )
        src=options.id ;

        // Pas de source trouvé, on ne fait rien
        var source = MX.getSource(options.id)
        if (source==undefined)
        {
            console.error("Aucune source ne correspond à id="+options.id)
            return;
        }

        console.log("-> Réception de la source "+source.nom+" id="+source.id)

        // récupération du referer si il éxiste
        if (options.referer!=undefined)
        {
            a=options.referer.split("/");   
            source.baseurl=a[0]+"//"+a[2];
        }

        if (options.userinfos) {
            options.userinfos=$("<div/>").html(options.userinfos).text();
            source.userinfos=JSON.parse(options.userinfos);
        }

        if (options.favoris) {
            source.favoris=$("<div/>").html(options.favoris).text();
        }

        $mxdesktop.listeDesSources[source.id]=source;

        // Récupération des infos sur la source
        if ($xml.find("description").length!=0)
        {
            $el=$($xml.find("description")[0]);
            if ($el.find("icon").length!=0)         {srcicone = $xml.find("icon")[0].textContent;source.icone=srcicone}
            if ($el.find("nom").length!=0)          {srcnom = $xml.find("nom")[0].textContent;source.nom=srcnom}
            if ($el.find("type").length!=0)         {type = $xml.find("type")[0].textContent;source.type=type}
            // Récupération de l'url de services 
            if ($el.find("services_url").length!=0) 
            {
                surl = $xml.find("services_url")[0].textContent;
                source.services_url=decodeURIComponent(surl)
            }
            
            if ($el.find("federationBefore").length!=0)   
            {
                lienDeFederation=$xml.find("federationBefore")[0].textContent
                $frame=$('<iframe width=0 height=0 style="display:none;">');
                $("body").append($frame)
                source.federationBefore=lienDeFederation;
                $frame.attr("src",lienDeFederation)
            }
        }

        // Définition d'un server
        if ($xml.find("servers").length!=0) {
            $el=$($xml.find("servers")[0]);
            $el.find("server").each(function(){
                srvid=xmlText(this,'id');
                srvnom=xmlText(this,'nom');
                srvicone=xmlText(this,'icone');
                server=new Server({id:srvid,nom:srvnom,icone:srvicone})
                MX.servers[server.id]=server
            })
        }

        // Nouvelles Url a charger 
        $xml.find("others").each(function(){
            srcnom=xmlText(this,'nom');
            ressource=decodeURIComponent(xmlText(this,'ressource')); 
            federation=decodeURIComponent(xmlText(this,'federationBefore')); 
            icone=xmlText(this,'icone');
            couleur=xmlText(this,'couleur');
            baseurl=xmlText(this,'baseurl');
            message_url=xmlText(this,'message_url');
            uaj=xmlText(this,'uaj') || "";
            services_url=decodeURIComponent(xmlText(this,'services_url'));

            federer=decodeURIComponent(xmlText(this,'federer'));
            data=decodeURIComponent(xmlText(this,'data'));

            var othersource=new Source({url:ressource,nom:srcnom,federer:federer,data:data,baseurl:baseurl,uaj:uaj,
                        callback:"controllers/callback.php",encode:true,icone:icone,couleur:couleur,
                        message_url:message_url,services_url:services_url,id:RANDOM()})
            MX.addSource(othersource)
            
            //$mxdesktop.listeDesOthersSources[othersource.id]=othersource;
            // Si url de fédération, on fédère d'abord via une iframe
            // et sur un onLoad on ajoute la source
            /*if (federation != undefined && federation != "" )
            {
                 console.log("Une fédération est nécessaire pour "+othersource.nom)
                 var $frame=$('<iframe width=0 height=0 style="display:none;">');
                 $("body").append($frame)
                 $frame.attr("src",federation)
                 $frame.load(othersource,function(event) {
                    console.log("-> FédérationBefore terminée pour "+event.data.nom)
                    setTimeout(event.data.load,2000);
                 })

            } else
            {
                MX.sources.push(source);
                source.load();
            }*/
        })


        // Récupération des paramètres des catégories si pas de categories par defaut
        if ($mxdesktop.defaultCategorie == undefined) 
        {
            $xml.find("categorie").each(function(){
            nom=xmlText(this,'nom');
            couleur=xmlText(this,'couleur') || $mxdesktop.defaultCategorieColor;
            indice=Math.abs(parseInt(xmlText(this,'indice') || "999"));
            icone=xmlText(this,'icone') || $mxdesktop.defaultCategorieIcon
            var key=nom.normalize()
            if ($mxdesktop.listeDesCategories[key] == undefined )
            {
                $mxdesktop.listeDesCategories[key]=new Categorie({name:nom,id:key,
                                                    color:couleur,
                                                    icone:icone,
                                                    indice:indice})
            }
            })
        }
        if ($xml.find("defaultCategorie").length!=0)   {$mxdesktop.defaultCategorie = $xml.find("defaultCategorie")[0].textContent;}

        // Réorganisation des app 
        $xml.find("reorg").each(function(){
            xmlapp=$(this).find("app");
            condition=xmlText(this,'condition');
            reorg={condition:condition,app:extractAppFromXml(xmlapp)}
            $mxdesktop.tableauDesReog.push(reorg)
            bFind=false
            for (key in $mxdesktop.listeDesApplications)
            {
                    app=$mxdesktop.listeDesApplications[key]
                    if (eval(reorg.condition)){bFind=true;break}
            }
            if (bFind) {
                $mxdesktop.reorganisationApp(reorg.app,app,true)   
            }
        })

        // Parse du xml
        $xml.find("buttondata").each(function(){

            // Création d'une appli
            jsonapp=extractAppFromXml(this);
            jsonapp.source=source;
            app=$mxdesktop.createApp(jsonapp);
	    if (app==null) return;

            // Vérifie s'il faut réorganiser
            for (i=0;i<$mxdesktop.tableauDesReog.length;i++)    
            {
                reorg=$mxdesktop.tableauDesReog[i];
                try {if (eval(reorg.condition))  {$mxdesktop.reorganisationApp(reorg.app,app,false) ; break;}} catch(e){}
            }

            // L'appli est marqué comme chaché, on passe à la suivante
            if (app.hidden!=undefined) return;


            // Ajoute l'url une seule fois
            if ($mxdesktop.listeDesUrl[app.url] == undefined )
            {
                $mxdesktop.listeDesUrl[app.url]=app

                // Si il y a pas de categorie, on tente de le récupérer dans le nom
                if (app.categorie=="" && nom.indexOf("/")!=-1)
                {
                    a=app.nom.split("/")
                    app.categorie=a[0];
                    if (a.length>1) app.nom=a[1];
                }

                if ($mxdesktop.listeDesCategories[app.categorie] == undefined || app.categorie=="")
                {
                    app.categorie=app.categorie || "Aucune catégorie"

                   // Si il y a une categorie par défaut, eu lieu d'en créer une on va l'utiliser, évite d'avoir 36000 catégories
                   if ($mxdesktop.defaultCategorie != undefined && $mxdesktop.listeDesCategories[$mxdesktop.defaultCategorie] != undefined ) app.categorie=$mxdesktop.defaultCategorie
                   else {
                       $mxdesktop.listeDesCategories[app.categorie]=new Categorie({name:app.categorie,
                                                                     color:$mxdesktop.defaultCategorieColor,
                                                                     icone:$mxdesktop.defaultCategorieIcon,
                                                                     indice:9999,
                                                                     apps:[]})
                   }
                }
                $mxdesktop.listeDesCategories[app.categorie].addApp(app);

                // Ajout à la liste des applications
                $mxdesktop.listeDesApplications[app.id]=app;
            }
        })


        // Traitement des favaris fournis par la source ======================
        if (source.favoris!=undefined && source.favoris!="") 
        {
            data=JSON.parse(source.favoris)
            if (data) {
                for (i=0;i<data.length;i++)
                {
                    item=data[i]
                    app=$mxdesktop.findAppByUrl(item.url)
                    if (app==null)
                    {
                        app=$mxdesktop.createApp({
                              libelle:item.libelle,icon:item.icon,url:decodeURIComponent(item.url),nom:item.libelle,
                              categorie:$mxdesktop.favorisCategorie,source:source})
                        // Appli non créée, on ne fait rien
                        if (!app) continue
                        console.log("=> "+app.nom+" to fav");
                        $mxdesktop.listeDesCategories[app.categorie].addApp(app);  
                        // Indique si l'appli a été défini par l'utlisateur (ie ne correspond pas à une url chargée par le bureau)
                        if (app) app.userdefined=true 
                    } else
                    {
                        $mxdesktop.listeDesCategories[$mxdesktop.favorisCategorie].addApp(app); 
                    }

                    // Si app existe , on la met dans les favoris
                    if (app) {
                        // Ajout à la liste des applications
                        $mxdesktop.listeDesApplications[app.id]=app;
                        app.favoris=true
                        app.isFavoris(true)
                    }
                }
            }
        } 
        // ==== Fin de traitement des favoris ===============================        


        source.getMessages();

        // Si il y a un referer (ie il y a callback, le message est en html, sinon est en text)
        message=xmlText(this,'message') ||  (source.referer?xmlHtml($xml,'message'):xmlText($xml,'message')) ;
        if (message!="" && message != undefined)
        {
            source.addMessage($.trim(message))
        }

        if (source.message==$mxdesktop.unableToLoadSourceMsg ) source.message=""

        // Sera utile pour créer les badges, qui se base sur $envole.xdesktop
        $envole.xdesktop.listeDesApplications=$mxdesktop.listeDesApplications;

        return $mxdesktop.listeDesCategories;
    },

    

    hideAll:function() {
        $(".panel").hide();
    },

    // Ajout d'un favoris
    addFavoris:function() {
        $("#myModalLabel").html(self.title+" édition");

        // Suppression du binding en cours
        ko.cleanNode($("#modal")[0]);

        // Utilisation du template knockout, postit-edit-template
        $("#modal").find(".modal-body").html('<div class="" data-bind="template: { name: \''+"favoris-dialog"+'\'}"></div>')

        // Apply viewModel bindings
        ko.applyBindings(self,$("#modal")[0]);
        
        // Affichage la boite d'édition
        MX.showModal();
    },


    addReflection:function() {
        $("icone").addClass("reflectBelow")
    },

    drawCustomScrollbar: function() {

        $("#listedesicones").mCustomScrollbar("destroy");
        height=$(".container").height()
        $("#listedesicones").css("height",height-$("#listedesicones").position().top-2); 

        // Mod enom mobile on met la scrollbar custom
        if (!IsMobile())
        {
            $("#listedesicones").mCustomScrollbar({mouseWheelPixels:100,scrollInertia:50,theme:"dark-thick",
                /*callbacks: {
                    onScroll: function() {
                        $("#postit").css("top",(-$("#listedesicones .mCSB_container").position().top)+"px");
                    }}*/
            });
            $("#listedesicones").redraw();
        }
    },

    // retourne l'objet app en fonction de son id
    app:function(appidOrApp) {
        // Pasage d'un id ou de l'appli elle même
        if (typeof(appidOrApp)=="string") return $mxdesktop.listeDesApplications[appidOrApp]
        else return appidOrApp
    },

    // Recherche une app par son url, retourne null si pas trouvé
    findAppByUrl:function(url) {
        if (!url) return null
        url=url.toLowerCase()
        
        // Si url commence par /, on vérifie aussi avec le hostname
        var url2=""
        if (url.slice(0, 1)=="/") {
            url2=window.location.protocol+"//"+window.location.hostname+url;
        }

        for (key in $mxdesktop.listeDesApplications)
        {
            var app=$mxdesktop.listeDesApplications[key]
            if (app.url.toLowerCase()==url || ( app.urlBase && app.urlBase.toLowerCase()==url ) || app.url.toLowerCase()==url2 )
            {
                return app
            }
        }
        return null;

    },

    //
    favorisAppToggle: function(appid) {
        $mxactions.favorisAppToggle($mxdesktop.app(appid))
    },

    // recharge d'une application
    reloadApp:function(appid) {},

    // fermeture d'une application
    closeApp:function(app) {
        MX.encours.remove(function(a) { return a.id == app.id })
        if (MX.encours().length!=0) {
            MX.currentApp(MX.encours()[0]);
        } else
        {
            MX.selectAll()
            MX.currentApp(null);
        }

        // ref #9352, On va lancer une récupération des badges
        $envole.xdesktop.createInfosPlus(10);

        setTimeout(AdjustHeight,500);

    },

    accueil:function() {
        MX.appOpened(false);
        MX.currentCategorie("ACCUEIL");
        MX.isAccueil(true)
	    // ref #9573, On va rafraichir les badges
        $envole.xdesktop.createInfosPlus(10)
    },



    onAppLoaded:function(iframe) {
        var appid=$(iframe).attr("appid");
        console.log(appid+ " loaded");
        var app=MX.app(appid)   
        app.loading(false)
    },

    // Ouverture d'une URL
    openApp:function(app) {

        // Si pas encore ouverte on l'ajoute
        var bOpened=false;
        var arr=MX.encours();
        for (var i=0;i<arr.length;i++) {
            if (arr[i].id==app.id) {bOpened=true; break;}
        }
        if (!bOpened) 
        {
            MX.encours.push(app);
        }

        MX.currentApp(app)
        MX.appOpened(true);
        MX.isAccueil(false)
        setTimeout(AdjustHeight,500);
        $(window).scrollTop("0px")

        return app;
    },

    // Call back Ouverture d'une categorie
    openCategorie:function(categorie) {
        $("ul.icons .badge-tool").tooltip({html:true,container:'body'})
        $(window).scrollTop("0px");
        setTimeout(AdjustHeight,500);

        // ref #9352, On va rafraichir les badges
        $envole.xdesktop.createInfosPlus(10);
    },

    carouselPrev:function(data,event) {
        $(event.currentTarget).parent().carousel("prev");
    },

    carouselNext:function(data,event) {
        $(event.currentTarget).parent().carousel("next");
    },

    carouselActive:function(data,event) {
        var index=$(event.currentTarget).attr("data-slide-to");
        $(event.currentTarget).parent().parent().carousel(parseInt(index));
    },


    // fixes #7750 : Ajout des classes CSS pour afficher les cachets
    showPostit:function() 
    {
                /*ko.cleanNode($("#postit")[0]);
                $("#postit").html('<div class="" data-bind="template: { name: \'postit-template\'  }"></div>')
                ko.applyBindings(this,$("#postit")[0]);*/

                
                /*$("#postit .rappel").each(function() {
                    $(this).prepend('<span class="fa-stack fa-lg"><i class="fa fa-square-o fa-stack-2x"></i><i class="fa fa-clock-o  fa-stack-1x"></i></span>')
                })

                $("#postit .recycle").each(function() {
                    $(this).prepend('<span class="fa-stack fa-lg"><i class="fa fa-square-o fa-stack-2x"></i><i class="fa fa-lightbulb-o fa-stack-1x"></i></span>')
                })

                $("#postit .attention").each(function() {
                    $(this).prepend('<span class="fa-stack fa-lg"><i class="fa fa-square-o fa-stack-2x"></i><i class="fa fa-exclamation-triangle fa-stack-1x"></i></span>')
                })

                $("#postit .mail").each(function() {
                    $(this).prepend('<span class="fa-stack fa-lg"><i class="fa fa-square-o fa-stack-2x"></i><i class="fa fa-comment fa-stack-1x"></i></span>')
                })

                $("#postit .important").each(function() {
                    $(this).prepend('<span class="fa-stack fa-lg"><i class="fa fa-square-o fa-stack-2x"></i><i class="fa fa-exclamation fa-stack-1x"></i></span>')
                })

                // Suppression, des balises <p> vide
                $("#postit .message").find("p").each( function() { 
                    if ($(this).text().trim()=="") {$(this).remove() } 
                })*/

                $("#postit").show()
        
    },

    stopEvent:function(data,event) {
        if (event) {
            event.stopPropagation();
        }
    },

    showModal : function()
    {
        $("#modal").find(".modal-footer button.save").unbind();    
        $("#modal").modal();  
    },

    closeModal : function()
    {
        $("#modal").find(".modal-footer button.save").unbind();    
        $("#modal").modal('hide');  
    },

    

};



// ==================================================================================
// Quelques fonction utilitaires 

// Extraction d'un noeud dans un flux xml
function xmlText(node,item) {return $(node).find(item).text()}
function xmlHtml(node,item) {return $(node).find(item).html()}

// Jquery redraw
$.fn.redraw = function(){
  $(this).each(function(){
    var redraw = this.offsetHeight;
  });
};

// Extraction au format json d'un flux xml représentant une app
function extractAppFromXml(xml)
{
    // Récupération des données depuis le xml
    infos={url:xmlText(xml,'infos_url'),
                   type:xmlText(xml,'infos_type'),
                   message:xmlHtml(xml,'infos_message')}

    // Les balises & sont transformés en &amp; , on fait donc l'inverse
    if (infos.message!=undefined) infos.message=infos.message.replace( /\&amp;/g, '&' );
    if (infos.url!=undefined) infos.url=infos.url.replace( /\&amp;/g, '&' );


    categorie=xmlText(xml,'categoriename');
    nom=xmlText(xml,'nom')
    libelle=xmlText(xml,'libelle')
    url=xmlText(xml,'url')
    favurl=xmlText(xml,'favurl') || url // Url pour stocker dans favoris
    libellecours=xmlText(xml,'libellecours') || libelle;
            
    nom=nom || libelle
    if (nom==undefined) nom="Aucun nom";

    // Determine la categorie a partir du nom (cf ancienne nomenclature)
    if ((categorie==undefined || categorie=="") && nom.indexOf("/")!=-1) {
                categorie=nom.split("/")[0];
                libelle=nom.split("/")[1];
                if (libelle=="") libelle=categorie
    }

    return  {
                 libelle:libelle,
                 libellecours:libellecours,
                 icon:xmlText(xml,'icon'),
                 server:xmlText(xml,'server'),
                 baseurl:xmlText(xml,'baseurl'),
                 url:url,
                 hidden:xmlText(xml,'hidden'),
                 external:xmlText(xml,'external')=="true",
                 nom:nom,
                 favurl:favurl,
                 infos:infos,
                 infosChecked:[],
                 favoris:false,
                 categorie:categorie.normalize()}
}


// Wrapper, pour compatibilité de infosplus qui a été créé sur le framework ajax de posh
// et non de jquery
$p={
    print: function(id,div,where) {
        if (where=="bottom") $("#"+id).append(div)
        if (where=="top") $("#"+id).prepend(div)
    }
}


function BuildInfos()   {}
function AdjustFooter() {}
function getRGB(color)  {

    if (color.indexOf("rgb(")==0) {
        var result = color.match(/\d+/g);
        return [parseInt(result[1]), parseInt(result[2]), parseInt(result[3])];
    }

    if (result = /rgb(s*([0-9]{1,3})s*,s*([0-9]{1,3})s*,s*([0-9]{1,3})s*)/.exec(color)) return [parseInt(result[1]), parseInt(result[2]), parseInt(result[3])];
    if (result = /rgb(s*([0-9]+(?:.[0-9]+)?)%s*,s*([0-9]+(?:.[0-9]+)?)%s*,s*([0-9]+(?:.[0-9]+)?)%s*)/.exec(color)) return [parseFloat(result[1]) * 2.55, parseFloat(result[2]) * 2.55, parseFloat(result[3]) * 2.55];
    if (result = /#([a-fA-F0-9]{2})([a-fA-F0-9]{2})([a-fA-F0-9]{2})/.exec(color)) return [parseInt(result[1], 16), parseInt(result[2], 16), parseInt(result[3], 16)];
    if (result = /#([a-fA-F0-9])([a-fA-F0-9])([a-fA-F0-9])/.exec(color)) return [parseInt(result[1] + result[1], 16), parseInt(result[2] + result[2], 16), parseInt(result[3] + result[3], 16)];
}

function lighter(color,alpha,percent)
{
    if (color==undefined) return "white";
    var rgb = getRGB(color);
    if (rgb==undefined) {
        console.log("rgb undefined for:"+color);
        return "white";
    }
    for(var i = 0; i < rgb.length; i++){
        rgb[i] = Math.min(Math.round(rgb[i] * (percent || 2.0)), 255);
    }
    var newColor = 'rgba(' + rgb[0] + ',' + rgb[1] + ',' + rgb[2] + ','+ (alpha || 1) +')';
    return newColor
}

//filter results based on query
function filter(selector, query) {
          query =       $.trim(query); //trim white space
          query = query.replace(/ /gi, '|'); //add OR for regex query

          count=0
          $(selector).each(function() {
              if (($(this).text().search(new RegExp(query, "i")) < 0)){
                  $(this).hide().removeClass('visible')
              } else
              {
                  $(this).show().addClass('visible');
                  count++
              }
          });
          $(selector).unhighlight()
          $(selector).highlight(query);
}


function getDefaultCategorieColor(app)
{
    if (app.categorie==$mxdesktop.allCategorie) return "white";
    // Pour le moment en dure, a recupérer depuis le chargement des items de bureau
    /*if (app.categorie.toLowerCase().indexOf("applications")!=-1) return "rgb(220,220,255)";
    if (app.categorie.toLowerCase().indexOf("administration")!=-1) return "rgb(255,220,220)";
    return "rgb("+Math.floor((Math.random()*55)+120)+","+Math.floor((Math.random()*55)+130)+","+Math.floor((Math.random()*55)+150)+")";*/
    return "rgb(92,92,92)";
}

function getFaForBadgeInfos(infos)
{
    if (infos.type=="infos") return "fa-info-circle"
    if (infos.type=="error") return "fa-times-circle"
    if (infos.type=="warning") return "fa-exclamation-triangle"
    if (infos.type=="new") return "fa-certificate"
    return "fa-circle"
}

function xshow(id)
{

}

function RANDOM() {
   return  Math.random().toString(36).substring(7);
}

// fixes: #8472: tester avec a/&é~#'{([-|è`_çà@)]=}$£ø*µù%!:;,?./§
// ne fait pas planter
String.prototype.normalize = function () {
    return this.replace(/[^a-zA-Z0-9 \s]/g,'');
};


