<?php
header('Content-type: text/xml');

if(file_exists("include.php"))
	include("include.php");
else
	$agent=0;

$scribeUrlServices = "http://".$_SERVER["SERVER_NAME"].":8090/agents/$agent";
$scribeUrlServicesTCP = "http://".$_SERVER["SERVER_NAME"].":8090/agents/$agent/tcpservices";

// Création du document et ajout CSS
$xmlDoc = new DOMDocument('1.0','UTF-8');
$css = $xmlDoc->createProcessingInstruction('xml-stylesheet', 'type="text/css" href="http://racvision.orion.education.fr/page-de-test/racvision.css"');
$xmlDoc->appendChild($css);

$implementation = new DOMImplementation();
$xmlDoc->appendChild($implementation->createDocumentType('apptest SYSTEM "http://racvision.orion.education.fr/page-de-test/apptest-1.8.dtd"'));

// Création structure XML
$rootElt = $xmlDoc->createElement('apptest');
$rootNode = $xmlDoc->appendChild($rootElt);

$approotElt = $xmlDoc->createElement('application');
$approot = $rootNode->appendChild($approotElt);

$approotAttribute = $xmlDoc->createAttribute('id');
$approotAttribute->value = 'scribe24';
$approot->appendChild($approotAttribute);

$nameElt = $xmlDoc->createElement('name','Scribe');
$approot->appendChild($nameElt);

$versionElt = $xmlDoc->createElement('version','2.4');
$approot->appendChild($versionElt);

$descElt = $xmlDoc->createElement('description','Infos du serveur scribe');
$approot->appendChild($descElt);

$availElt = $xmlDoc->createElement('availability');
$availroot = $approot->appendChild($availElt);

$availAttribute = $xmlDoc->createAttribute('available');
$availAttribute->value = 'UP';
$availroot->appendChild($availAttribute);

/*
 * GESTION DES SERVICES SUR LA PAGE PRINCIPALE
 */

$curlServices = curl_init($scribeUrlServices);
curl_setopt($curlServices, CURLOPT_RETURNTRANSFER, true);
$htmlServices = curl_exec($curlServices);

curl_close();

$DOMDocServices = new DOMDocument();
$DOMDocServices->formatOutput = true;
$DOMDocServices->loadHTML($htmlServices);

$contentDiv = $DOMDocServices->getElementById('content');

$servicesListID = $contentDiv->getElementsByTagName('a');
$servicesListSTATE = $contentDiv->getElementsByTagName('span');

foreach ($servicesListID as $key => $service) {
	$pieces = explode("/", $service->getAttributeNode('href')->nodeValue);
	$arrayIDs[] = $pieces[3];
	$arrayLibs[] = $service->nodeValue;
}

foreach ($servicesListSTATE as $key => $service) {
	$pieces = explode("-", $service->getAttributeNode('class')->nodeValue);

	switch ($pieces[1]) {
		case 'Error':
			$current_state = 'CRIT';
			break;
		case 'OK':
			$current_state = 'OK';
			break;
		default:
			$current_state = 'WARN';
			break;
	}
	$arrayStates[] = $current_state;
}

foreach ($arrayIDs as $key => $value) {

	$testElt = $xmlDoc->createElement('test');
	$testroot = $approot->appendChild($testElt);

	$testrootAttribute = $xmlDoc->createAttribute('id');
	$testrootAttribute->value = $value;
	$testroot->appendChild($testrootAttribute);

	$descElt = $xmlDoc->createElement('description',$arrayLibs[$key]);
	$testroot->appendChild($descElt);

	$stateElt = $xmlDoc->createElement('state',$arrayLibs[$key]);
	$stateroot = $testroot->appendChild($stateElt);

	$staterootAttribute = $xmlDoc->createAttribute('val');
	$staterootAttribute->value = $arrayStates[$key];
	$stateroot->appendChild($staterootAttribute);

}

/*
 * GESTION DES SERVICES TCP
 */

$curlServicesTCP = curl_init($scribeUrlServicesTCP);
curl_setopt($curlServicesTCP, CURLOPT_RETURNTRANSFER, true);
$htmlServicesTCP = curl_exec($curlServicesTCP);

curl_close();

$DOMDocServicesTCP = new DOMDocument();
$DOMDocServicesTCP->formatOutput = true;
$DOMDocServicesTCP->loadHTML($htmlServicesTCP);

$contentDivTCP = $DOMDocServicesTCP->getElementById('content');

$servicesTCPListID = $contentDivTCP->getElementsByTagName('img');
$servicesTCPListLIB = $contentDivTCP->getElementsByTagName('tr');

foreach ($servicesTCPListLIB as $key => $service) {
	if($key != 0)
		$arrayLibsTCP[] = trim(preg_replace('/\s+/S', " ", $service->nodeValue));
}

foreach ($servicesTCPListID as $key => $service) {

	$alt = $service->getAttributeNode('alt')->nodeValue;
	$src = $service->getAttributeNode('src')->nodeValue;

	if($alt == 'On' || $alt == 'Off') {
		switch ($alt) {
			case 'Off':
				$alt_ravcvision = 'CRIT';
				break;
			case 'On':
				$alt_ravcvision = 'OK';
				break;
			default:
				$alt_ravcvision = 'WARN';
				break;
		}
		$arrayStatesTCP[] = $alt_ravcvision;
	}

	if(preg_match("#agents#", $src)) {
		$pieces = explode("/", $src);
		$arrayIDsTCP[] = $pieces[3];
	}

}

foreach ($arrayIDsTCP as $key => $value) {

	$testElt = $xmlDoc->createElement('test');
	$testroot = $approot->appendChild($testElt);

	$testrootAttribute = $xmlDoc->createAttribute('id');
	$testrootAttribute->value = $value;
	$testroot->appendChild($testrootAttribute);

	$descElt = $xmlDoc->createElement('description',$arrayLibsTCP[$key]);
	$testroot->appendChild($descElt);

	$stateElt = $xmlDoc->createElement('state',$arrayLibsTCP[$key]);
	$stateroot = $testroot->appendChild($stateElt);

	$staterootAttribute = $xmlDoc->createAttribute('val');
	$staterootAttribute->value = $arrayStatesTCP[$key];
	$stateroot->appendChild($staterootAttribute);

}

// Gestion de la date
$date = date("Y-m-d H:i:s");
$dateElt = $xmlDoc->createElement('date',$date);
$rootNode->appendChild($dateElt);

echo $xmlDoc->saveXML();
