## eole-ad-dc-ou

Ce paquet permet de créer automatiquement une structure d'UO dans un domaine AD (Seth/ScribeAD)

h3. Objectif

Ce scénario décrit la mise en place de la Création d'OU et de rêgles de classification des nouveaux objets sur les modules ScribeAD et Seth DC

h3. Cas d'usage

Lors de la création d'un utilisateur, l'objet AD utilisateurs est crée dans CN=Users,<realm>. Cela vaut aussi pour les procédures d'importation de fichiers Csv, AAF, BE1d ....
De même, à l'intégration d'un ordinateur, la fiche AD est crée dans CN=Computers,<realm>

Malheureusement, tous les utilisateurs et ordinateurs se retrouvent 'en vrac' dans ces 2 conteneurs AD.
La création de GPO utilisateur peut être faite en utilisant les filtres par groupe. Mais ce n'est pas la pratique la plus courante...

L'idée de ce scénario est de permettre de décrire une organisation (Niveau, Classe, Personnes, Machines, Salle) sous forme d'une arborescence d'OU.

Une fois l'arborescence crée, l'ensemble des utilisateurs/ordinateurs présent dans le conteneur par défaut seront analysé

h3. Solutions à mettre en œuvre

* Créer un projet et un paquet
* Si possible depuis la version 2.7.2 ( en ajout de fonctionnalité, sans modifier le code de la version Stable)
* Le paramétrage est une information 'statique'. Elle sera saisie dans GenConfig
* Les règles de classement seront appliquées à l'instance, au reconfigure, et une 1fois par jour
* Sans activation, le paquet ne fait rien.
* Après l'avoir utilisé, et en désactivant les options, les OU et les objets seront laissé en l'état.

h3. Comment l'utiliser

* se connecter au serveur Scribe/Seth en 'root'
* Maj-Auto -C (le paquet est en candidat pour l'instant)
* installer le paquet 'eole-ad-dc-ou'
* aller dans gen_config et renseigner les OU dans la famille 'GPO' (activer_ad_ou et ad_ou_classifier sont à NON par défaut) 
* enregistrer la configuration
* reconfigure

C'est tout !

h3. Variables Creole

* *activer_ad_ou* 
  permet d'activer la création automatique d'une arborescence d'UO

* *activer_ad_ou_classifier*
  Activer le classement automatique des utilisateurs et ordinateurs vers une arborescence d'UO

* *ad_ou_users_source*
  Dans cette variable, vous pouvez définir l'OU d'origine dans laquelle les nouveaux utilisateurs AD sont crées
  défaut: CN=Users
  
* *ad_ou_computers_source*
  Dans cette variable, vous pouvez définir l'OU d'origine dans laquelle les nouveaux ordinateurs AD sont crées
  défaut: CN=Computers

** *ad_ou_names* 
     C'est le nom de l'OU
     Les espaces sont autorisés lors de la saisie
     Le caractère '/' permet de créer une OU sous une autre OU

  ** *ad_ou_classifier*
    
    _aucun_ : ne déplace aucun objet 
    _membreDe_ : ne déplace que les personnes appartenant au group
    _membreDeENT_ : ne déplace que les objets appartenant au group et les répartis par Niveau (divoc) et Classe (Melcf)
    _ordinateur_ : ne déplace que les ordinateurs 
    _ordinateur_par_classe_ : ne déplace que les ordinateurs et les répartissant dans des sous OU 
  
  ** *ad_ou_group*
    Suivant ad_ou_classifier, vous pouvez saisir le group auquel doit appartenir l'objet pour être selectionné

    Ex.
    Avec ad_ou_group="professeurs" : prof-1 sera sélectionné, eleve-1 non 
    Avec ad_ou_group="eleves"      : eleve-1 sera sélectionné, prof-1 non 
    Avec ad_ou_group=""            : pas de filtre ==> tous seront sélectionnés.

  ** *ad_ou_pattern*
    Dans cette zone, vous pouvez saisir une règle de filtrage sur le NOM de l'objet

    Ex.
    Avec ad_ou_pattern="PC"      : PC-123456 sera sélectionné, CDI-001 non, DESKTOP-ZPCLE non plus
    Avec ad_ou_pattern="CDI"     : CDI-001 sera sélectionné, PC-123456 non, DESKTOP-ZPCLE non plus
    Avec ad_ou_pattern="DESKTOP" : DESKTOP-ZPCLE sera sélectionné, CDI-001 non, PC-123456 non plus
    Avec ad_ou_pattern=""        : pas de filtre ==> tous seront sélectionnés.

h3. Exemples :

|no|ad_ou_names|ad_ou_classifier|ad_ou_group|ad_ou_pattern| Comportement attendu |
|1|Utilisateurs du Domaine|aucun|||Création OU sans classification|
|2|Professeurs/Utilisateurs du Domaine|membreDe|professeurs||Tous les professeurs vont dans l'OU OU=Professeurs,OU=Utilisateurs du Domaine,<realm>|
|3|Administratifs/Utilisateurs du Domaine|membreDe|administratifs||Tous les administratifs vont dans l'OU OU=Administratifs,OU=Utilisateurs du Domaine,<realm>|
|4|Eleves/Utilisateurs du Domaine|membreDe|eleves||Tous les éleves vont dans l'OU OU=Eleves,OU=Utilisateurs du Domaine,<realm>|
|5|Ordinateurs du Domaine|aucun|||Création OU sans classification|
|6|Equipements fixes/Ordinateurs du Domaine|ordinateur||DESKTOP-|Tous les ordinateurs dont le nom commence par 'DESKTOP-' vont dans l'OU OU=Equipements fixes,OU=Ordinateurs du Domaine,<realm>|
|7|Equipements mobiles/Ordinateurs du Domaine|ordinateur||LAPTOP-|Tous les ordinateurs dont le nom commence par 'LAPTOP-' vont dans l'OU OU=Equipements fixes,OU=Ordinateurs du Domaine,<realm>|
|8|CLASSE MOBILE 1/Equipements mobiles/Ordinateurs du Domaine|aucun|||Création OU sans classification|
|9|CLASSE MOBILE 2/Equipements mobiles/Ordinateurs du Domaine|aucun|||Création OU sans classification|
|10|SALLE DE COURS/Equipements fixes/Ordinateurs du Domaine|ordinateur_par_classe||<pre>(SVT|HIS|TEST)</pre>|
Sous l'OU OU=SALLE DE COURS,OU=Equipements fixes,OU=Ordinateurs du Domaine,<realm>, une arborescence est crée automatiquement avec la capture no1 de la regex https://fr.wikipedia.org/wiki/Expression_r%C3%A9guli%C3%A8re.
Dans cet exemple, la regex permet de filtrer 3 début de nom SVT ou HIS ou TEST.
Tous les ordinateurs sont déplacé dans leurs OU respectivent : 
OU=SVT,OU=SALLE DE COURS,OU=Equipements fixes,OU=Ordinateurs du Domaine,<realm> 
OU=HIS,OU=SALLE DE COURS,OU=Equipements fixes,OU=Ordinateurs du Domaine,<realm> 
OU=TEST,OU=SALLE DE COURS,OU=Equipements fixes,OU=Ordinateurs du Domaine,<realm>
|
|11|SALLE DES PROFESSEURS/Equipements fixes/Ordinateurs du Domaine|aucun|||Création OU sans classification|
|12|MULTIMEDIA/Equipements fixes/Ordinateurs du Domaine|aucun|||Création OU sans classification|
|13|TECHNOLOGIE/Equipements fixes/Ordinateurs du Domaine|ordinateur||TEC|Tous les ordinateurs dont le nom commence par 'TEC' vont dans l'OU OU=TECHNOLOGIE,OU=Equipements fixes,OU=Ordinateurs du Domaine,<realm>|
|14|CDI/Equipements fixes/Ordinateurs du Domaine|ordinateur||CDI|Tous les ordinateurs dont le nom commence par 'CDI' vont dans l'OU OU=CDI,OU=Equipements fixes,OU=Ordinateurs du Domaine,<realm>|
|15|ULIS/Equipements fixes/Ordinateurs du Domaine|ordinateur||ULIS|Tous les ordinateurs dont le nom commence par 'ULIS' vont dans l'OU OU=ULIS,OU=Equipements fixes,OU=Ordinateurs du Domaine,<realm>|
|16|SEGPA/Equipements fixes/Ordinateurs du Domaine|ordinateur||SEGPA|Tous les ordinateurs dont le nom commence par 'SEGPA' vont dans l'OU OU=SEGPA,OU=Equipements fixes,OU=Ordinateurs du Domaine,<realm>|
|17|UPI/Equipements fixes/Ordinateurs du Domaine|ordinateur||UPI|Tous les ordinateurs dont le nom commence par 'UPI' vont dans l'OU OU=UPI,OU=Equipements fixes,OU=Ordinateurs du Domaine,<realm>|
|18|Power Users/Utilisateurs du Domaine|membreDe|Domain Users|Test ||
|19|Eleves/Utilisateurs du Domaine|membreDeENT|eleves|| Uniquement sur Scribe 
Sous l'OU OU=Eleves,OU=Utilisateurs du Domaine,<realm>, une arborescence est crée avec les Niveau et Classe venant de l'ENT.
Tous les éleves sont déplacer dans leur OU respectivent : OU=<Classe>,OU=<Niveau>,OU=Eleves,OU=Utilisateurs du Domaine,<realm>
|

Exemple de mouvement sur un Scribe
|Origine|Destination||
|Administrator|CN=Administrator,CN=Users,<realm>|compte protégé, mas de mouvement|
|prof1|CN=prof1,OU=Professeurs,OU=Utilisateurs du Domaine,<realm>|prof1 est dans le groupe 'professeurs', donc règle no 2|
|c31e1|CN=c31e1,OU=c31,OU=3eme,OU=Eleves,OU=Utilisateurs du Domaine,<realm>|c31e1 est dans le groupe 'eleves', donc règle no 19|
|prenom.eleve112|CN=prenom.eleve112,OU=c31,OU=3eme,OU=Eleves,OU=Utilisateurs du Domaine,<realm>|c31e1 est dans le groupe 'eleves', donc règle no 19|
|CDI01|CN=CDI01,OU=CDI,OU=Equipements fixes,OU=Ordinateurs du Domaine,<realm>|CDI01 est un ordinateur dont le nom commence par CDI, donc règle no 14|
|DESKTOP-01|CN=DESKTOP-01,OU=Equipements fixes,OU=Ordinateurs du Domaine,<realm>|DESKTOP-01 est un ordinateur dont le nom commence par DESKTOP-, donc règle no 6|
|LAPTOP-01|CN=LAPTOP-01,OU=Equipements mobiles,OU=Ordinateurs du Domaine,<realm>|LAPTOP-01 est un ordinateur dont le nom commence par LAPTOP-, donc règle no 7|
|SRV02|CN=SRV02,CN=Computers,<realm>|SRV02 est un ordinateur, mais il ne s'agit pas d'une Station windows, donc pas de mouvement|
|SVT02|CN=SVT02,OU=SVT,OU=SALLE DE COURS,OU=Equipements fixes,OU=Ordinateurs du Domaine,<realm>|SVT02 est une station windows, dont le nom commence par SVT, donc règle no 10|

h3. Tests

Dans Jenkins : 

Version 2.7.2, module Seth : https://dev-eole.ac-dijon.fr/jenkins/job/2.7.2/job/test-seth-ou-seth-2.7.2-amd64/
Version 2.7.2, module ScribeAD :  https://dev-eole.ac-dijon.fr/jenkins/job/2.7.2/job/test-seth-ou-seth-2.7.2-amd64/

Version 2.8.0, module Seth : https://dev-eole.ac-dijon.fr/jenkins/job/2.8.0/job/test-seth-ou-seth-2.8.0-amd64/
Version 2.8.0, module ScribeAD :  https://dev-eole.ac-dijon.fr/jenkins/job/2.8.0/job/test-seth-ou-seth-2.8.0-amd64/

