# coding: utf-8
from json import dumps
import traceback
from pyeole.lock import is_locked
import subprocess

from .action import describe as _describe, submit as _submit

CMD_PROCESSFILE = "/usr/share/eole/postservice/24-ad-ou"


def _send_error_message(msg):
    return _send_message(u"Erreur {}".format(msg), 'error')


def _send_message(msg, level='info'):
    return dumps({'message': {'type': level, 'text': msg}})


def launch(**kwargs):
    messages = {0: {'msg': 'Exécution terminé', 'level': 'info'},
                1: {'msg': 'Erreur indéfinie : {}', 'level': 'error'},
                2: {'msg': 'Impossible d’executer le script: {}', 'level': 'error'},
                3: {'msg': 'Erreur à l’exécution du script : {}', 'level': 'error'}
                }
    try:
        ret = subprocess.run([CMD_PROCESSFILE], check=True)
        returncode = ret.returncode
        message = 'Exécution effectuée'
        level = 'info'
    except subprocess.CalledProcessError as err:
        returncode = err.returncode
        message = messages[returncode]['msg'].format(err)
        level = messages[returncode]['level']
    return _send_message(message, level=level)


def describe(*args, **kwargs):
    if is_locked(name='sortclient', level='system'):
        return _send_error_message("une exécution est en cours")
    return _describe(*args, **kwargs)


def submit(*args, **kwargs):
    if is_locked(name='sortclient', level='system'):
        return _send_error_message("une exécution est en cours")
    return launch()
__CUSTOM_MODULES__ = ('launch',)
