/* tools.entity 
 * Gestion de l'affichage des informations dans le contexte d'une 'entité' (ie : un établissement)
 * 
 * Affichage des
 *   - onglets
 *   - Composantes
 *   - Journal
 *   - Historiques
 */

var currentAction=""

// Désactivation de tous les onglets
function unActiveLi()
{
	$("li.onglet.active").removeClass("active");
	
	$("ul.navigation li.active").removeClass("active");
	$("#siderubriques").empty();
	$("#sidecontent").empty();
	$("tr.jqgrow").removeClass("ui-state-highlight");
}

// Désactivation d'un onglet "entité" li.etabs
function unActiveLiEntity()
{
	$("li.etabs").removeClass("active");
	$("li.onglet").removeClass("active");
	$("li.etabs").addClass("inactive");
	
}

// Activation d'un onglet et mémorisation de l'entité courrante
function activeLi(id)
{
	unActiveLi();
	$("#li"+id).addClass("active");

	currentAction=id;
}

function isActiveLi(id)
{
   return  $("#li"+id).hasClass("active");
}

// Suppression d'un onglet 
// Appel remove_entity pour mettre à jour le profil
// et cache l'onglet sur retour de l'appel
function removeEntity(entity,li)
{
	
	$("#onglet_"+entity).hide();
	if ($("#onglet_"+entity).hasClass("active"))
	{
		Accueil();
	}
 	$.ajax({
 			 url: '/session/remove_entity',
              data: {entity:entity},
              type: 'GET',success: function( response ){
              	
              	
              }
    })
}

//  
function EnableEntityMarker(uid,bEnabled)
{
	$("#onglet_"+uid).css({ opacity: bEnabled?1:0.3 });
}
 
// Change l'icone d'un onglet
function SetEntityMarker(uid,icon)
{
	$("#marker_"+uid).css("background-image","url("+icon+")");	
}

function ShowEntityFast(entity)
{
    if (isMapVisible() || isKiwiVisible())
        displayContextuelle(entity,currentPerspectiveContextuelId);
    else
        ShowEntity(entity)
}

// Affichage d'une entité
//   
function ShowEntity(entity)
{
    // Em mode invité pas de ShowENtity possible
	if (appConfig.get("guest")) 
	{
		displayContextuelle(entity,currentPerspectiveContextuelId);	 
		return;
	}
	
	unActiveLiEntity();
	
	// onglet existant ?
	if ($("#onglet_"+entity).length != 0 )
	{
		w=$(window).width()	
		onglet=$("#onglet_"+entity);
		// Est-ce qu'il est visible ? (ie: ne dépasse pas de l'écran)
		if (onglet.offset().left+onglet.width()>w)
		{
			onglet.remove(); // Il dépasse de l'écran on le supprime, il sera recréé en première position
		}
	}

    $("#side_gestion").hide();
	
	// Pas d'onglet
	if ($("#onglet_"+entity).length == 0 )
	{
		// Création de l'onglet
		onglet='<li class="etabs active" id="onglet_'+entity+'">'+
        '<div class="entity" entity='+entity+'>'+
          '<table><tr>'+
          '<td class="marker" onclick="javascript:ShowEntityFast(\''+entity+'\')" id="marker_'+ entity  +'"  >&nbsp;</td>'+
    	  '<td class="link"><a class="link"  id="amarker_'+ entity  +'" href="#" style="display:inline-block;" onclick="javascript:ShowEntity(\''+entity+'\')">'+entity+'</a></td>'+
    	  '<td class="close"><a href="javascript:removeEntity(\''+entity  +'\')" title="Enlever cet onglet" class="close">&nbsp;</a></td>'+
          '</tr></table>'+
    	'</div>'+
    	'</li>'
    	
    	// NOTE: liseparator permet de séparer les onglets fixes (Accueil, Raports, Gérer) des onglets amovibles (Entités,..)
    	$(onglet).insertAfter("#liseparator")
    	removeLastOnglets();
        RefreshOngletEtab();


    	// Mise a jour de l'icone
    	for (var i = 0; i < features.length; i++) 
    	{
            item = features[i];
            if (item.title==entity)
            {
            	SetEntityMarker(entity,item.icon);
            	break;	
            }
        }
    	
	}
	
	w=$("#main-navigation").width()
	
	// Activation de l'onglet
	$("#onglet_"+entity).addClass("active");
	$("#onglet_"+entity).removeClass("inactive");
	$("#onglet_"+entity).show();
	
	// Sauvegarde dans la conf de l'entité courrante
	appConfig.put("entity",entity)	;
	
	$("#side_entity_composantes").hide();
	
	// Si la sidebar ne contient pas licomposantes (cad pas de sidebar 'entité')
	// on charge la sidebar pour pouvoir naviguer dans l'entité : Composantes, Journal, Historiques,...
	if ($('#licomposantes').length == 0 )
	{
		$.ajax({
              url: '/entity/sideheader'  ,
              data: {id:appConfig.get("entity")},
              type: 'GET',success: function( response )
              {
              	$("#side_entity").html(response)
                ShowSidebar("entity");
              	initButton();
              	activeLi(currentAction);
              }
    	})
	} else {
        $("#side_entity_composantes .content").empty()
        ShowSidebar("entity");
        // Modification des bouton 'edit'
        /*$(".btn-filter-edit").button({ "text": false,  "icons": {primary:'ui-icon-check'} } );
        $(".btn-filter-edit").find(".ui-button-text").each(function(i,v)
        {
            $(v).html("Par défaut")  ;
        });
        $(".btn-filter-edit").attr("title","Mettre par défaut")  ;*/
    }
    $("#main").html("");
	$("#entityname").html(entity);

	// Si currentPerspective!=null on l'affiche
	if (currentPerspective!=null && currentPerspective!="")
	{
		unActiveLi();
		currentAction="";
		showPersective(currentPerspective,null);
		$("#mesperspectives").show();
        $("#side_entity_composantes").hide();
		return;
	}
	// Sinon on utilise la currentAction
	if (currentAction=="composantes") ShowComposantes();
	else if (currentAction=="journal") ShowJournal();
	else if (currentAction=="historiques") ShowHistoriques();
	else ShowComposantes();

	
}

// Affichage des composantes
function ShowComposantes()
{
		activeLi("composantes")
		currentPerspective=null;
    	$.ajax({
              url: '/entity/composantes'  ,
              data: {id:appConfig.get("entity")},
              type: 'GET',success: function( response )
              {
              	$("#main").empty()
              	$("#main").html(response)
              	$("#mesperspectives").show();
              	$("#side_entity_composantes").hide();
              	initButton();
              }
          }) 	
}

// Affichage du journal
function ShowJournal()
{
		activeLi("journal");
		currentPerspective=null;

    	$.ajax({
              url: '/entity/journal'  , data: {id:appConfig.get("entity")},
              type: 'GET',success: function( response ){
              	$("#main").empty()
              	$("#main").html(response);
              	initButton();
              	}
        })
        
       ShowComposantesSide(); 
          	
}


function ShowComposantesSide()
{
    console.log("ShowComposantesSide")
     if ($("#side_entity_composantes .content").text().trim()!="")
     {
         console.log("ShowComposantesSide:exists")
         $("#mesperspectives").hide();
         $("#side_entity_composantes").show();
         adjustHeight("#side_entity_composantes .content .composantes-tree")
         return;
     }
    console.log("ShowComposantesSide;get")

    setTimeout(function() {
         $.ajax({
                          url: '/entity/composantes_side'  , data: {id:appConfig.get("entity")},
                          type: 'GET',success: function( response )
                          {
                           console.log("ShowComposantesSide;recieve")
                           $("#side_entity_composantes .content").empty()
                           $("#side_entity_composantes .content").html(response);
                           $("#mesperspectives").hide();
                           $("#side_entity_composantes").show();
                              setTimeout(function() {adjustHeight("#side_entity_composantes .content .composantes-tree")},1000)
                          }
             })
    },500)
}

// Affichage de l'historique
function ShowHistoriques()
{
		activeLi("historiques");
		currentPerspective=null;
		ShowComposantesSide(); 
    	$.ajax({
              url: '/entity/historiques'  ,
              data: {id:appConfig.get("entity")},
              type: 'GET',success: function( response )
              {
              	$("#main").empty()
              	$("#main").html(response)
              	initButton();
              }
          })  
        	
}

// Affichage de la perspectiv epar défaut
function ShowPerspective()
{
		unActiveLi();
    	$.ajax({
              url: '/entity/perspective'  ,
              data: {id:appConfig.get("entity")},
              type: 'GET',success: function( response )
              {
              	$("#main").empty()
              	$("#main").html(response)
              	
              }
          })
    	
}