    function createDroppableElements() {
	    $("#composantes_list").droppable({
	        tolerance:  'pointer',
	        hoverClass: 'dragOver',
	        activate:   function(event, ui) {
	                        $(this).addClass("dragOver");
	                    },
	        deactivate: function(event, ui) {
	                        $(this).removeClass("dragOver");
	                    },
	
	        drop:       function(event, ui) {
	                        var theValue = ui.draggable.data('colValue');
	                        theValue = theValue .replace(/<br>/gi,'; ');
	                        AddComposanteToFilterList(theValue);
	                    }
	    });
	}
    
    function makeGridRowsDraggable() {

        var $searchResultsGrid  =   $("#journal_messages"),
            $searchResultsRows =    $("#journal_messages .ui-row-ltr");

        try {
            $searchResultsRows.css("cursor","move").draggable("destroy")
        } catch (exception)
        {

        }

          $searchResultsRows.draggable({
            revert:     "false",
            appendTo:   'body',
            cursor:     "move",
            cursorAt:   {
                            top: 10,
                            left: -5
                        },
            helper:     function(event) {

                            //get a hold of the row id
                            var rowId = $(this).attr('id');

                            var theValue = $searchResultsGrid.jqGrid('getCell', rowId, 'composante');

                            //set the data on this to the value to grab when you drop into input box
                            $(this).data('colValue', theValue);

                            return $("<div class='draggedValue ui-corner-all'>" + theValue+ "</div>");
                        },
            start:      function(event, ui) {
                            //fade the grid
                            $(this).parent().fadeTo('fast', 0.5);
                        },
            stop:       function(event, ui) {
                            $(this).parent().fadeTo(0, 1);
                        }
        });

    }