

(function( $ ) {

    var proto = $.ui.autocomplete.prototype,
        initSource = proto._initSource;

    function filter( array, term ) {
        var matcher = new RegExp( $.ui.autocomplete.escapeRegex(term), "i" );
        return $.grep( array, function(value) {
            return matcher.test( $( "<div>" ).html( value.label || value.value || value ).text() );
        });
    }

    $.extend( proto, {
        _initSource: function() {
            if ( this.options.html && $.isArray(this.options.source) ) {
                this.source = function( request, response ) {
                    response( filter( this.options.source, request.term ) );
                };
            } else {
                initSource.call( this );
            }
        },

        _renderItem: function( ul, item) {
            return $( "<li></li>" )
                .data( "item.autocomplete", item )
                .append( $( "<a></a>" )[ this.options.html ? "html" : "text" ]( item.label ) )
                .appendTo( ul );
        }
    });

})( jQuery );

var APP_TOOLS_VERSION="d"

jQuery.fn.center = function () {
    this.css("position","absolute");
    this.css("top", /*Math.max(0, (($(window).height() - this.outerHeight()) / 2) + 
                                                $(window).scrollTop())*/ 0+ "px");
    this.css("left", Math.max(0, (($(window).width() - this.outerWidth()) / 2) + 
                                                $(window).scrollLeft()) + "px");
    return this;
}

jQuery.fn.setContent = function (content) {
	this.empty()
	this.html(content)
	if (this.id == "main")
	{
		$("body").scrollTop('0px');
	}
	
}


$.fn.extend({
    insertAtCaret: function(myValue){
        var obj;
        if( typeof this[0].name !='undefined' ) obj = this[0];
        else obj = this;

        if ($.browser.msie) {
            obj.focus();
            sel = document.selection.createRange();
            sel.text = myValue;
            obj.focus();
        }
        else if ($.browser.mozilla || $.browser.webkit) {
            var startPos = obj.selectionStart;
            var endPos = obj.selectionEnd;
            var scrollTop = obj.scrollTop;
            obj.value = obj.value.substring(0, startPos)+myValue+obj.value.substring(endPos,obj.value.length);
            obj.focus();
            obj.selectionStart = startPos + myValue.length;
            obj.selectionEnd = startPos + myValue.length;
            obj.scrollTop = scrollTop;
        } else {
            obj.value += myValue;
            obj.focus();
        }
    }
})

$.datepicker.regional['fr'] = {clearText: 'Effacer', clearStatus: '',
		closeText: 'Fermer', closeStatus: 'Fermer sans modifier',
		prevText: '<Préc', prevStatus: 'Voir le mois précédent',
		nextText: 'Suiv>', nextStatus: 'Voir le mois suivant',
		currentText: 'Courant', currentStatus: 'Voir le mois courant',
		monthNames: ['Janvier','Février','Mars','Avril','Mai','Juin',
		'Juillet','Août','Septembre','Octobre','Novembre','Décembre'],
		monthNamesShort: ['Jan','Fév','Mar','Avr','Mai','Jun',
		'Jul','Aoû','Sep','Oct','Nov','Déc'],
		monthStatus: 'Voir un autre mois', yearStatus: 'Voir un autre année',
		weekHeader: 'Sm', weekStatus: '',
		dayNames: ['Dimanche','Lundi','Mardi','Mercredi','Jeudi','Vendredi','Samedi'],
		dayNamesShort: ['Dim','Lun','Mar','Mer','Jeu','Ven','Sam'],
		dayNamesMin: ['Di','Lu','Ma','Me','Je','Ve','Sa'],
		dayStatus: 'Utiliser DD comme premier jour de la semaine', dateStatus: 'Choisir le DD, MM d',
		dateFormat: 'dd/mm/yy', firstDay: 0, 
		initStatus: 'Choisir la date', isRTL: false};
	$.datepicker.setDefaults($.datepicker.regional['fr']);

	function initialiserLesDates(callBack)
	{
        current_data=null;

		d=(new Date().getTime())-3600*24*1000;
		start=new Date(d).format("dd/mm/yyyy")
		$( "#datestart").val(start);
		
		d=(new Date().getTime())+3600*24*1000;
		end=new Date(d).format("dd/mm/yyyy")
		$( "#dateend").val(end);
		
	
	    $( "#datestart").datepicker({ maxDate: "+1D",
	    						onSelect: function( selectedDate ) {
									$( "#dateend" ).datepicker( "option", "minDate", selectedDate );
								} });
	    $( "#dateend"  ).datepicker({ maxDate: "+1D" });
	
		$("#checkLatest").iButton({labelOn: 'Oui', labelOff: 'Non',  duration: 500, 
									width:100,resizeContainer:false,resizeHandle:false
									, change: function ($input){
	       								 changePeriode($input.is(":checked"))
                                         if (callBack!=undefined )
                                         {
                                             callBack()
                                         }
	   							   }});
		$("#btnActualiser").button().click(function()
		{
            if (callBack!=undefined)  { callBack() ; return }
			if (current_data != undefined && current_data!=null) OnSelectNode(current_data) ;

		});
	}

    function changePeriode()
    {
    	if ($("#checkLatest").is(":checked"))
    	{
    		$("#periode").hide();	
    	}	else
    	{
    		$("#periode").show();
    	}
    	RefreshPeriode();
    }	
    
    function getStart()
    {
    	if ($("#checkLatest").is(":checked")) return -1;
    	return $.datepicker.parseDate("dd/mm/yy", $( "#datestart").val()).getTime() /1000;
    }
    
    function getEnd()
    {
    	if ($("#checkLatest").is(":checked")) return -1;
    	return $.datepicker.parseDate("dd/mm/yy", $( "#dateend").val()).getTime() /1000;
    }

function randomString(length) {
    var chars = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXTZabcdefghiklmnopqrstuvwxyz'.split('');

    if (! length) {
        length = Math.floor(Math.random() * chars.length);
    }

    var str = '';
    for (var i = 0; i < length; i++) {
        str += chars[Math.floor(Math.random() * chars.length)];
    }
    return str;
}

/*
 * Date Format 1.2.3
 * (c) 2007-2009 Steven Levithan <stevenlevithan.com>
 * MIT license
 *
 * Includes enhancements by Scott Trenda <scott.trenda.net>
 * and Kris Kowal <cixar.com/~kris.kowal/>
 *
 * Accepts a date, a mask, or a date and a mask.
 * Returns a formatted version of the given date.
 * The date defaults to the current date/time.
 * The mask defaults to dateFormat.masks.default.
 */

var dateFormat = function () {
	var	token = /d{1,4}|m{1,4}|yy(?:yy)?|([HhMsTt])\1?|[LloSZ]|"[^"]*"|'[^']*'/g,
		timezone = /\b(?:[PMCEA][SDP]T|(?:Pacific|Mountain|Central|Eastern|Atlantic) (?:Standard|Daylight|Prevailing) Time|(?:GMT|UTC)(?:[-+]\d{4})?)\b/g,
		timezoneClip = /[^-+\dA-Z]/g,
		pad = function (val, len) {
			val = String(val);
			len = len || 2;
			while (val.length < len) val = "0" + val;
			return val;
		};

	// Regexes and supporting functions are cached through closure
	return function (date, mask, utc) {
		var dF = dateFormat;

		// You can't provide utc if you skip other args (use the "UTC:" mask prefix)
		if (arguments.length == 1 && Object.prototype.toString.call(date) == "[object String]" && !/\d/.test(date)) {
			mask = date;
			date = undefined;
		}

		// Passing date through Date applies Date.parse, if necessary
		date = date ? new Date(date) : new Date;
		if (isNaN(date)) throw SyntaxError("invalid date");

		mask = String(dF.masks[mask] || mask || dF.masks["default"]);

		// Allow setting the utc argument via the mask
		if (mask.slice(0, 4) == "UTC:") {
			mask = mask.slice(4);
			utc = true;
		}

		var	_ = utc ? "getUTC" : "get",
			d = date[_ + "Date"](),
			D = date[_ + "Day"](),
			m = date[_ + "Month"](),
			y = date[_ + "FullYear"](),
			H = date[_ + "Hours"](),
			M = date[_ + "Minutes"](),
			s = date[_ + "Seconds"](),
			L = date[_ + "Milliseconds"](),
			o = utc ? 0 : date.getTimezoneOffset(),
			flags = {
				d:    d,
				dd:   pad(d),
				ddd:  dF.i18n.dayNames[D],
				dddd: dF.i18n.dayNames[D + 7],
				m:    m + 1,
				mm:   pad(m + 1),
				mmm:  dF.i18n.monthNames[m],
				mmmm: dF.i18n.monthNames[m + 12],
				yy:   String(y).slice(2),
				yyyy: y,
				h:    H % 12 || 12,
				hh:   pad(H % 12 || 12),
				H:    H,
				HH:   pad(H),
				M:    M,
				MM:   pad(M),
				s:    s,
				ss:   pad(s),
				l:    pad(L, 3),
				L:    pad(L > 99 ? Math.round(L / 10) : L),
				t:    H < 12 ? "a"  : "p",
				tt:   H < 12 ? "am" : "pm",
				T:    H < 12 ? "A"  : "P",
				TT:   H < 12 ? "AM" : "PM",
				Z:    utc ? "UTC" : (String(date).match(timezone) || [""]).pop().replace(timezoneClip, ""),
				o:    (o > 0 ? "-" : "+") + pad(Math.floor(Math.abs(o) / 60) * 100 + Math.abs(o) % 60, 4),
				S:    ["th", "st", "nd", "rd"][d % 10 > 3 ? 0 : (d % 100 - d % 10 != 10) * d % 10]
			};

		return mask.replace(token, function ($0) {
			return $0 in flags ? flags[$0] : $0.slice(1, $0.length - 1);
		});
	};
}();

// Some common format strings
dateFormat.masks = {
	"default":      "ddd mmm dd yyyy HH:MM:ss",
	shortDate:      "m/d/yy",
	mediumDate:     "mmm d, yyyy",
	longDate:       "mmmm d, yyyy",
	fullDate:       "dddd, mmmm d, yyyy",
	shortTime:      "h:MM TT",
	mediumTime:     "h:MM:ss TT",
	longTime:       "h:MM:ss TT Z",
	isoDate:        "yyyy-mm-dd",
	isoTime:        "HH:MM:ss",
	isoDateTime:    "yyyy-mm-dd'T'HH:MM:ss",
	isoUtcDateTime: "UTC:yyyy-mm-dd'T'HH:MM:ss'Z'"
};

// Internationalization strings
dateFormat.i18n = {
	dayNames: [
		"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat",
		"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"
	],
	monthNames: [
		"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec",
		"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"
	]
};

// For convenience...
Date.prototype.format = function (mask, utc) {
	return dateFormat(this, mask, utc);
};

String.prototype.replaceAll = function(token, newToken, ignoreCase) {
    var str, i = -1, _token;
    if((str = this.toString()) && typeof token === "string") {
        _token = ignoreCase === true? token.toLowerCase() : undefined;
        while((i = (
            _token !== undefined? 
                str.toLowerCase().indexOf(
                            _token, 
                            i >= 0? i + newToken.length : 0
                ) : str.indexOf(
                            token,
                            i >= 0? i + newToken.length : 0
                )
        )) !== -1 ) {
            str = str.substring(0, i)
                    .concat(newToken)
                    .concat(str.substring(i + token.length));
        }
    }
return str;
};

if (typeof String.prototype.startsWith != 'function') {
  // see below for better implementation!
  String.prototype.startsWith = function (str){
    return this.indexOf(str) == 0;
  };
}

function clipboard_set(acopier)
{
	$("#copypath").val(acopier)
	
}

function clipboard_get()
{
	return $("#copypath").val()
}

function adjustHeight(id,offset)
{
    var p=$(id).position();
    if (p==null) return;
	var h=$(window).height()-$(id).position().top;
	if (offset != undefined )
	{
		h=h+offset;
	}
	$(id).css("height",h);
}

function reduce(id)
{
    $(id).css("height",15);
    $(id).addClass("reduced");
    $(id).removeClass("extended");
    $(id+" .content").css("display","none");
}

function restore(id)
{
    $(id).css("height",280);
    $(id+" .content").css("display","block");
    $(id+" .content").css("height",$(id).height()-40);
    $(id).removeClass("extended")
    $(id).removeClass("reduced")
}

function extend(id)
{
    var h=$(id).height()
    if ($(id).hasClass("extended"))
    {
        restore(id)
        restore(".reduced")
        return;

    } else
    {
        adjustHeight(id)
        $(id).addClass("extended")
    }

    $(id+" .content").css("display","block");
    $(id+" .content").css("height",$(id).height()-50);
}




function is_array(input){
    return typeof(input)=='object'&&(input instanceof Array);
}

function toCss(str)
{
    str= str.replace(/:/g,"\":\"").replace(/;/g,"\",\"");
    return $.parseJSON("{\""+str+"\"}") ;
}

function checkLength( o, n, min, max ) {
    if ( o.val().length > max || o.val().length < min ) {
        o.addClass( "ui-state-error" );
        updateTips( "La longueur de  " + n + " doit être entre " +
            min + " et " + max + "." );
        return false;
    } else {
        return true;
    }
}

function checkRegexp( o, regexp, n ) {
    if ( !( regexp.test( o.val() ) ) ) {
        o.addClass( "ui-state-error" );
        updateTips( n );
        return false;
    } else {
        return true;
    }
}

function updateTips( t )
{
    alert(t)
   /* tips
        .text( t )
        .addClass( "ui-state-highlight" );
    setTimeout(function() {
        tips.removeClass( "ui-state-highlight", 1500 );
    }, 500 );*/
}


function UIBlock(ui,message)
{
	/*$(ui).block({ message: "<div class='loadingblock'></div>"+message,
				  css: { 
		            border: 'none', 
		            padding: '15px', 
		            backgroundColor: '#FFF', 
		            '-webkit-border-radius': '10px', 
		            '-moz-border-radius': '10px', 
		            opacity: .9, 
		            'font-size': '14px',
		            color: '#000' 
		        }
				
				}); 
				
	$(".blockUI.blockMsg.blockElement").css("top","50px");    */
}

function UIMask(ui)
{
    $(ui).block({ message: "",
        css: {
            border: 'none',
            padding: '15px',
            backgroundColor: '#FFF',
            '-webkit-border-radius': '10px',
            '-moz-border-radius': '10px',
            opacity: .9,
            'font-size': '14px',
            color: '#000'
        }

    });

    $(".blockUI.blockMsg.blockElement").css("top","50px");
}

function showAjaxBeforeRequest(url)
{
    //$('.flash').html("");
    //$('.flash').prepend("<div class='message loading'>...</div>");
    //$('#lilogout').hide();
    //$('#liajaxloading').show();
    $("#avatar").addClass("animate")
    $("#avatar").attr("title","Loading: "+url)
}

function hideAjaxBeforeRequest()
{
    //$('.flash').html("");
    //$('.flash').prepend("<div class='message loading'>...</div>");
    //$('#liajaxloading').hide();
    //$('#lilogout').show();
    $("#avatar").removeClass("animate")
    $("#avatar").attr("title","");
}

function UIBlock2(ui,message)
{

    $(ui).block({ message: "<div class='loadingblock'></div>"+message,
        css: {
            border: 'none',
            padding: '15px',
            backgroundColor: '#FFF',
            '-webkit-border-radius': '10px',
            '-moz-border-radius': '10px',
            opacity: .9,
            'font-size': '14px',
            color: '#000'
        }

    });

    $(".blockUI.blockMsg.blockElement").css("top","50px");
}

function UIBlockAlert(ui,message)
{

    $(ui).block({ message: "<div class='alertblock'>"+message+"</div>",
        css: {
            border: 'none',
            padding: '15px',
            backgroundColor: '#FEE',
            '-webkit-border-radius': '10px',
            '-moz-border-radius': '10px',
            opacity: .9,
            'font-size': '14px',
            color: '#000'
        }

    });

    $(".blockUI.blockMsg.blockElement").css("top","50px");
}

function UIUnBlock(ui)
{
	$(ui).unblock();
}

function isMapVisible()
{
    return $('#map_canvas').is(':visible');
}

function adjustMain(w)
{
    id="#main";
    if ( isMapVisible() )  id="#map_canvas";

    // Si la sidebar est visible, on remets le scroll sur le body
    if ($('#sidebar').is(':visible'))
        $("body").css("overflow-y","auto")


    $(id).css("width",w);

    if (id=="#map_canvas") {
        offset=$("#map_canvas").offset()
        $("#map_tool").offset({ top: offset.top+5, left: (w-$("#map_tool").width())/2})
    }

}

function ajusterLaLongueurDeMain()
{
	b=  $('#sidebar').is(':visible')
    w=$(window).width()-(b?($("#sidebar").width()+20):10);
    adjustMain(w);
}

function ajusterLaLongueurDeLaCarte(bDefault)
{
	 b=bDefault;
     $("#objets").children().each(function (i) {if (this.localName=="div" && this.style.display != "none" ) {b=true;}});
	 if (!b) $("#sidebar").hide();	else $("#sidebar").show();
	      
	 w=$(window).width()-(b?($("#sidebar").width()+20):10);

    adjustMain(w);
}

function hidePwd()
{
    $(this).addClass("hidden");
}

function showPwd()
{
    $(this).removeClass("hidden");
}

function registerPassword(id)
{

    var config = {
        over: showPwd, // function = onMouseOver callback (REQUIRED)
        timeout: 3000, // number = milliseconds delay before onMouseOut
        out: hidePwd // function = onMouseOut callback (REQUIRED)
    };

    $(id).hoverIntent( config )

}

function randomString(length) {
    var chars = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXTZabcdefghiklmnopqrstuvwxyz'.split('');

    if (! length) {
        length = Math.floor(Math.random() * chars.length);
    }

    var str = '';
    for (var i = 0; i < length; i++) {
        str += chars[Math.floor(Math.random() * chars.length)];
    }
    return str;
}

(function($){$.fn.hoverIntent=function(f,g){var cfg={sensitivity:7,interval:100,timeout:0};cfg=$.extend(cfg,g?{over:f,out:g}:f);var cX,cY,pX,pY;var track=function(ev){cX=ev.pageX;cY=ev.pageY};var compare=function(ev,ob){ob.hoverIntent_t=clearTimeout(ob.hoverIntent_t);if((Math.abs(pX-cX)+Math.abs(pY-cY))<cfg.sensitivity){$(ob).unbind("mousemove",track);ob.hoverIntent_s=1;return cfg.over.apply(ob,[ev])}else{pX=cX;pY=cY;ob.hoverIntent_t=setTimeout(function(){compare(ev,ob)},cfg.interval)}};var delay=function(ev,ob){ob.hoverIntent_t=clearTimeout(ob.hoverIntent_t);ob.hoverIntent_s=0;return cfg.out.apply(ob,[ev])};var handleHover=function(e){var ev=jQuery.extend({},e);var ob=this;if(ob.hoverIntent_t){ob.hoverIntent_t=clearTimeout(ob.hoverIntent_t)}if(e.type=="mouseenter"){pX=ev.pageX;pY=ev.pageY;$(ob).bind("mousemove",track);if(ob.hoverIntent_s!=1){ob.hoverIntent_t=setTimeout(function(){compare(ev,ob)},cfg.interval)}}else{$(ob).unbind("mousemove",track);if(ob.hoverIntent_s==1){ob.hoverIntent_t=setTimeout(function(){delay(ev,ob)},cfg.timeout)}}};return this.bind('mouseenter',handleHover).bind('mouseleave',handleHover)}})(jQuery);

function timeoutPassword(id)
{
	//$(id).html("^^^^^^^");
	$(id).addClass('hidden');
}

function dropFinish(data)
{
    data.e.preventDefault();
    $.ajax({
        url: '/composantes/' +data.o.attr("id")+'.json' ,
        data: {},
        type: 'GET',
        success: function (resp)
        {

            var o=$(data.r);
            while (o[0] != undefined && o[0].id!="main" && o[0].id!="dialog-filter")
            {
                if (o.hasClass("portlet"))
                {
                    $("#"+o[0].id).trigger("drop", [ resp,data.e]);

                    return;
                }
                o= o.parent();
                
            }


        	/*if ($("#"+data.r.context.id).hasClass("portlet"))
            {
                $("#"+data.r.context.id).trigger("drop", [ resp]);
            	//$("#"+data.r.context.id).portlet("drop",data)
            }
            else */
            {
                onDropFinish(resp,data.e);
            }


        }
    });
}