

function GetRootLocation()
{
    return location.protocol + '//' + location.host;
}

lastNotificationWindow=null;
function notify(parameters)
{
    ActionSentinelle("notify",parameters)
    if (window.webkitNotifications && (window.webkitNotifications.checkPermission() == 0))
    {
        if (parameters.message && parameters.objet)
        {
            if (lastNotificationWindow!=null)
                lastNotificationWindow.close();
            lastNotificationWindow=window.webkitNotifications.createNotification(
                parameters.icon, parameters.objet,
                parameters.message);
            lastNotificationWindow.show();
        }
    }


}

function handlerNotFound()
{

    $("#dialog-message .message").html("Vous avez tenté d'éxécuter une action depuis Sentinelle, " +
        "cependant il semble que cela n'a pu aboutir, car il manque sans doute une configuration sur votre poste.<br><br>" +
        "Pour plus d'informations, " +
        "<a href='/assets/guide/co/handler.html' target='_blank'>veuillez consulter la documentation en ligne</a>");

    $("#dialog-message" ).dialog({
        resizable: false,
        height:250,
        width:500,
        modal: true,
        buttons: {
            "Fermer": function() {
                $( this ).dialog( "close" );
            }
        }
    });
}


function saveCurrentRight(id)
{
    jQuery(id).jqGrid('saveRow',lastselright, {succesfunc: function( response ) {lastselright=-1;UIUnBlock("body");return true;}});
    lastselright=-1;
}

function adminMode()
{
    bAdminMode=$("#check-adminmode").prop('checked')
    if (bAdminMode)
    {
        $("#ligérer").show()
    }   else
    {
        if (currentAction=="gérer")
        {
            Accueil();
        }
        $("#ligérer").hide()
    }

    if (currentAction=="rapports")
    {
        UIBlock2("#main")
        Rapports();
    }
}

function reloadAllObjectsList()
{
    $( "#listvues" ).trigger("reloadGrid");
    $( "#listfiltres" ).trigger("reloadGrid");
    $( "#listperspectives" ).trigger("reloadGrid");
    $( "#listrapports" ).trigger("reloadGrid");
    $( "#listnotifications" ).trigger("reloadGrid");
    $( "#listscripts" ).trigger("reloadGrid");
}


function InitAccueil()
{
   $("#btnFilterNo").button({ "text": false,  "icons": {primary:'ui-icon-cancel'} }).click(function()
   {
       disableFilter();
   })  ;

   $("#btnExtandVue").click(function()
   {
       reduce("#filters");reduce("#rapportsblock");
       extend("#vuesblock") ;
   })  ;

   $("#btnExtandFiltres").click(function()
   {
       reduce("#vuesblock");reduce("#rapportsblock");
       extend("#filters") ;
   })  ;
   
   $("#cancelSearch").button({ "text": false,  "icons": {primary:'ui-icon ui-icon-circle-close'} } ).click(function()
	  {
		$("#searchEtab").val("");
		DrawMap();
        ShowSidebar("accueil");
		HideSearchCancel();
	});

}

function rechercherEtablissement()
{
	$.ajax({
		url:'/main/entities',format: "json",type: 'GET',
    	success: function (data)
    	{	
    		features=data.features;
    		searchEtab=$("#searchEtab").val();
			if (searchEtab!= undefined && searchEtab!="")  {
				re=new RegExp(".*"+searchEtab+".*", "i");
            }
			count=0;var entity="";
        	for (var i = 0; i < features.length; i++) 
        	{
	            item = features[i];
	            // Critere de recherche
	            if (re!=null)
	            {
	            	if ( !  re.test(item.title) && ! re.test(item.description) )
	            	{
	            		continue
	            	}
	            	entity=item.title	
	            }
	            count++;	
	        }
	        if (count==1)
        	{
                console.log("rechercherEtablissement: #1")
        		if (isKiwiVisible()) {
                    console.log("Fast")
                    ShowEntityFast(entity)
                } else
                    ShowEntity(entity);
        	}
        	if (count>1)
        	{
        		Accueil();
        	}
        	HideSearchLoading();
	        
			
    	}
   });
}


var skipNextEtabsStatusUpdate=false; // Evite le prochain rafraichissement automatique,
// si l'utilisateur a explicitement actualiser la carte (clique sur accueil, toogle vue/filtre)

function skipNextEtabsStatus()
{
    skipNextEtabsStatusUpdate=true;
}

function checkAlive()
{
    $.ajax({
        url:'/main/alive',hideLoadingMask:true,hideActivity:true,
        data:{guest:appConfig.get("guest")} ,
        success: function(data)
        {
            // Si user est connecté et le service retourne ! connected
            // (Session supprimé par le serveur, on retourne vers la racine)
            if (!appConfig.get("guest") && !data.connected )
            {
                window.location.href=location.protocol + '//' + location.host
            }

            if (data.handlerPending>2)
            {
                //handlerNotFound();
                console.log(data)
            }

            if (data.needchangepassword)
            {
                flasher("Veuillez changer votre mot de passe.","red");
                modifyProfil();
            }

        }})
}

function StartAppTimer()
{
    // Récupération de l'état des établissements (carte + onglet)
	setInterval("GetEtabsStatus()",60*1000*2);  // Toutes les 2 minutes

    // 30s plus tard on lance le timer des notifications
    setTimeout(function(){
        setInterval("GetNotifications()",60*1000)  // Verification des notifications toutes les minutes
    },30*1000)

    setInterval(checkAlive,60*1000); // Each minute check if server is alive
}

var lastMapZoom=null;
function OnMapZoomChanged()
{
    zoom=getZoom()
    if ( appConfig.get("gpsmode")=="auto" && lastMapZoom!=zoom && ( ( zoom<12 && lastMapZoom>=12)  || ( zoom>12 && lastMapZoom<=12)))
    {
        $("#gpsmode label[for='check-gpsprecis'] span:eq(0)").removeClass("gpsModeSelected")
        $("#gpsmode label[for='check-gpsapprox'] span:eq(0)").removeClass("gpsModeSelected")
        DrawMap(true) // Draw map va réajuster le label du gpsmode
    }
    lastMapZoom=zoom
}


function __getEntities()
{
    arr=[];
    $("li.etabs .entity").each(function(v){arr.push($(this).attr("entity"))})
    return arr;
}



var features=null;
var lastGpsMode=null
function GetEtabsStatus(bManual,bOnlyOnglet)
{
    // Si on demande de ne pas faire l'update en mode automatique (Par le timer: (cad: bManual==undefined))
    // On ne fait rien
    if (skipNextEtabsStatusUpdate && bManual==undefined) {
        skipNextEtabsStatusUpdate=false
        return;
    }

    skipNextEtabsStatusUpdate=false

    // Si le mode 'positionnement GPS' est actif, on ne rafraichi pas la carte
    // Risque de 'colision' entre le déplacement
    if (appConfig.get("setgps") && bManual==undefined )
    {
        return
    }


	bNeedToDraw=(features==null || isMapVisible() )
	$("#marker_accueil").css("background-image","url('assets/picto/239.gif')");
    $("#listfiltres count").html("--");
    $("#listvues count").html("--");


	$.ajax({
		url:'/main/entities',
	    format: "json",
	    type: 'GET',
        data: {zoom:getZoom(), entities:__getEntities(),onlyOnglet: bOnlyOnglet},
        hideLoadingMask: !isMapVisible(),  // Si carte invisible pas la peine d'afficher le loading  mask
	    success: function (data)
	    {
            skipNextEtabsStatusUpdate=false
            if (!bOnlyOnglet)  {
                features=data.features;

                if (appConfig.get("gpsmode")=="auto") {
                    $("#gpsmode label[for='check-gps"+data.mode+"'] span:eq(0)").addClass("gpsModeSelected")

                   /* if (lastGpsMode!=null && lastGpsMode!=data.mode) {
                        flasher("Vous êtes passé en mode de positionnement '"+data.mode+"'","violet")
                    }*/

                    lastGpsMode=data.mode;
                }

                for (var i = 0; i < features.length; i++)
                {
                    item = features[i];
                    SetEntityMarker(item.title,item.icon)
                    EnableEntityMarker(item.title,item.icon!="")
                }
                if (bNeedToDraw) DrawMap();

                refreshAllFilters();
            }


            for (var i = 0; i < data.entities.length; i++)
            {
                entry=data.entities[i]
                $("#amarker_"+entry.entity).html(entry.value);
            }



	    	
	    	$("#marker_accueil").css("background-image","url('assets/picto/map.png')");

	    }
	})
}

var oMapMarker=new Hashtable();
function DrawMap(bForceReload)
{
    if (!mapIsInitialized()) return ;

	bGps=appConfig.get("setgps");
	
	
	
	if (features==null || bForceReload) 
	{
		features=null;
		UIBlock("#map_canvas","Actualisation en cours...");
		GetEtabsStatus(true);
		return;	
	}

    if (skipNextEtabsStatusUpdate)
    {
        skipNextEtabsStatusUpdate=false
        return;
    }

	re = null;
	searchEtab = $("#searchEtab").val();
	if (searchEtab != undefined && searchEtab != "")
		re = new RegExp(".*" + searchEtab + ".*", "i");


	deleteOverlays();

	count = 0;
	for (var i = 0; i < features.length; i++) 
	{
		item = features[i];

		// Critere de recherche
		if (re != null) {
			if (!  re.test(item.title) && ! re.test(item.description)) {
				continue
			}
		}
		count++;

		switch(item.geometry.type) {
			case "Point":

				var marker=null;//=oMapMarker.get(item.title);
				if (marker==null)
				{
					html = "<strong>" + item.title + "</strong><p>" + item.description + "</p>";
					lat = parseFloat(item.geometry.coordinates[1])
					lon = parseFloat(item.geometry.coordinates[0])
					myLatlng = new google.maps.LatLng(lat, lon);
					var marker = new google.maps.Marker({
						position : myLatlng,
						draggable : bGps,
						title : "[" + item.title + "] " + item.description,
						icon : item.icon,
						updated: true,
						uid : item.title,
					});
					addMarker(marker);
					oMapMarker.put(item.title,marker);
				} /*else
				{
					if (item.icon!=marker.icon) marker.setIcon(item.icon);
					if (marker.getMap()==null) 	marker.setMap(map);
					marker.updated=true;
				}*/
				
				SetEntityMarker(item.title, item.icon)

				
				break;
		}// End switch
	}// End for


	if ( typeof mapsCallback != 'undefined') {
		mapsCallback();
		delete mapsCallback;
	}


	// Si un seul établissement, on lance le OnClick
	if (count == 1) {
		onClickMarker(marker);
	}
	
	UIUnBlock("#map_canvas");

	// Si aucun établissement
	if (count == 0) {
        //UIBlockAlert("#map_canvas", "Aucun établissement trouvé.<br>Veuillez modifier<br> les <b>filtres</b>,<b>vues</b> ou le <b>critère de recherche</b>");

        $("#alertblock").html("Aucun établissement trouvé.<br>Veuillez modifier<br> les <b>filtres</b>,<b>vues</b> ou le <b>critère de recherche</b><br><br>"+help("aucun_etablissement"))
        $("#alertblock").show();
        $("#alertblock").center();
        $("#alertblock").css("background-image",'url("assets/markers/onebit/onebit/onebit_50.png")');
        $("#alertblock").css("top",$("#map_canvas").position().top+100)

        $("#alertblock").css("left", Math.round(($("#map_canvas").width()-$("#alertblock").width())/2))

        ShowSidebar("accueil");
		return;
	}

    $("#map_canvas").css("opacity",1);
    $("#alertblock").hide();
	recenterMap();

    if (  $('#search-etab').attr("blur") != true )
    {
        $('#search-etab').blurjs({
            source : '#header',
            radius : 10,
            overlay : 'rgba(255,255,255,0.5)',
            offset : {
                x : -1,
                y : -1
            }
        });
        $('#search-etab').attr("blur",true)
    }
	w=$(window).width()
    $("#main-navigation").css("width",w*2);

}

function isKiwiVisible()
{
    return $("#kiwi_canvas").is(":visible");
}

function isGestionVisible()
{
    return $("#gestion_canvas").is(":visible");
}

function kiwiStatus()
{
    return isKiwiVisible()?"on":"off";
}

function hideKiwi()
{
    if (document.getElementById('kiwi_frame'))
    {
        document.getElementById('kiwi_frame').contentWindow.postMessage("off","*")
        $("#kiwi_canvas").hide()
    }
}

function showKiwi()
{
    if (document.getElementById('kiwi_frame'))
    {
        document.getElementById('kiwi_frame').contentWindow.postMessage("on","*")
    }
}


function ShowSidebar(id)
{

    if (id=="kiwi")
    {
        $("#main").hide()
        $("#map_canvas").hide()
        $("#kiwi_canvas").show()
        $("#map_tool").hide();
        showKiwi();

        if ( currentUid != undefined && currentPerspectiveContextuelId != undefined)
        {
            ajusterLaLongueurDeLaCarte(true);
            $("#side_perspective_contextuelle").show();
        }



    } else if (id=="accueil" || id=="perspectives_contextuelles")
    {


        $("#map_canvas").show()
        adjustHeight("#map_canvas")
        $("#map_tool").show();
        $("#main").hide()
        $(".canvas").hide();
        $("#main").html("")
        hideKiwi()
        unActiveLiEntity();
        activeLi("accueil");
        $(".btn-filter-edit").button({ "text": false,  "icons": {primary:'ui-icon-pencil'} } );

        $("body").css("overflow-y","auto");
    } else
    {
        $("#map_canvas").hide()
        $("#map_tool").hide();
        $("#alertblock").hide();

        if ($("#"+id+"_canvas").length == 0)
        {
            $("#main").show()
            $(".canvas").hide();
        }  else
        {
            $("#"+id+"_canvas").show();
        }

        hideKiwi()
        $("body").css("overflow-y","auto");
    }

    if (id!="kiwi")
    {
        setTimeout("ajusterLaLongueurDeLaCarte(false);ajusterLaLongueurDeLaCarte(false)",100); //2fois,correction d'un bug d'affichage
    }

    if (modeContextuel &&  id=="accueil" && currentUid != undefined && currentPerspectiveContextuelId != undefined)
    {
        displayContextuelle(currentUid,currentPerspectiveContextuelId);
    } else
    {
        $("#objets .side").each(function(){if (!$(this).hasClass(id)) $(this).hide()});
        $("#side_"+id).show();
    }

    if (id=="kiwi")
    {
        if ( currentUid != undefined && currentPerspectiveContextuelId != undefined)
        {
            w=$(window).width()-($("#sidebar").width()+20);
            $("#kiwi_canvas").css("width",w);
            $("#sidebar").show();
            $("#side_perspectives_contextuelles").show();
        }
    }

}


function HideSearchCancel()
{
	$("#cancelSearch").parent().hide();	
}

function ShowSearchLoading()
{
	HideSearchCancel()
	$("#loadingSearch").parent().show();
}

function HideSearchLoading()
{
	$("#cancelSearch").parent().show();
	$("#loadingSearch").parent().hide();
}

function onDblClickMarker(marker)
{
   ShowEntity( marker.uid)
}

function setFilterData(data)
{
    //console.log("setFilterData")
    //console.log(data)

    if ($("#objet_"+data.id)!=null)
        $("#objet_"+data.id).html(data.cell[1])

    if ($("#objet_picto_"+data.id)!=null)
        $("#objet_picto_"+data.id).attr("src",appConfig.get("markerpath")+ data.cell[4])
}

function refreshFilter(id)
{
    $.ajax({
        url: '/main/filter_ui'  ,
        data: {id:id},
        format: "json",
        type: 'GET',success: function( data )
        {
            setFilterData(data)
        }
    })
}

function refreshVue(id)
{
    $.ajax({
        url: '/main/vue_ui'  ,
        data: {id:id},
        format: "json",
        type: 'GET',success: function( data )
        {
            for (i=0;i<data.length;i++)
                setFilterData(data[i])

        }
    })
}

function refreshAllFilters()
{
    console.log("refreshAllFilters")
    $.ajax({
        url: '/main/filters_ui'  ,
        format: "json",
        type: 'GET',success: function( data )
        {
            for (i=0;i<data.length;i++)
                setFilterData(data[i])

        }
    })
    $( "#listfiltres" ).trigger("reloadGrid");
}

function onDragMarker(marker)
{
    pos=marker.getPosition()
    $.ajax({
              url: '/entity/'+marker.uid+'/gps'  ,
              data: {lat:pos.lat(), lon:pos.lng(),zoom:getZoom()},
              type: 'POST',success: function( response ){}
     })
}


function onClickMarker(marker)
{
    if (isMapVisible())
	    displayContextuelle(marker.uid,currentPerspectiveContextuelId);
    else if (isKiwiVisible())
    {
        ShowEntityFast(marker.uid)
    }
    else
        onDblClickMarker(marker)
}


function shareObjet(rowid,callback)
{
    $.ajax({
    	url: '/main/objet_share',
        //url: '<%= url_for  :controller=> "main",:action => "objet_share"  %>'  ,
        data: {id: rowid},type: 'GET',success: function(data)
        {

        }
    });
}

function filters_delete()
{
    var s;
    s = $("#listfiltres").jqGrid('getGridParam','selarrrow');
    $.ajax({
    	url:'/main/filters_delete',
        //url: '<%= url_for  :controller=> "main",:action => "filters_delete" %>'  ,
        data: {to_delete: s, type: "filtres"},
        type: 'DELETE',success: function( response ) {}
    });
}

function deleteFilter(id)
{
    $.ajax({
    	url:'/main/filters_delete',
        data: {to_delete: [id]},
        type: 'DELETE',success: function( response ) {}
    });
}


function  editObjet(rowid)
{
    $.ajax({
    	url:'/main/filter_edit',
        data: {id: rowid},type: 'GET',success: function(data)
        {
           // eval(data)
        }
    });
}

function checkboxfiltresFormatter(el, cval, opts)
{
    var bchk = el ? "filtres_actif" : "filtres_inactif";
    return  "<div select='"+el+"'id='select_"+cval.rowId+"' class='pointer "+bchk+"' onclick='toggleFilter("+cval.rowId+",this,\"filtres\")'/>";
}

function checkboxperspectivesFormatter(el, cval, opts)
{
    return "";
}

function checkboxUnFormatter(cellvalue, options, cell)
{
    return $('div', cell).attr('select');
}

function editPerspectiveFormatter(el, cval, opts)
{
    ret=""
    if (opts[3]) // IsWritable
    {
        ret ="<button style='width:20px; margin-right: 5px;' class='btn-filter-delete toolbtn editmode_tool' onclick='deleteFilter("+cval.rowId+")'>Supprimer</button>";
    }

    if (! opts[4]) // Deja par défaut
    {
        ret=ret + "<button style='width:20px;' class='btn-filter-edit toolbtn' onclick='editObjet("+cval.rowId+")'>Editer</button>";
    } else
    {
        ret=ret + '<div class="default" title="Cet tableau de bord s\'affichera par défaut">&nbsp;</div>'
    }

    if (!opts[3])
    {
        ret =ret+"<button style='width:20px; margin-right: 5px;' class='btn-perspective-source toolbtn' onclick='showSource("+cval.rowId+")'>Voir le code source</button>";
    }


    return ret
}

function editFormatter(el, cval, opts)
{
    ret=""
    if (opts[3]) // IsWritable
    {
        ret ="<button style='width:20px; margin-right: 5px;' class='btn-filter-delete toolbtn editmode_tool' onclick='deleteFilter("+cval.rowId+")'>Supprimer</button>";
        ret=ret + "<button style='width:20px;' class='btn-filter-edit toolbtn editmode_tool' onclick='editObjet("+cval.rowId+")'>Editer</button>";
    }


    return ret
}

function deleteFormatter(el, cval, opts)
{
    return  "<button class='btn-filter btn-filter-delete toolbtn editmode_tool' onclick='deleteFilter("+cval.rowId+")'>Supprimer</button>";

}

function checkboxvuesFormatter(el, cval, opts)
{
    var bchk = el ? "vues_actif" : "vues_inactif";
    r=opts[4]
    if (r==undefined) {
        r=$("#listvues").jqGrid('getRowData',cval.rowId);
        r= r.picto
    }

    if (opts[5])  // actif?
        return  "<div select='"+el+"'id='select_"+cval.rowId+"' class='picto pointer "+bchk+"' onclick='toggleFilter("+cval.rowId+",this,\"vues\")'>"+
            "<img id='objet_picto_"+cval.rowId+"' src='"+appConfig.get("markerpath")+ r+"'>"+
            "</div>";
    else
        return  "<div select='"+el+"'id='select_"+cval.rowId+"' class='picto pointer "+bchk+"'>"+
                "<img id='objet_picto_"+cval.rowId+"' src='"+appConfig.get("markerpath")+ r+"'>"+
                "</div>";
}

function deleteVue(id)
{
    $.ajax({
    	url:'/main/vue_delete',
        //url: '<%= url_for  :controller=> "main",:action => "vue_delete" %>'  ,
        data: {to_delete: id},
        type: 'DELETE',success: function( response ) {}
    });


}

function addFilterToVue(id)
{
    $.ajax({
    	url:'/main/vue_add_filter',
        //url: '<%= url_for  :controller=> "main",:action => "vue_add_filter" %>'  ,
        data: {id: id},
        type: 'POST',success: function( response ) {}
    });

}

function nomfiltresFormatter(el, cval, opts)
{
    return  "<div id='objet_"+ cval.rowId +"' onclick='toggleFilter("+cval.rowId+",this,\"filtres\")'>"+el+"</div>";
}

function nomvuesFormatter(el, cval, opts)
{
    if (cval.rowId.startsWith("separator"))
    {
        return "";
    }
    classe=''
   // if (opts[5])  // actif?
        return  "<div id='objet_"+ cval.rowId +"' class='listitem' class='actif' onclick='toggleFilter("+cval.rowId+",this,\"vues\")'   >"+el+"</div>";
   // else
   //     return  "<div class='inactif'  >"+el+"</div>";
}


/* =============== Gestion des scripts  =======================*/

function nomscriptsFormatter(el, cval, opts)
{
    return  "<div class='listitem' onclick='showScript("+cval.rowId+",this)'>"+el+"</div>";
}

function showScript(rowid,o)
{
	UIBlock("#main","Chargement en cours...");
	$.ajax({
    	type: 'GET',
        url: '/administration/'+rowid+'/edit',
        data: 'no',
        success: function(data)
        {
        	$("#descriptions").html(data);
        	UIUnBlock("#main")
        }
   });	
}

function checkboxscriptsFormatter(el, cval, opts)
{
    return "";
}
/* =============================================================*/


/* =============== Gestion des notifications  =======================*/

function nomnotificationsFormatter(el, cval, opts)
{
    return  "<div id='objet_"+ cval.rowId +"' class='listitem'>"+el+"</div>";
}


function checkboxnotificationsFormatter(el, cval, opts)
{
    var bchk = el ? "notifications_actif" : "notifications_inactif";

    if (opts instanceof  Array)
        a=opts[4]
    else {
        row=$("#listnotifications").jqGrid('getRowData',cval.rowId);
        a=row.picto;
        console.log(row)
    }


    bchk=bchk+ " " + a
    return  "<div select='"+el+"'id='select_"+cval.rowId+"' class='pointer "+bchk+"' onclick='toggleNotification("+cval.rowId+",this)'/>";
}
/* =============================================================*/

/* =============== Gestion des perspectives  =======================*/
function nomperspectivesFormatter(el, cval, opts)
{
    return  "<div class='listitem' onclick='showPersective("+cval.rowId+",this)'>"+el+"</div>";
}

var currentPerspective=null;
function showPersective(rowid,o)
{
	$("ul.navigation li").removeClass("active");
	$("#liperspective").addClass("active")

    	UIBlock("#main","Récupération en cours...");
        $.ajax({
        	url:'/entity/'+appConfig.get("entity")+'/perspective',
            data: {pid: rowid },type: 'GET',success: function(data)
            {
            	 currentPerspective=rowid;
                 try {
                    $("#main").html(data);
                 } catch (e)
                 {
                      console.log("Erreur lors de l'interprétation")
                 }
                 UIUnBlock("#perspective");
            }
        });
}
/* =============================================================*/


function vueStatus(rowid,response)
{
    if (response.actif)
    {
        $("#groupeheader_"+rowid).parent().parent().css({"background-color":"rgba(200, 200, 255, 0.4)"});
        $("#btn_vue_active_"+rowid).removeClass("inactif")
        $("#btn_vue_active_"+rowid).addClass("actif")
        $("#groupeheader_"+rowid).parent().css({"background-color":"transparent","color":"black"});
    } else
    {
        $("#groupeheader_"+rowid).parent().parent().css({"background-color":"#BBB"});
        $("#btn_vue_active_"+rowid).addClass("inactif")
        $("#btn_vue_active_"+rowid).removeClass("actif")
    }

    response.filtres.forEach(function (v,i)
    {
        if (response.actif)
        {
            $("#"+v+ " td:eq(1) div").addClass("actif")
            $("#"+v+ " td:eq(1) div").removeClass("inactif")
            $("#"+v).css({"background-color":"rgba(200, 200, 255, 0.4)"});
            $("#"+v+ " td:eq(1)").css({"opacity":1,"background-color":"transparent"});

        }else
        {
            $("#"+v+ " td:eq(1) div").addClass("inactif")
            $("#"+v+ " td:eq(1) div").removeClass("actif")
            $("#"+v+ " td:eq(1)").css({"opacity":0.6,"background-color":"#CCC"});
        }
    });


    $(".inactif").parent().parent().css({"background-color":"#CCC","color":"gray"});
    $(".inactif").parent().parent().find("img").css({"opacity":0.6});
    $(".actif").parent().parent().css({"color":"black"});
    $(".actif").parent().parent().find("img").css({"opacity":1});
}


function initVuesStatus()
{



    $.ajax({
        url:'/main/vues_status',
        type: 'GET',success: function( data ){

            for (i=0;i<data.length;i++)
            {
                response=data[i]
                rowid= response.id
                vueStatus(rowid,response)
            }

        }
    });
}

function showEditButtons(event,title,o)
{
    if (event.type == "mouseover") {
        $(o).find("td[title='"+title+"']").css("opacity",1)
    }   else
    {
        $(o).find("td[title='"+title+"']").css("opacity",0.2)
    }
}

function NeedToRefreshMap()
{
    $("#alertblock").html("Quand vous avez terminé de modifier les parametres de filtrage/visualisation," +
        "<br> veuillez clicker sur le lien suivant pour <br><b><a href='#' id='btnRedrawMap'>Actualiser la carte</a></b>")
    $("#alertblock").show();
    $("#alertblock").center();

    $("#alertblock").css("top",$("#map_canvas").position().top+100)
   // $("#alertblock").css("font-size","16px");
    $("#alertblock").css("background-image",'url("assets/markers/blueberry/refresh.png")');

    $("#alertblock").css("left", Math.round(($("#map_canvas").width()-$("#alertblock").width())/2))
    $("#map_canvas").css("opacity",0.3);

    $("#btnRedrawMap").click(function()
    {
        DrawMap(true);
    })
}

function  toggleVue(rowid)
{
    $.ajax({
    	url:'/main/vue_toggle',
       // url: '<%= url_for  :controller=> "main",:action => "vue_toggle"  , :method => :post %>'  ,
        data: {id:rowid},
        type: 'POST',success: function( response ){
           // refreshVue(rowid)
			vueStatus(rowid,response)

            NeedToRefreshMap();
           
           // DrawMap(true);
            skipNextEtabsStatus();
        }
    });

}

var timerToggle=null
function toggleFilter(rowid,o,type)
{
    timerToggle=setTimeout(_toggleFilter,300,rowid,o,type)
}

function  _toggleFilter(rowid,o,type)
{
    if (timerToggle==null) return;
    timerToggle=null;
    var b=$("#list"+type).jqGrid('getRowData',rowid);
    b= (b.select == "true");
    b= ! b

    $("#list"+type).jqGrid('setRowData',rowid,{select: b});
    
    if (type=="filtres")
    {
    	$('#filters_filtre-button span.ui-selectmenu-status').text("");
    }

    if (type=="filtres" || type=="vues")
    {
        $.ajax({
            url: '/main/filter_activate'  ,
            data: {id: rowid,actif: b,type: type},type: 'GET',success: function(data)
            {
                refreshFilter(rowid)
            }
        });
    }
}

function  toggleNotification(rowid,o)
{
    var b=$("#listnotifications").jqGrid('getRowData',rowid);

    b= (b.select == "true");
    b= ! b

    row=$("#listnotifications").jqGrid('getRowData',rowid);
    if (row.picto == "global" && appConfig.get("isadmin")==false)
    {
        $("#dialog-message .message").html("Cette notification ne peut être "+(b?"activée":"désactivée")+" car elle a été définie d'une manière globale par l'administrateur<br><br>Un double clique vous permettra de voir les propriétés de cette notification")

        $( "#dialog-message" ).dialog({
            resizable: false,
            height:250,
            width:500,
            modal: true,
            buttons: {
                "Fermer": function() {
                    $( this ).dialog( "close" );
                }
            }
        });

        return;
    }



    $("#listnotifications").jqGrid('setRowData',rowid,{select: b});


    $.ajax({
        url: '/notifications/'+rowid+"/toggle"  ,
        data: {actif: b},type: 'GET',success: function(data)
        {
            //refreshFilter(rowid)
        }
    });
}

