
function t2bGetMinimalGraphiqueOption() {
    return {
        chart: {type: 'area',zoomType: 'x',width:600, height:300},
        colors: [],
        title: {text: 'titre'},
        subtitle: {text: ''},
        series: [],
        xAxis: { type: 'datetime',maxZoom: 1 * 1 * 360000 },
        yAxis: {
            min:0,
            title: { text: ''},
            labels: {
                formatter: function() {
                    return this.value;
                }
            }
        },
        tooltip: {
            formatter: function() {
                return this.series.name +' <b>'+
                    Highcharts.numberFormat(this.y, 0) +'</b>';
            }
        },
        plotOptions: {
            area: {
                marker: {
                    enabled: false,symbol: 'circle',radius: 0,
                    states: {hover: {enabled: true}}
                }
            },
            line: {
                marker: {
                    enabled: false,symbol: 'circle',radius: 0,
                    states: {hover: {enabled: true}}
                }
            }

        }
    }
}

function t2bLoadGraphique(options,graphique)
{
    var start
    var end

    if (options.start != undefined && options.end != undefined)
    {
        start= options.start.getTime()/1000
        end = options.end.getTime()/1000
    }   else
    {
        var d = new Date();
        end = d.getTime()/1000
        d.setHours( d.getHours() -10 );
        start= d.getTime()/1000
    }


    if (  options.composantes ==undefined || ! options.composantes instanceof Array )
    {
        $("#"+options.container).html("composantes invalides")
        return
    }

    entity=options.entity || currentEntity
    $("#"+options.container).html('Récupération des données pour '+entity);

    composantes=options.composantes.join("|")
    $.ajax({
        url: '/entity/'+entity+'/valeursData'  ,
        data: {composanteid:composantes,dstart: start,dend: end},
        type: 'GET',success: function( response )
        {
            $("#"+options.container).html('Traitement des données');
            if (graphique == undefined)
            {
                graphique=t2bGetMinimalGraphiqueOption()
            }
            graphique.chart.renderTo=options.container

            for (i=0;i<response.length;i++)
            {
                t2bParseData(response[i],graphique)
            }

            chart = new Highcharts.Chart(graphique);

        }
    });
}

function t2bParseData(response,options)
{
    donnes={name: response.nom,data: []}
    for(i=0;i<response.data.length;i++)
    {
        d=response.data[i]
        donnes.data.push({x: d.timestamp,y: d.valeur, name: d.string});
    }
    options.series.push(donnes);
}
