

// Fonction utilisé pour les actions sur un rapport
// (Liste des rapports ou l'affichage individuel)
function rapportsHandleAction(id,nom)
{
    $("#sauvegarder").hide();

    $("#editer_"+id).bind('ajax:success', function(event,response){
        event.stopPropagation();
        $("#main").html(response)
    });

    $("#rapport_"+id).bind('ajax:success', function(event,response){
        event.stopPropagation();
        ShowOngletRapport(id,nom)
        $("#main").html(response);
        ShowRapportSide();
        initButton();
    });

    $("#dupliquer_"+id).bind('ajax:success', function(event,response){
        event.stopPropagation();
        unActiveLi();
        $("#main").html(response);
        ShowRapportSide();
        initButton();
    });

    SetRapportName(id,nom)
}

function refreshMesRapports()
{
		$.ajax({
	              url: '/rapports/rendermesrapports'  ,
	              data: {},
	              type: 'GET',success: function( response )
	              {
	              	$("#mesrapports").html(response)
	              }
	    	})	
}


function ShowRapportSide(callback)
{
	if ($('#rapportsside').length == 0 )
	{
		$.ajax({
	              url: '/rapports/sidebar'  ,
	              data: {},
	              type: 'GET',success: function( response )
	              {
	              	$("#side_rapports").html(response)
	              	ShowRapportOutils();
                    ShowSidebar("rapports");
                    $("#side_composantes").show();
                    if (callback != undefined) callback();
	              }
	    	})
   } else
   {
     ShowSidebar("rapports");
     ShowRapportOutils();
     $("#side_composantes").show();
     if (callback != undefined)  callback();
   }

   
}

var bLoadingRapportOutils=false;
var currentRapport=null;
function ShowRapportOutils()
{
	if (currentRapport == null )
        return

	datas=GetRapportCache(currentRapport)
	//if (datas==null)
	{
		$.ajax({
		              url: '/rapports/'+currentRapport+'/outils'  ,
		              data: {cache:datas!=null},
		              type: 'GET',success: function( response )
		              {
		              	  bLoadingRapportOutils=true;
		              	  $("#rapportsoutils .content").html(response);
                          $("#rapportsoutils").show();
		              	  initButton();
		              	  bLoadingRapportOutils=false;
		              }
		})
	} /*else
	{
		initButton();	
	}*/
	    	
	  		
}

function ExportRapport(format,separateur)
{
	var filtreid= $('#filters_filtre_outils').val()
    var groupeby= $('#filters_groupeby').val()
    
    
    var sortColumnName = $("#listrapport").jqGrid('getGridParam','sortname');
    var sortOrder = $("#listrapport").jqGrid('getGridParam','sortorder');
    
    if (groupeby!="-1" && groupeby!="")
    {
    	sortColumnName="xx,"+sortColumnName;	
    }

    var param="?separateur="+encodeURIComponent(separateur)+"&filtreid="+filtreid+"&groupeby="+groupeby+"&sidx="+sortColumnName+"&sord="+sortOrder;
    
    url='/rapports/'+currentRapport+'/data.'+format+param;
    if (format=="csv") {
		$("#perspectiveaction").attr("src",url)
	}
	else {
		newtab=window.open(url, '_blank');
  		newtab.focus();
	}
		
}

function closeRapport(rapportid)
{
	$("#onglet_rapport_"+rapportid).hide();
	if ($("#onglet_rapport_"+rapportid).hasClass("active"))
	{
		Rapports();
	}
}

function ShowOngletRapport(rapportid,nom)
{
	unActiveLi();
	unActiveLiEntity();
	
	if ($("#onglet_rapport_"+rapportid).length != 0 )
	{
		w=$(window).width()	
		onglet=$("#onglet_rapport_"+rapportid);
		if (onglet.offset().left+onglet.width()>w)
		{
			onglet.remove();
		}
	}
	
	if ($("#onglet_rapport_"+rapportid).length == 0 )
	{
		onglet='<li class="onglet rapport active" id="onglet_rapport_'+rapportid+'">'+
        '<div class="rapport">'+
          '<div class="marker">&nbsp;</div>'+
    	  '<a href="#" style="display:inline-block;" onclick="javascript:ShowRapport(\''+rapportid+'\')">'+nom+'</a>'+
    	  '<a href="javascript:closeRapport(\''+rapportid  +'\')" title="Fermer ce rapport" class="close">&nbsp;</a>'+			
    	'</div>'+
    	'</li>';
		$(onglet).insertAfter("#liseparator");
		removeLastOnglets();
		
   } else
   {
   	 $("#onglet_rapport_"+rapportid).show();
   	 $("#onglet_rapport_"+rapportid).addClass("active");
   }
}

function SetRapportName(rapportid,name)
{
	$("#onglet_rapport_"+rapportid+" .rapport a").first().html(name);	
}

var rapportsCache=new Hashtable();
function GetRapportCache(rapportid)
{
	return rapportsCache.get(rapportid);
}

function SetRapportCache(rapportid,datas)
{
	rapportsCache.put(rapportid,datas)
}

function setRapportCacheFilter(rapportid,filter)
{
	cache=GetRapportCache(rapportid);
	if (cache==null) return;
	cache.filtre=filter;
}

function setRapportCacheGroupe(rapportid,groupe)
{
	cache=GetRapportCache(rapportid);
	if (cache==null) return;
	cache.groupe=groupe;
}

function ClearRapportCache(rapportid)
{
	rapportsCache.remove(rapportid);
}

function ActualiserRapport(rapportid)
{
	ClearRapportCache(rapportid);
	ShowRapport(rapportid);
}

function ShowRapport(rapportid)
{
	UIBlock("#main","")
	$.ajax({
	              url: '/rapports/'+rapportid+'/show'  ,
	              data: {nolayout:true},
	              type: 'GET',success: function( response )
	              {
	              	ShowOngletRapport(rapportid,rapportid);
		  			$("#main").html(response);
		  			ShowRapportSide();
		  			initButton();	  
	              }
	});
	
}

function deleteRapportFormatter(el, cval, opts)
{
    ret ="<button style='width:20px; margin-right: 5px;' class='btn-delete toolbtn' onclick='removeRapportColumn(\""+cval.rowId+"\")'>Supprimer</button>";
    return ret
}

/*
function InitLinkRapports()
{
	$('.button-link').bind('ajax:success', function(event,response){
			event.stopPropagation();
    		unActiveLi();
  			$("#main").html(response);
  			ShowRapportSide();
  			initButton();
		});
}*/
