# -*- coding: utf-8 -*-
class AdministrationController < ApplicationController

  before_filter :require_admin , :only => [:configution,:conf]
  before_filter :require_manager
  
  def index
    set_menu menu: "gestion", rubrique: ""
    respond_to do |format|
      format.html {render :partial => "shared/rubriques"}
    end  
  end
  
  def scripts_list
    respond_to do |format|
      format.html{render :partial => "scripts"}
    end  
  end
  
  def scripts_accueil
    set_menu menu: "gestion", rubrique: "scripts"
    respond_to do |format|
      format.html {render :layout=>false}# scripts.html.erb
      format.js
    end
  end


  def conf
    @groupes=Appconfig::GROUPES
    @confs=Appconfig.all(conditions: ["id != 0"])
    respond_to do |format|
      format.js
    end
  end

  def conf_save

    configs=params[:conf]

    Appconfig.all(conditions: ["categorie = 'booleen'"]).each do |conf|
      next if configs.has_key? conf.key
      configs[conf.key] = "false"
    end

    #logger.info("#{configs}")

    configs.each do |key,value|
      Appconfig.set(key,value)
    end

    CASClient::Frameworks::Rails::Filter.configure(
        :cas_base_url => Appconfig.CAS_URL
    )

    flash.now[:notice]="La configuration a été sauvergardée"
    flasher

    if configs.has_key?(:GPS_LON_REF) ||  configs.has_key?(:GPS_LAT_REF)
      Entities::clearAll()
    end
  end

  def configuration
    set_menu menu: "gestion", rubrique: "configuration"
    @groupes=Appconfig::GROUPES
    respond_to do |format|
      format.html {render :layout=>false}# configuration.html.erb 
      #format.js {render :js => "alert(3);"}
    end
  end
  
  def add
    objet=Script.create if params[:objet]==Objet::SCRIPT
    respond_to do |format|
      format.js { render js: "$('#list#{objet.ui}' ).jqGrid().trigger('reloadGrid');"}
    end
  end
  
  # Permet de lancer l'éxécution d'un script 
  def launch
    #script=Script.find(params[:script])
    #if ! script.writable? then unauthorized; return false  end


    require 'timeout'
    output = Timeout::timeout(60*1000) {
        Script.tester params[:script] , params[:arguments]
    }
    
    respond_to do |format|
      format.json {render :json => {output: output}}
    end
     
     
  end
  
  def save
      objet=Objet.find(params[:id])
      if ! objet.writable?
        unauthorized; return false    
      end
      
      if objet.script?
        script=Script.find(objet.id)
        script.nom= params[:script][:nom] 
        script.description= params[:script][:description]
        script.script= params[:script][:script]
        script.byserver=Value.to_bool(params[:script][:byserver])
        
        serveurs=[]
        if params[:serveurs] != nil
          params[:serveurs].each do |k,v|
            serveurs<<k 
          end
        end
        
        script.serveurs=serveurs
        
        script.save
      end
  
      
 
      flash.now[:notice]="Modification apportée"
      flasher('$( "#listscripts" ).trigger("reloadGrid");');
  
  end
  
  def edit
    objet=Objet.find(params[:id])
    @objet=objet.cast
    respond_to do |format|
      format.html { render  objet.categorie.downcase , :layout => false}
      #format.js
    end  
  end
  
end