# -*- coding: utf-8 -*-
class ApplicationController < ActionController::Base
  protect_from_forgery

  # Authenticitaion CAS
  #before_filter :casconfiguration
  before_filter CASClient::Frameworks::Rails::Filter 
  before_filter :checkCasClient   , :only  => [:accueil]

  # Vérification d'identité
  before_filter :getuser,  :setConnectedUser     , :except  => [:login,:connect,:get_handler]
  before_filter :checkGuestProfile , :only  => [:accueil,:directlink,:details]

  # Construction du menu
  before_filter :buildNavigation  , :buildRubriques    , 
                :only  => [:composantes,:historiques,:journal,:show,:create,:configuration,
                           :index,:edit, :accueil,:filtres,:conf,:vues,:scripts,:default]

  # Filtres et rapports
  before_filter :mesfiltres , :only => [ :accueil,:filtres,:filtresfast,:conf]
  before_filter :mesfiltresPlus , :only => [:outils, :sidebar]

  before_filter :mesrapports , :only => [ :index,:sidebar,:rendermesrapports,:show_mesrapports]


  def logMe(message)
    logger.info("#{Time.now} (#{((Time.now.to_f-@currentTime)*1000).ceil} ms) : #{message}")
    @currentTime=Time.now.to_f
  end

  #def casconfiguration
  #  CASClient::Frameworks::Rails::Filter.configure(:cas_base_url => Appconfig.CAS_URL)
  #end
  
  def checkCasClient
     return true if !session[:cas]     # Authentification CAS non demandé ?
     return true if session[:userid]   # Une session existe déja, la construction des groupes
                                       # se fera à la prochaine connexion
     ActiveRecord::Base.logger = ::Logger.new(nil)
     logger.info("#{Time.now} ===== TRAITEMENT CAS uri:#{session[:uri]} ==============")
     user=User.find_by_uid(session[:cas_user])
     
     # Aucun utilisateur trouvé, dans la base et pas de création à la volée on quitte
     if user==nil && !Appconfig.CAS_USER_ONTHEFLY
       @username=session[:cas_extra_attributes][:displayName]
       usernotfound 
       return false
     end

     # Initialsisation du current_user
     User.current=nil

     logger.info("#{Time.now} ===== TRAITEMENT CAS E1 ==============")

     # Aucun utilisateur, mais créaton à la volée est activée
     if user==nil && Appconfig.CAS_USER_ONTHEFLY
       mandatoryValue=session[:cas_extra_attributes][Appconfig.CAS_ATTRIBUTE_MANDATORY_NAME]
       # Est-ce que la valeur de l'attribut CAS MANDATORY est égal à celui de la configuration ?
       if mandatoryValue==Appconfig.CAS_ATTRIBUTE_MANDATORY_VALUE
         user=User.create(:nom    => session[:cas_extra_attributes][Appconfig.CAS_ATTRIBUTE_NAME],
                          :prenom => session[:cas_extra_attributes][Appconfig.CAS_ATTRIBUTE_FIRSTNAME],
                          :mail   => session[:cas_extra_attributes][Appconfig.CAS_ATTRIBUTE_MAIL],
                          :password => randomId,
                          :uid    => session[:cas_user])
         # On lui affecte le profil de All par défaut
         # Réalisé dans le before create de User
         #user.profile=Group.all.profile.dup
         #user.profile.filtres=Group.all.profile.filtres
         #user.profile.save
       # Sinon, (attribut obligatoire non trouvé) on invalide la session
       else
         usernotfound
         return false
       end
     # Utilisateur existe et la config demande de mettre à joru les attributs CAS
     elsif user!=nil &&  Appconfig.CAS_CHECK_UPDATE_CONNECTION
      user.nom    = session[:cas_extra_attributes][Appconfig.CAS_ATTRIBUTE_NAME]
      user.prenom = session[:cas_extra_attributes][Appconfig.CAS_ATTRIBUTE_FIRSTNAME]
      user.mail   = session[:cas_extra_attributes][Appconfig.CAS_ATTRIBUTE_MAIL]
     end


     logger.info("#{Time.now} ===== TRAITEMENT CAS E2 #{user.uid} ==============")

     # On enlève les groupes dynamiques
     #allNoDynamicGroup=user.groups.select_if {|g| ! g.dynamic }
     #user.groups=allNoDynamicGroup
     #allNoDynamicGroup.each do |g|
     #  user.groups << g
     #end

     user.groups.select {|g|  g.dynamic }.each do |g|
       user.groups.delete g
     end

     logger.info("#{Time.now} ===== TRAITEMENT CAS E3 #{user.uid}==============")
     user.save
     logger.info("#{Time.now} ===== TRAITEMENT CAS E4 #{user.uid}==============")
     # OK utilisateur trouvé, on initialise la session
     user.groups << Group.cas_user   # Appartient au groupe CAS_USER

     logger.info("#{Time.now} ===== TRAITEMENT CAS E5 #{user.uid}==============")

     logger.info(session[:cas_extra_attributes])

     rneFromCAS=nil

     # Affectation des groupes dynamiques
     conf=Appconfig.CAS_ATTRIBUTE_GROUPE
     if conf != nil
       #logger.info("===== AFFECTATION DE GROUPE DYNAMIC ==============")
       #logger.info("#{conf}")
       conf.split(",").each do |g|
         grp=Group.dynamique(session[:cas_extra_attributes][g],user,"SSO")

         if grp
           user.groups << grp
           if ! Appconfig.CAS_ATTRIBUTE_FILTRE_RNE.empty?  && grp.filtre_id==-2
            rneFromCAS=session[:cas_extra_attributes][Appconfig.CAS_ATTRIBUTE_FILTRE_RNE]
            session[:entities_filtered]=nil
           end
         end
       end
       user.save
       #logger.info("=============================================")
     end

     logger.info("#{Time.now} ===== TRAITEMENT CAS E6 #{user.uid} ==============")

     # Ajout des groupes Zephir
     user.addToGroupesFromzephir()

     logger.info("#{Time.now} ===== TRAITEMENT CAS E7  #{user.uid} ==============")

     user.rneFromCAS=rneFromCAS if rneFromCAS!=nil
     InitialiserLaSessionPour(user)



     logger.info("#{Time.now} =====  FIN TRAITEMENT CAS #{user.uid} uri:#{session[:uri]} ==============")

     if session.has_key? :uri and ! session[:uri].empty?
       uri=session[:uri]
       logger.info("URI #{uri} redirected")
       session.except!(:uri)
       redirect_to uri
     end

    return false
     
  end
  
 
  def mesfiltres
    @filtres=Filtre.currents
    @filtres.sort! { |a,b| a.groupe <=> b.groupe }
  end
  
  def mesfiltresPlus
     @filtres=Filtre.currentsFiltreVue
     @filtres.sort! { |a,b| a.groupe.to_s <=> b.groupe.to_s }
     
     filtres=Filtre.currents
     filtres.sort! { |a,b| a.groupe.to_s <=> b.groupe.to_s }
     @filtres.concat(filtres)
  end

  def mesrapports

  end
  
  def unset_current_entity
    User.current.unsetCurrentEntity if User.current
  end
  
  def require_auth
    #redirect_to :root if User.current.guest?
    if User.current.guest?
      redirect_to( :controller => "session" , :action => "login" ,:uri => request.env['REQUEST_URI'] )
    end

  end
  
  def require_manager
    redirect_to :root if ! User.current.manager?   
  end

  def require_admin
    redirect_to :root if ! User.current.admin?
  end
  
  def flasher(action="")
    respond_to do |format|
        format.js {
          render :partial => "shared/flash" ,  :locals => { :flash => flash, :action => action }
       }
      end    
  end
  
  def unauthorized(message="Accès refusé",bShowConnectLink=false)
    logger.info("=== UNAUTHORIZED ====")
    @message=message
    @bShowConnectLink=bShowConnectLink
    @uri=request.fullpath
    respond_to do |format|
        flash.now[:error]="Vous n'êtes pas autorisé à effectuer cette action"
        format.html {render :template => "shared/unauthorized", :layout=> false}
        format.js {
          render :partial => "shared/flash" ,  :locals => { :flash => flash }
       }
      end  
  end

  def error(message="Oupps!!!")
    logger.info("=== ERROR ====")
    @message=message
    @uri=request.fullpath
    respond_to do |format|
      flash.now[:error]="Une erreur applicative est survenue"

      format.js {
        render :js => "flasher('#{message}','red')"
      }
      format.html {render :template => "shared/error", :layout=> false}
    end
  end
  
  def usernotfound
    respond_to do |format|
        format.html {render :template => "shared/usernotfound", :layout=> false}
      end  
  end

  def usernotactif
    respond_to do |format|
      format.html {render :template => "shared/usernotactif", :layout=> false}
    end
  end
  
  def erroronsave(objet=nil)
    respond_to do |format|
        flash.now[:error]="Une erreur est survenue lors de l'enregistrement"

        format.js {
          msg=""
          msg= objet.errors.full_messages.first if objet != nil
          render :js => "flasher('Impossible de sauvegarder:<br> #{msg}','red')"
       }

        format.html {render :template => "shared/unauthorized", :layout=> false}
      end  
  end

  def readable?(objet)
    if ! objet.readable?
      unauthorized; return false
    end
    true
  end
  
  def isReadable?(objet)
    if ! objet.isReadable?
      unauthorized; return false    
    end  
    true
  end
  
  def writable?(objet)
    if ! objet.writable?
      unauthorized; return false    
    end  
    true
  end
  
  def saveObject(objet)
    if !objet.save
       erroronsave objet; return false
    end
    true
  end

  def setCurrentUser(user)
    User.current=user

    # Suppression du cache des permissions pour l'utlisateur courrant
    Objet.clearPermissionsCacheForUser(User.current)

    if  session[:entities_filtered] != nil
      logger.info("Récupération des entitées dans le cache de session #entities=#{session[:entities_filtered].count}")
      User.current.entitiesFilter=session[:entities_filtered]
    else
      e=User.current.entitiesFilter
      if e.count !=0
        logger.info("Création du cache de session pour les entitées #entities=#{e.count}")
        session[:entities_filtered]=  e
      end
    end
  end

  def getuser

    @currentTime=Time.now.to_f

    # L'utilisateur est déja reconnu
    if  session[:userid] != nil  && !params[:profil]
      user= User.find_by_id(session[:userid])

      # session[:userid] ne correspond à aucun user
      if user == nil
          logger.info("========================================================================================")
          logger.info("#{Time.now}  session[:userid]=#{session[:userid]} mais non trouvé dans la base ")
          logger.info("========================================================================================")
          reset_session         # reset la session
          redirect_to  :root    # retourne à la racine
          return false
      end

      setCurrentUser user

      # Pas encore reconnu et le mode invité est actif
      # Création d'un user invité si pas en mode profile
    elsif Appconfig.GEN_ALLOW_GUEST && !params[:profil] && !session[:userid]
      User.current=nil
      logger.info("#{Time.now} ===== getuser: Création d'un user invité ====")
      u=User.create(:nom => "", :prenom => "Invité", :uid => UserSimple.generateUidForInvite,:password => randomId)
      u.groups=[Group.guest,Group.all]
      u.guest=true
      # Réalisé dans le before create de User

      #u.profile=Group.all.profile.dup
      #u.profile.filtres=Group.all.profile.filtres
      #u.profile.vues_order=Group.all.profile.vues_order
      #u.profile.vues_active=Group.all.profile.vues_active
      #u.profile.save

      if !u.save
        error "Problème lors de la création du compte invité"
        return false
      end
      session[:userid]=u.id
      session[:raw_userid]=u.id
      setCurrentUser u
      logger.info("#{Time.now} ===== getuser #{u.uid} id=#{u.id} a été créé ====")
    elsif !params[:profil]
      redirect_to  :controller => "session" , :action => "login"
      return false
    end

    # Compte désactivé
    if User.current && ! User.current.actif?
      usernotactif
      return false
    end

    if User.current && User.current.admin? and Appconfig.GEN_BASE_URL.empty?
      Appconfig.GEN_BASE_URL="#{request.protocol}#{request.host_with_port}"
    end

    true
  end

  def setConnectedUser
    if session[:raw_userid] != nil
      @connectedUser=User.find(session[:raw_userid])
      User.connected= @connectedUser
    else
      @connectedUser=nil
      User.connected=nil
    end
  end
  
  def checkGuestProfile

    #logger.info("USER=#{session[:userid]} guest?=#{session[:guest]}")
    # Mode invité ?
    if params[:profil] && Appconfig.GEN_ALLOW_GUEST
      logger.info("checkGuestProfile:Profile #{params[:profil]} demandé")
      g=Group.find_by_uid(params[:profil])
      if g!=nil
        logger.info("checkGuestProfile:Profile #{params[:profil]} exist")
        if g.guest?
          logger.info("checkGuestProfile:Profile #{params[:profil]} est bien un groupe invité -> Création d'un user invité")
          user=User.create(:nom => "Invité", :prenom => params[:profil], :uid => UserSimple.generateUidForInvite,:password => randomId)
          user.groups=[Group.guest,Group.all,g]
          user.profile=g.profile.dup
          user.profile.filtres=g.profile.filtres
          user.profile.save
          user.guest=true
          user.prenom="Mode invité"
          user.nom=params[:profil]
          user.save
          session[:userid]=user.id
          session[:raw_userid]=user.id
          session[:guest]=true
          session[:asuser]=false
          # RAZ des entitées
          user.entitiesFilter=nil
          session[:entities_filtered]=nil
          setCurrentUser user
          setUserLastaction
          logger.info("checkGuestProfile:User #{user.nom} #{user.prenom} (#{user.id}) invité a été créé")
          if ! User.connected
            session[:raw_userid]=User.current
            setConnectedUser
          end
        elsif !g.guest?
           logger.info("checkGuestProfile:Profile #{params[:profil]} n'est pas un groupe invité -> abandon")
           unauthorized("Le groupe #{params[:profil]} n'est pas un groupe en mode 'invité'")
           return false
        end
      else
        logger.info("checkGuestProfile:Profile #{params[:profil]} n'existe pas -> abandon")
         unauthorized("Le groupe #{params[:profil]} n'existe pas")
         return false
      end
    end

    if params[:uid] && (!User.connected || !User.connected.admin?(false))
      unauthorized "Vous n'êtes pas administrateur"
      return false
    end

    # Est-ce qu'on a passé en parametre ?uid=<user uid> et que l'utilisateur connecté est admin
    if User.connected && User.connected.admin? && params[:uid]
      u=User.find_by_uid(params[:uid])
      return if u==nil
      if !u.groups.exists? Group::ALL
        u.groups << Group.all
        u.save
      end

      session[:userid]=u.id
      session[:asuser]=true

      # RAZ des entitées
      u.entitiesFilter=nil
      session[:entities_filtered]=nil

      # Affectation du user courant, et calcul des entitées
      setCurrentUser u
      u.entitiesFilter=session[:entities_filtered]
    end

    # Pas de parametre  ?uid=<user uid> et pas en mode  asuser
    if User.connected && User.connected.admin? && !params[:uid] && session[:asuser]
      session[:userid]=User.connected.id
      session[:asuser]=false

      # RAZ des entitées
      User.connected.entitiesFilter=nil
      session[:entities_filtered]=nil

      setCurrentUser User.connected
      User.connected.entitiesFilter=session[:entities_filtered]

    end




  end

  def setUserLastaction
    User.current.update_attribute(:lastaction,Time.now)
  end

  def buildRubriques

  end

  def menu_for_user(user)
    a=[]
    user.menus.each do |menu|
      next if ! menu.main?
      a<< menu
    end
    a
  end

  def  buildNavigation

   # puts "buildNavigation for #{params[:controller]}"
    return if params[:controller]=="rapports"

    if session[:menu] 
      @menu_items=session[:menu] 
      @current_menu='accueil'
      return
    end
    @menu_items=[]

    @menu_items.concat menu_for_user(User.current)
    User.current.groups.each do |group|
      @menu_items.concat menu_for_user(group)
    end

    @menu_items=@menu_items.uniq{|x| x}
    @current_menu='accueil'
    session[:menu] = @menu_items
  end

  def unset_menu
    @current_menu=""
    @current_rubrique=""
    
  end

  def set_menu(opts={})
    
    @current_menu=opts[:menu]
    @current_rubrique=opts[:rubrique]
    @menu=Menu.find_by_tag(@current_menu)
    @current_entity=""
    #redirect_to controller: :main if @menu_items.index(@menu)  == nil
    
  end
  
  def randomId(size=16)
    rand(36**size).to_s(36)
  end
  
  def InitialiserLaSessionPour(user)
     # Récupération des informations su Zephir
     user.addToGroupesFromzephir()
    
     session[:userid]=user.id
     session[:raw_userid]=user.id
     session[:guest]=false
     User.current= User.find(user.id)
     #User.current.rneFromCAS=user.rneFromCAS

     session[:entities_filtered]=user.entitiesFilter

     # Met a jour le flag connecté
     User.current.update_attribute(:connected,true)
     User.sendSystemMessage(
                    "<table><tr><td style='width:50px'>#{User.current.avatarHTML}</td>
                    <td>Connexion de #{User.current.uid}</td></tr></table>",
                    Message::INFO)

  end

  def logoutUser

    # Cherche le user avec l'information de session avant qu'elle soit detruite
    User.current=User.find_by_id(session[:userid])
    return if User.current ==nil

    # Met a jour le flag connecté a faux
    User.current.update_attribute(:connected,false)
    User.sendSystemMessage(
        "<table><tr><td style='width:50px'>#{User.current.avatarHTML}</td>
        <td>Déconnexion de #{User.current.uid}</td></tr></table>",
        Message::WARNING)
  end



  def byUri?
    return params.has_key? :byUri
  end

end
