# -*- coding: utf-8 -*-
class BatchesController < ApplicationController

  include Rapports
  layout "rapport", :only => [ :rapport ]

  before_filter :require_auth
  before_filter :require_admin , :only => [:start,:stop,:clear]

  def index

     set_menu menu: "gestion", rubrique: "batches"


     @batches=Batch.currents
     respond_to do |format|
       format.html {render :layout=>false}
     end

  end

  def rapport

    batch=Batch.find_by_tag(params[:id])

    if batch==nil
      batch=Batch.find_by_id(params[:id])
    end

    @rapport=Rapport.new
    @rapport.nom=batch.nom
    @rapport.description=batch.description
    @rapport.columns=batch.columns

    @filtre=batch.filtre
    if @filtre
      @filtre.nom=@filtre.expression
    end

    list=RapportsController.computeRapport(@rapport,@filtre)


    respond_to do |format|
      format.html {
        @search=params[:search]
        @cols=[]
        @rapport.columns.each do |column|
          next if !column.valid?
          @cols<<column.nom
        end

        @list=[]
        list.each do |entry|
          @list << entry[:cell]
        end

        @path=request.url
        render template: "rapports/data.html"
      }
    end

  end

  def show

    @batches=Batch.currents
    respond_to do |format|
      format.html {render :layout=>"batches",:template => "batches/index" }
    end

  end

  def refresh
    @batches=Batch.currents
    respond_to do |format|
      format.json {render :json => getStatus}
    end
  end


  def getStatus
    list=[]
    @batches.each do |batch|
      list<< batch.json
    end

    Master.allServeurs.each do |serveur|
      list << serveur.serveurTask.json
    end

    list.to_json
  end

  def start
    @batch=Batch.find_by_id(params[:id])


    @batch.pending
    @batch.save

    script="nohup " +Appconfig.BATCH_DIR+"/#{@batch.tag}.rb &"
    logger.info(script)
    #Thread.new do
      system script
    #end



    respond_to do |format|
      format.js  { render :js => "flasher('Le batch #{@batch.tag} a été lancé','green');refreshBatchGauge()" }
    end

  end



  def stop
    @batch=Batch.find_by_id(params[:id])

    @batch.break

    respond_to do |format|
      format.js  { render :js => "flasher('Le batch #{@batch.tag} a été arrété','violet');refreshBatchGauge()" }
    end

  end

  def clear
    @batch=Batch.find_by_id(params[:id])

    @batch.clear

    respond_to do |format|
      format.js  { render :js => "flasher('Les valeurs de composantes pour #{@batch.tag} ont été supprimées','green');refreshBatchGauge()" }
    end

  end


end