# -*- coding: utf-8 -*-
class ComposantesController < ApplicationController
 
  include Importations

  before_filter :require_auth
  before_filter :require_manager , :only => [:add]
  before_filter :unset_current_entity
  
  before_filter :require_admin , :only => [:historiques,:journal,:setpermission,:setInheritedPermission,:move]
  
  def historiques
    
    composante=Composante.find(params[:id])
    composante.delHistoriques
    
    flash.now[:notice]="L'historique a été supprimé pour la composante <b>#{composante.name}</b>"
    flasher
    
  end  
  
  def journal
    composante=Composante.find(params[:id])
    composante.delJournal
    #alls=Log.all(:conditions=> ["composante_id = ?",composante.id])
    #alls.each do |a|
    #  a.destroy
    #end
    
    flash.now[:notice]="Le journal a été supprimé pour la composante <b>#{composante.name}</b>"
    flasher
    
  end  

# =============================================================
# GESTION DES SERVEURS
# ==============================================================

  # Information sur un serveur
  def serveur_infos
    serveur=Serveur.find(params[:id])
    @composante=serveur.composante
    respond_to do |format|
      format.js
    end
  end

  # Information d'état sur tous les serveurs
  def serveurs_infos
    @serveurs=Serveur.all #find_by_sql("select * from serveurs")
    respond_to do |format|
      format.js
    end
  end
  
  #Liste des actions (format json/jqgrid) pour un serveur
  def serveurs_actions
    serveur=Serveur.find(params[:id])   
    
    
    list = serveur.actions.map do |action|
      action.to_json
    end
    list = { :page => "1", :total => 1, :records => list.count , :rows => list }
    
    respond_to do |format|
      format.json { render json: list.to_json }
    end
  end

 # Démarre lel script d'éxécution d'un serveur
  def serveur_start
    serveur=Serveur.find(params[:id])
    @composante=serveur.composante
    respond_to do |format|
      if serveur.canBeExecutable?
        Thread.new {serveur.execute}
        sleep 3
        format.js {flash.now[:notice]="Serveur démarré"; render :action => "edit"}
      else
        format.js {flash.now[:error]="Vous ne disposez pas des droits suffisants";render :action => "edit"}
      end
    end
  end


  def serveur_stop
    serveur=Serveur.find(params[:id]) 
    @composante=serveur.composante
    respond_to do |format|
      if @composante.isWritable?
        serveur.stop
        sleep 3
        format.js {flash.now[:notice]="Serveur arrêté"; render :action => "edit"}
      else
        format.js {flash.now[:error]="Vous ne disposez pas des droits suffisants";render :action => "edit"}  
      end  
    end 
  end
  
  # Modification d'un serveur
  def serveur
    serveur=Serveur.find(params[:id])
    respond_to do |format|
    if serveur.composante.isWritable?
      serveur.actif= params[:serveur][:actif] == "1" ? true : false
      serveur.tunit= params[:serveur][:tunit]
      serveur.byetab= params[:serveur][:byetab]  == "1" ? true : false
      serveur.tfrequence=params[:serveur][:tfrequence].to_i
      serveur.modele=params[:serveur][:modele]
      serveur.commande=params[:serveur][:commande]
      serveur.arguments=params[:serveur][:arguments]
      actions = ActiveSupport::JSON.decode(params[:serveur_actions])
      logger.info(actions)
      
      serveur.actions.clear
      
      actions.each do |a|
        script=a["script"]
        arguments=a["arguments"]
        actif=a["actif"]
        id=a["id"]
        
        script=Script.find_by_nom(script)
        next if script==nil
        
        action=Action.find_by_id(id)
        if action==nil
          action=Action.new(arguments: arguments)    
        end
        
        action.script=script
        action.arguments=arguments
        action.actif=actif
        action.save
        
        #logger.info("+++°°°° #{action}")
        
        serveur.actions<<action
        
      end
      
      
      
      serveur.save
      

      @composante=serveur.composante
      format.js {
        flash.now[:notice]="Tâche modifiée"
        
      }
    else
      format.js {
        flash.now[:error]="Tâche non modifiée"
      }  
    end
   end
# ==============================================================    
    
  end

  def import
    @composante=Composante.find(params[:current_id])
    if  @composante.isFolder? && @composante.isWritable?
       respond_to do |format|
        format.js  
      end
    end
  end
  
  def uploadfile
    require 'fileutils'
    tmp = params[:uploadfile][:fichier].tempfile
    c=Composante.find(params[:current_id])

    @importid=Time.new.to_time.to_i().to_s()+"_"+params[:uploadfile][:fichier].original_filename

    file = File.join(ImportationController::IMPORT_PATH, @importid)
    FileUtils.cp tmp.path, file
    
    Importations::dico(file,c)
    
    respond_to do |format|
      format.js
    end
  end


  # GET /composantes/ismodifiable?fullname
  # Return:  true si User.current à le droit décrire cette composante
  def ismodifiable
    logger.info(params[:fullname])
    composante=Composante.find_by_fullname(params[:fullname])
    if composante==nil
      val=false
    else
      val=composante.isModifiable?
    end

    respond_to do |format|
      format.json { render json: {success:val}.to_json }
    end


  end

  # Recherche les composantes dont le nom ressemble à params[:term]
  # Return: [ { label:"label1", value: "id1"  },...,{ label:"labelN", value: "idN"  }]
  def search

    term="%"+params[:term]  +"%"
    results=Composante.all(conditions: ["name like ?",term], limit: 10)

    # TODO: vérifier que User.current à le droit d'y écrire
    a=[]
    results.each do |composante|
      next if  composante.isFolder?
      a<< {label: "#{composante.name} <right><b>[#{composante.fullname}]</b></right>", value: composante.fullname}
    end

    respond_to do |format|
      format.json { render json: a.to_json }
    end

  end
  
  
  def searchNode(search)
  
    term="%"+ search  +"%"
    results=Composante.all(conditions: ["name like ? or tag like ?",term,term], limit: 10)
  
    root = Composante.find_by_parent_id(-1)
    
     tree={}
     results.each do |composante|
      next if ! composante.isReadable?
        c=composante;
        while c.id!=1
          tree[c.id]=true
          c=c.parent;
        end
     end

     list=root.buildTree(tree,nil,false,true)
     
     render :json => list.to_json
    
  end

  def node
    
    if params[:search]!=nil && !params[:search].empty? && params[:id] == "-1"
      searchNode(params[:search])
      return
    end
    
    
    if params[:id] != "-1"
      @node = Composante.find_by_id(params[:id])
    else
      @node = Composante.find_by_parent_id(-1)
    end
    render :json => custom_json_for(@node)
  end

  def move

    error=false
    message=""

    source = Composante.find_by_id(params[:source])
    if ! source
      error=true
    end

    target = Composante.find_by_id(params[:target])
    if ! target
      error=true
    end

    if ! target.isFolder?
      error=true
      message="La cible doit être un dossier"
    end

    if source.serveur.id !=  target.serveur.id
      error=true
      message="Les compossantes ne peuvent être déplacées que dans le même serveur"
    end

      if !error
      source.parent=target
      message="La composante '#{source.name}' a été déplacée dans #{target.name}"
      source.save
      # Cas du déplacement dans un autre serveur, to be continue, mode recursif...
      source.childrens.each do |s|
        s.save
      end
    end


     render :json => {error: error, message: message}.to_json

  end

  def infos
    @composante = Composante.find_by_id(params[:id])
    content=ApplicationController.helpers.format_composante(@composante,nil,false,true)
    render :text => content
  end

  # POST /composantes/permission/:id
  def setInheritedPermission
    @composante = Composante.find_by_id(params[:id])
    if !@composante
      error
      return false
    end

    if Value.to_bool(params[:inherited])
      m="Heritage des permissions activée"
    else
      m="Heritage des permissions désactivée"
    end

    @composante.inherite_perm=params[:inherited]
    @composante.save
    content=ApplicationController.helpers.format_composante(@composante)

    respond_to do |format|
        format.js { render :text => "flasher('#{m}','green');refreshCurrentNode()"}
    end

  end

  # POST /composantes/permission/:id
  def setpermission
   
    @perm = Permission.find_by_id(params[:id])
    if !@perm
      error ("#{params[:id]} permission introuvable")
      return false
    end

    @user = User.find_by_uid(params[:uid])
    if !@user
      error ("#{params[:uid]} introuvable")
      return false
    end

    @perm.user= @user
    @perm.droits= params[:droits]

    respond_to do |format|
      if  @perm.save
        format.js {flash.now[:notice]="Permission modifiée"}
      else
        format.html {
          render action: "edit" , :layout => false   }
        format.js {flash.now[:error]="Impossible de modifier cette permisssion"}
        format.json { render json: @composante.errors, status: :unprocessable_entity }
      end
    end
  end

  # Récupération d'une permission
  # GET /composantes/permission/:id
  def permission
    @perm=Permission.find(params[:id] )
    @user=@perm.user
    respond_to do |format|
      format.js
    end
  end

  # Récupération de toutes les permisssions pour une composante
  # GET /composantes/permissions/:id
  def permissions
    @node = Composante.find(params[:id] )
    render :json => permissions_json(@node.permissions)
  end


  # GET /composantes
  # GET /composantes.json
  def index

    set_menu menu: "gestion", rubrique: "composantes"

    @composantes = Composante.all
    @width=350
    @allowMove=true

    respond_to do |format|
      format.html {render :layout=>false} # index.html.erb
      format.json { render json: @composantes }
    end
  end

  # GET /composantes/1
  # GET /composantes/1.json
  def show
    @composante = Composante.find(params[:id])

    respond_to do |format|
      format.html # showPerspective.html.erb
      format.json { render json: @composante.to_json() }
    end
  end

  # POST /composantes/add?current_id
  def add

    @parent = Composante.find_by_id(params[:current_id])
    texte=""
    
    # On souhaite ajouter un dossier ou une composante (Pas un serveur)
    if   params[:categorie] != "server"    && @parent!=nil && @parent.isFolder? 
      @composante = Composante.new do |c|
        c.parent_id=@parent.id 
        c.categorie=params[:categorie]
        if params[:categorie] == Composante::FOLDER
            c.tag="dossier_#{randomId(8)}"
            c.name="Nouveau dossier"
            texte="Dossier créé"
        else
           c.tag="composante_#{randomId(8)}"
           c.name="Nouvelle composante"
          texte="Composante créée"
        end

      end
    else
      tag =  params[:tag]
      name=  params[:name]
      @composante=Master.createServeur(tag,name)
      texte="Serveur créé"
    end
    
    @composante.save
    
    respond_to do |format|
      format.js { flash.now[:notice]="#{texte}"  }
    end
  end

  # DELETE /composantes/delete?ids
  def delete

    composantes = params[:composantes].map   { |t| Composante.find_by_id(t) }
    composantes.delete(nil)

    @composante=Master.serveur
    @composante= composantes.first.parent if composantes.count==1
    composantes.each {
        |t|  @composante=t if !t.destroy
    }

    respond_to do |format|
      format.js {
        flash[:notice]="Composantes supprimées"
        render :template => "composantes/add"
      }
    end
  end

  # GET /composantes/1/edit
  def edit
    
    @composante = Composante.find(params[:id])
    respond_to do |format|
     # format.html {   render  :layout => false }
      format.js 
      {
        
      }
    end
    
  end

  # POST /composantes
  # POST /composantes.json
  def create
    @composante = Composante.new(params[:composante])

    respond_to do |format|
      if @composante.save
        format.html { redirect_to @composante , notice: "Composante modifiée." }
        format.js 
        format.json { render json: @composante, status: :created, location: @composante }
      else
        format.html { render action: "new" }
        format.json { render json: @composante.errors, status: :unprocessable_entity }
      end
    end
  end

  # PUT /composantes/1
  # PUT /composantes/1.json
  def update
    @composante = Composante.find(params[:id])

    respond_to do |format|
      if @composante.update_attributes(params[:composante])
        format.html { redirect_to @composante , notice: "La composante a été modifiée" }
        format.json { head :no_content }
        format.js {flash.now[:notice]="Composante modifiée"}
      else
        format.js {flash.now[:error]="Impossible de modifier:<br> #{@composante.errors.full_messages.first}"}
        format.html {
          render action: "edit" , :layout => false   }
        format.json { render json: @composante.errors, status: :unprocessable_entity }
      end
    end
  end

  # DELETE /composantes/1
  # DELETE /composantes/1.json
  def destroy
    @composante = Composante.find(params[:id])
    @composante.destroy

    respond_to do |format|
      format.html { redirect_to composantes_url }
      format.json { head :no_content }
    end
  end
end

private
def custom_json_for(root)
  
  return [] if root==nil
  
  list = root.children.map do |node|
    node.to_json(nil,false,false,true)  if node.isReadable?
  end
  
  if root.parent_id == -1
    list={   :attr =>  { :id => "#{root.id}" , :tag => root.tag.to_s,:name => root.name.to_s},
           :data =>  { :title =>   "#{root.name.to_s }"  , :icon =>   root.getImage() }   ,
           :children => list }  
  end
  
  list.to_json
end

def permissions_json(perms)
  list = perms.map do |perm|
    perm.to_json
  end
  list = { :page => "1", :total => 1, :records => perms.count , :rows => list }
  list.to_json
end
