# -*- coding: utf-8 -*-
class EntityController < ApplicationController
 
  include Entities
  include ActionView::Helpers::NumberHelper
 
  before_filter :setUserLastaction
  before_filter :getcomposante 
  before_filter :recupererlesdates

  DEFAULT_LOG_DAYS=2        # Nombre max de jours
  DEFAULT_LOG_COUNT=200     # Nombre max des log (journal)

  DEFAULT_VALUES_COUNT=1000 # Nombre max des valeurs pour les graphiques
  DEFAULT_HISTORY_COUNT=500 # Nombre max historique
  
  # Récupération des dates passées dans la requete
  # dstart: Date de début
  # dend  : Date de fin
  # Si pas de date prend les 3  derniers jours
  # TODO : A mettre dans la conf
  def recupererlesdates
    if params[:dstart]=="-1" ||  params[:end]=="-1"
      @dend=Time.now
      @dstart=@dend  - 3600*24*DEFAULT_LOG_DAYS
    else
      @dstart=Time.at(params[:dstart].to_i)
      @dend=Time.at(params[:dend].to_i)    
    end
  end
  
  # Détermination de la composante passée en paramètre 
  # Permet de construite le @nodesToOpen pour ouvrir tous les parents de la composante
  def getcomposante
    params[:rawcomposanteid]=params[:composanteid]
    
    # Si la composante dispose d'un identifiant d'uid de serveur (ie: <uid>-<composanteid>)
    info=getInformationFromParameter(params[:composanteid])
    params[:composanteid]=info[:cid]
    params[:uid]=info[:uid]
    @entity=params[:id]
    @nodesToOpen=""
    
    e=Entities.get(@entity)
    @entity_name="[#{e.uid}] #{e.libelle}"
    
    # Vérification que le user a le droit de voir l'entité
    if ! User.current.hasEntity? @entity
      logger.info("ENtité '#{@entity}' non autorisé")
      unauthorized; return false    
    end
    
    # Si cid est passé en paramètre on va ouvrir, toutes les noeuds parents
    if !params[:cid]
      #params[:cid]=User.current.getEntityAction(@entity)  
      params[:cid]=User.current.currentComposante()
      c=Composante.find_by_id(params[:cid])
      if c
        if !c.inMaster?
          cuid=Master.serveurUidsForComposante(c)
          vuid=Value.getValue(@entity,cuid)
          if vuid != nil 
            uid=vuid.valeur  
            params[:cid]="#{uid}#{Composante::UID_SEP}#{params[:cid]}"
          end
        end  
      end
    end
    
    if params[:cid]
      info=getInformationFromParameter(params[:cid])
      c=Composante.find_by_id(info[:cid])
      uid=info[:uid]
      
      # Récupération des parents
      if c!=nil && c.isReadable?
        parents=[c.id]
        while c.parent!=nil && c.parent.id != 1
          parents << c.parent.id
          c= c.parent  
        end  
        
        # On inverse l'ordre pour commencer par le haut 
        parents.reverse!
        
        if uid != @entity &&  ! uid.include?("|")
          @nodesToOpen=parents.collect { |x| "'#{uid}-#{x}'" }.join(",")
        else
          @nodesToOpen=parents.collect { |x| "'#{x}'" }.join(",")
        end 
      end
    end

    User.current.current_entity=@entity
  end
  
  def getInformationFromParameter(valeur)
    valeur=valeur.to_s
     # Si la composante dispose d'un identifiant d'uid de serveur (ie: <uid>-<composanteid>)
    if valeur !=nil and valeur.include? Composante::UID_SEP
      cid=valeur.split(Composante::UID_SEP)[1]
      uid=valeur.split(Composante::UID_SEP)[0]
    else
      cid=valeur
      uid=params[:id]
    end 
    return {uid:uid,cid:cid} 
  end
  
  # Sauvegarde les coordonnées GPS d'une entité
  def gps
    @entity=params[:id]
    if ! User.current.gps?
      unauthorized; return false
    end

    gpsMode=Entities.determineGpsMode(params[:zoom])

    if (!params[:lat] || ! params[:lon])
      flash.now[:error]="Le paramètre 'lat' ou 'lon' n'a pas été trouvé"
      flasher
      return
    end

    Value.setComposanteValue(uid: @entity,
                             composante: (gpsMode==Profile::GPS_PRECIS)?(Master::LAT_PRECIS):(Master::LAT_APPROX),
                             valeur: params[:lat], source: "Repositionné par <user>#{User.current.uid}</user>")

    Value.setComposanteValue(uid: @entity,
                             composante: (gpsMode==Profile::GPS_PRECIS)?(Master::LON_PRECIS):(Master::LON_APPROX),
                             valeur: params[:lon], source: "Repositionné par <user>#{User.current.uid}</user>")
    
    Entities.clear(@entity)
    flash.now[:notice]="Position lon=#{params[:lon].to_f.round(5)} lat=#{params[:lat].to_f.round(5)} sauvegardée"
    flasher
    
  end

  def evaluer
    entity=params[:id]
    list=[]
    params[:expressions].each do |exp|
      exp=exp.gsub("{-","{").gsub("-}","}")
      list<<{conteneur:params[:conteneur],data:FiltreData.evaluation(entity,exp)}
    end
    render :json => list.to_json
  end
 
  
  def index

    @entity=params[:id]
    action=params[:redirect]
    @current_entity=User.current.showEntity(@entity)
    perspective=Perspective.currents.first()
    User.current.save
    respond_to do |format|
      format.html { 
                    if action == "composantes" || action == "historiques" || action == "journal"
                      redirect_to  :controller => "entity",  :action => action,:id => @entity,:cid => params[:cid]
                      return
                    end
                    
                    if action == "perspective"
                      redirect_to  :controller => "perspective",  :action => 'default',:id => @entity ,
                      :pid => params[:pid]
                      return
                    end
                    
                    # Sinon il y a une prspective apr défaut 
                    if User.current.profile.perspective != nil
                      redirect_to  :controller => "perspective",
                                   :action => 'default',
                                   :id => @entity ,
                                   :pid => User.current.profile.perspective.id  
                      return
                    # Sinon on prend la permière perspective 
                    elsif perspective!=nil  
                      redirect_to  :controller => "perspective",
                                   :action => 'default',
                                   :id => @entity ,
                                   :pid => perspective.id  
                      return  
                    end 
                    
                    # Sinon on affiche les composantes   si en mode connecté
                    if !User.current.guest?
                      redirect_to  :controller => "entity",  :action => 'composantes',:id => @entity
                    # Si en mode non connecté en affiche la première perspective
                    else
                      pid=-1
                      if  User.current.profile.perspective!=nil
                        pid=User.current.profile.perspective.id
                      elsif perspective!=nil
                        pid=perspective.id
                      end

                      redirect_to  :controller => "perspective",  :action => 'default',:id => @entity,
                                   :pid => pid
                    end
        
                    #redirect_to  :controller => "perspective",
                    #             :action => 'default',
                    #             :id => @entity ,
                    #             :pid => User.current.profile.perspective.id if User.current.profile.perspective != nil
                  }
    end
  end
  
  # Recherche des composantes dans l'arborescence
  def searchNode(search,hideLeaf=false)
    logger.info("SEARCH MODE #{search}")
    term="%"+ search  +"%"
    results=Composante.all(conditions: ["name like ? OR tag like ?",term,term], limit: 50)
  
    root = Composante.find_by_parent_id(-1)
    
    # Tous les serveurs de l'établissement
    serveurs=[Master.serveur.to_json]
    serveurs.concat(Master.allServeursForEntity User.current.current_entity)
    
    tree={}
    
    # On ajoute le parent dans l'arborescence
    results.each do |composante|
      next if ! composante.isReadable?
      next if composante.isLeaf? && hideLeaf
      composante.addChridrenToTree(tree) if  composante.isFolder?
        c=composante;
        while c.id!=1
          tree[c.id]=true
          c=c.parent;
        end
    end
    
    # Pour l'ensemble des serveurs on construit la liste à anvoyer
    list=[]
    serveurs.each do |serveur|
      uid=serveur[:attr][:serveur_uid]
      id=serveur[:attr][:rawid]
      fullname=serveur[:attr][:fullname]
      #puts "=>##############{uid}-#{id}-#{fullname}"
      list<< Composante.getComposanteFromFullname(fullname).buildTree(tree,uid,hideLeaf)
    end
  
    list={   :attr =>  { :id => "#{root.id}" , :tag => root.tag.to_s,:name => root.name.to_s},
             :data =>  { :title =>   "#{root.name.to_s }"  , :icon =>   root.getImage() }   ,
             :children => list }

    render :json => list.to_json
    
  end
  
  # Récupération des composantes filles pour un noeud
  def node
    @entity=params[:id]
    cpid=params[:rawcomposanteid]
    hideLeaf=params[:hideLeaf]=="true"
    #hideLeaf=false
    
    User.current.current_entity=@entity
    @serveur_uid=params[:serveur_uid]
    
    # SI le paramètre de recherche est positionné, on effectue la recherche
    if params[:search]!=nil && !params[:search].empty? && cpid == "-1"
      searchNode(params[:search],hideLeaf)
      return
    end

    if params[:composanteid] != "-1"
      @node = Composante.find_by_id(params[:composanteid])
    else
      @node = Composante.find_by_parent_id(-1)
    end
    render :json => custom_json_for(@node,hideLeaf)
  end
  
  # Mise à jour de valeurs des composantes pour une entité
  # Le rendu se fait par update.js.erb qui va utiliser @arrUpdated
  # pour mettre en évidence (en vert) les composantes modifiées
  def update
    @entity=params[:id]
    @arrUpdated=[]
    source="Modifié par <user>#{User.current.uid}</user>"
    valeurs=params[:valeurs]
    valeurs.each do |valeur|
        valeur=valeur[1]
        id=valeur[:id]
        v=valeur[:valeur]
        a=id.split(Composante::UID_SEP)
        uid=a[0]
        composante=Composante.find(a[1])
        response=Value.setComposanteValue(uid: uid,
                                 composante: composante,
                                 valeur: v, source: source)
        if response.error?
          val=Value.getValeur(uid,composante)
          @arrUpdated<<{id:id,valeur:val,success:false}
        else
          @arrUpdated<<{id:id,valeur:v,success:true}
        end                         
                                 
    end

    Entities.clear(@entity)
    
    respond_to do |format|
      format.js
    end
    
  end
  
  # =================================================================

  # Renvoie l'historique d'une composante au jormat json, pour jqgrid
  def valeurs
    @entity=params[:id]
    composante=Composante.find_by_id(params[:composanteid])
    return if ! isReadable? composante
    
    # Maxi 200 valeurs compris entre dstart et dend
    valeurs=ValueHistory.all(conditions: ["uid=? AND composante_id=? AND created_at >= ? AND created_at <= ?",
                             params[:uid],composante.id,@dstart,@dend],:limit => 200,:order => "created_at DESC")
    list=[]
    valeurs.sort{|t1,t2|t1.created_at <=> t2.created_at}.each do |vh|
      a=[vh.created_at.getlocal.to_f * 1000,vh.etat,vh.source,vh.valeur,vh.message] # date *1000 pour mettre en milliseconds
      list<<{ :id => @entity, :cell => a}
    end

    respond_to do |format|
      format.json {render :json => { :page => "1", :total => 1, :records => list.size , :rows =>  list}.to_json}
    end

  end

  def getValue(type,vh)

    v=vh.valeur.to_i
    case type
      when Composante::STATUT
        v=(Value.to_bool(vh.valeur))?1:(-1)
      when Composante::UPTIME
        v=(vh.etat==1)?1:(-1)
      when Composante::RATEbps
        v=vh.val4History.to_i
      when Composante::CAPACITYDISK
        v=vh.extra[:used]
    end
    v
  end

  def getLastSamplesValues(uid,composante,delayInMinutes=120,count=10)
    return [] if ! composante
    return [] if ! composante.isLeaf?
    return [] if ! composante.isReadable?

    if uid==nil
      cuid=Master.serveurUidsForComposante(composante)
      vuid=Value.getValue(@entity,cuid)
      uid=vuid.toutesLesValeurs().last if vuid!=nil
    end

    type=composante.categorie;

    dend=Time.now
    dstart=dend  - 60*delayInMinutes

    valeurs=ValueHistorySimple.all(conditions: ["uid=? AND composante_id=? AND created_at >= ? AND created_at <= ?",
                                          uid,composante.id,dstart,dend],:limit => DEFAULT_HISTORY_COUNT,:order => "created_at DESC")

    listDesValeurs=(0..(count-1)).to_a

    # Récupération de la derniere valeur
    currentValue=Value.find_by_uid_and_masteruid_and_composante_id(uid,@entity,composante.id)
    if currentValue == nil
      return listDesValeurs
    end

    #logger.info("dstart=#{dstart} dend=#{dend} current=#{currentValue.updated_at.getlocal} count=#{valeurs.count}")

    defaultValue=getValue(type,currentValue)

    # On complete la liste avec la derniere valeur, si la derniere valeur est < a la 1er valeur de l'historique demandé
    if  currentValue.updated_at.getlocal < dstart
       return (0..(count-1)).each.map { |i| defaultValue }
    end

    #if type == Composante::STATUT
    #  listDesValeurs=(0..(count-1)).each.map { |i| [-defaultValue] }
    #else
      listDesValeurs=(0..(count-1)).each.map { |i| [] }
    #end

    step=(dend-dstart)/(count.to_f)

    minIndex=count+1
    maxIndex=0
    valeurs.each do |vh|
      v=getValue(type,vh)
      stamp=vh.created_at.getlocal.to_f

      # On determine l'index de stamp dans le tableau
      index=((stamp-dstart.to_f)/step).round() - 1

      next if index<0 or index >= count

      listDesValeurs[index] << v

      minIndex=[index,minIndex].min
      maxIndex=[index,maxIndex].max
    end

    # Si c'est de type statut tous les index avant indexMin,
    # C'est forcément l'opposé de defaultValue
    if type == Composante::STATUT || type == Composante::UPTIME
      (0..(minIndex-1)).each { |x| listDesValeurs[x]=[-listDesValeurs[minIndex].min] } if minIndex>0
      ((maxIndex)..(count-1)).each { |x| listDesValeurs[x]=[defaultValue] } if maxIndex>=0

      listDesValeurs=listDesValeurs.map { |x| x.min }

      (0..(count-1)).each { |i| listDesValeurs[i]=listDesValeurs[i-1] if i>0 and listDesValeurs[i]==nil  }
    else
      listDesValeurs=listDesValeurs.map { |x| (x.size.to_f>0)?(x.sum / x.size.to_f):0 }
    end


    listDesValeurs


  end

  def getValueForRate(composante,vh)
    rate= vh.val4History.to_i
    { timestamp: vh.created_at.getlocal.to_f * 1000,
      valeur: rate,
      string: number_to_human(rate,  :precision => 4 , :units => :bps, :separator => "." ,:delimiter => "'")
    }
  end

  def getValueForStatut(composante,vh)
    { timestamp: vh.created_at.getlocal.to_f * 1000,
        valeur:composante.id.to_i, string: vh.valeur}
  end

  def getValueForDefault(composante,vh)
    { timestamp: vh.created_at.getlocal.to_f * 1000,
        valeur: vh.val4History.to_i, string: vh.valeur}
  end

  def getValueForuptime(composante,vh)
    return { timestamp: vh.created_at.getlocal.to_f * 1000,
        valeur: 1, string: "Reboot #{vh.extra[:time]}"}  if vh.etat==0

    nil
  end

  def getValueForcapacity(composante,vh)
    v=vh.val4History
    a=v.split("|")
    { timestamp: vh.created_at.getlocal.to_f * 1000,
        valeur: a[2].to_i, string: "#{a[2]}/#{a[3]}"}
  end

  
  def getValuesForALeaf(uid,composante)
      return nil if ! composante.isLeaf?
      return nil if ! composante.isReadable?
      
      if uid==nil
        cuid=Master.serveurUidsForComposante(composante)
        vuid=Value.getValue(@entity,cuid)
        uid=vuid.toutesLesValeurs().last if vuid!=nil
      end

      value4=method(:getValueForDefault)
      case composante.categorie
        when Composante::STATUT
          value4=method(:getValueForStatut)
        when Composante::RATEbps
          value4=method(:getValueForRate)
        when Composante::UPTIME
          value4=method(:getValueForuptime)
        when Composante::CAPACITYDISK
          value4=method(:getValueForcapacity)
      end

      valeurs=ValueHistorySimple.all(conditions: ["uid=? AND composante_id=? AND created_at >= ? AND created_at <= ?",
                             uid,composante.id,@dstart,@dend],:limit => DEFAULT_VALUES_COUNT,:order => "created_at ASC")
      logMe("== getValuesForALeaf:all")
      list=[]
      type=composante.categorie
      #valeurs.sort!{|t1,t2|t1.created_at <=> t2.created_at}
      logMe("== getValuesForALeaf:valeurs.sort count=#{valeurs.count}")
      valeurs.each do |vh|
        #dd=vh.created_at.getlocal.to_f * 1000
        #v=vh.valeur
        #desc=vh.valeur
        #case type
        #  when Composante::STATUT
        #    v=composante.id;desc=vh.valeur
        #  when Composante::UPTIME
        #    desc="Reboot #{vh.extra[:time]}"
        #  when Composante::RATEbps
        #    v=vh.extra[:rate]
        #    desc =  number_to_human(vh.extra[:rate],  :precision => 4 , :units => :bps, :separator => "." ,:delimiter => "'")
        #  when Composante::CAPACITYDISK
        #    v=vh.extra[:used]
        #    desc="#{vh.extra[:used]}/#{vh.extra[:available]}"
        #end
          
        #valeur=v.to_i
        v=value4.call(composante,vh)
        next if v==nil
        list<< v#{ timestamp: dd, valeur: valeur, string: desc}
      end
      logMe("== getValuesForALeaf:valeurs.each")
      list
  end

  def samples

    @entity=params[:id]
    composante=Composante.find_by_fullname(params[:composante])

    periode=120
    periode=params[:periode].to_i  if params[:periode] !=nil

    count=10
    count=params[:count].to_i  if params[:count] != nil

    list=getLastSamplesValues(nil,composante,periode,count)

    resp={spark:params[:spark],data:list}

    respond_to do |format|
      format.json {render :json => resp.to_json}
    end

  end
  
  # valeurs pour le graphique
  def valeursData
    @entity=params[:id]
    composantes=params[:composanteid];
    exclude=params[:exclude];
    uid=params[:uid]
    
    #User.current.showEntity(@entity,params[:composanteid])
    User.current.currentComposante=params[:composanteid];
    
    if !exclude
      exclude=[] 
    else
      exclude=exclude.split("|")
    end 
    
    listeDesComposantes=[]
    if ! composantes.include? "|"
      c=Composante.find_by_id(composantes)
      if c!=nil &&  c.isReadable?
        listeDesComposantes<< c  
      end
    else
      uid=nil
      composantes.split("|").each do |fullname|
        next if fullname.empty?
        c=Composante.getComposanteFromFullname(fullname)
        listeDesComposantes<< c  if c!=nil &&  c.isReadable?
      end 
    end
    
    all=[]
    
   # Pour chaque composante passée en paramètre
   listeDesComposantes.each  do |composante|
      
      if composante.isLeaf?
        next if exclude.include? composante.id.to_s
        values=getValuesForALeaf(uid,composante) 
        next if values!=nil && values.count==0
        ui=composante.graphiqueOptions;ui[:data]=values
        all<< ui if values !=nil
      else
        composante.children.each do |c|
          next if exclude.include? c.id.to_s
          values=getValuesForALeaf(uid,c) 
          next if values!=nil && values.count==0
          ui=c.graphiqueOptions ; ui[:data]=values
          all<< ui if values !=nil
        end    
      end
    end # Fin 
    
    respond_to do |format|
      format.json {render :json => all.to_json}
    end

  end
  
  
  def logs
    
    @entity=params[:id]
    
    # Récupération des composantes passées en parametre pour le filtrage
    composantes=params[:composantes]
    arr=[]
    composantes.split("|").each do |c|
      next if c.empty?
      composante=Composante.getComposanteFromFullname(c)
      next if composante==nil || !composante.isReadable?
      
      arr.concat(composante.getChildrensId())
    end

    # Récupération des logs dans la base de données
    if arr.empty?
      logs=Log.all(conditions: ["masteruid=? AND created_at >= ? AND created_at <= ?",
                             @entity,@dstart,@dend],:limit => DEFAULT_LOG_COUNT,:order => "created_at DESC")
    else
      logs=Log.all(conditions: ["masteruid=? AND created_at >= ? AND created_at <= ? AND composante_id IN (?)",
                             @entity,@dstart,@dend,arr],:limit => DEFAULT_LOG_COUNT,:order => "created_at DESC")
    end

    arrComposantes={}

    # Construction de la liste en retour
    list=[]
    logs.each do |vh|

      next if  !  vh.composante
      read=arrComposantes[vh.composante.id]
      if read == nil
        read=vh.composante.isReadable?
        arrComposantes[vh.composante.id]=read
      end

      next if ! read #vh.composante.isReadable?
      a=[I18n.localize(vh.created_at.getlocal,:format =>:day_month),vh.created_at.getlocal.to_f * 1000,vh.source,
          "#{vh.composante.name} (#{vh.composante.fullname})" ,vh.message,vh.etat,vh.composante.categorie]
      list<<{ :id =>vh.id, :cell => a}
    end

    respond_to do |format|
      format.json {render :json => { :page => "1", :total => 1, :records => list.size , :rows =>  list}.to_json}
    end
     
  end
  
  

  # Affichage des valeurs
  def show
    @entity=params[:id]
    serveur_uid=params[:serveur_uid]
    composante=Composante.find_by_id(params[:composanteid])
     
    User.current.currentComposante=params[:composanteid];
    # User.current.showEntity(@entity,"composantes&cid=#{params[:rawcomposanteid]}")
    #User.current.showEntity(@entity,params[:rawcomposanteid])
    if serveur_uid!=nil
      @parentid="#{serveur_uid}#{Composante::UID_SEP}#{composante.id}"
    else
      @parentid=composante.id
    end
   
    # On récupère les dossiers 
    @dossiers=[]
    composante.children.each do |node|
        next if node.isLeaf?
        @dossiers<<node.to_json(serveur_uid) if node.isReadable?  
    end

    # On récupère les feuilles
    @composantes=[]
    search=params[:search]
    search="" # if !search
    serveur_uid=(serveur_uid==nil)?@entity:serveur_uid
    composante.children.each do |node|
        next if node.isFolder?
        l=node.to_json(serveur_uid)
        
        # Composante non asscessible
        if ! node.isReadable?
          l[:attr][:valeur]=Value::FORBIDDEN
          l[:attr][:format]=Value::FORBIDDEN
          l[:attr][:message]="" 
          @composantes<<l 
          next 
        end
        
        # Critère de recherche ?
        #if !search.empty?
        #    bName=node.name =~ /#{search}/
        #    bTag=node.tag =~ /#{search}/
        #    next if !bName && !bTag
        #end
        
        
        value= Value.getValue(serveur_uid,node)
        if value != nil && value.valeur != Value::NOTEXIST
          l[:attr][:valeur]=value.valeur
          l[:attr][:format]=value.format(true)
          # Si en Echec on affcihe le message
          if value.etat==Value::KO
            l[:attr][:message]=value.message 
          else
            l[:attr][:message]="" 
          end
        # Pas de valeur mais en écriture et en mode édition, on présente quand même la valeur ""
        elsif  composante.isWritable?
          next if ! User.current.has(Profile::EDIT_MODE)
          l[:attr][:valeur]=""
          l[:attr][:format]=""
          l[:attr][:message]="" 
        elsif value != nil && value.valeur == Value::NOTEXIST
          next
        else
          next if ! User.current.has(Profile::EDIT_MODE)
          l[:attr][:valeur]=""
          l[:attr][:format]=""
          l[:attr][:message]=""
        end

        @composantes<<l 
    end
    
    respond_to do |format|
      format.html { render :layout => false}
    end
    
  end
  # ===================================================================
  
  # Renvoie un json contenant la liste des erreurs pour les serveurs passé en paramètre 
  def errors
    @entity=params[:id]

    @listes_des_erreurs=[]

    serveurs=nil
    if params[:serveurs]
      serveurs=params[:serveurs].split(",")
    end
   
    # Toutes les valeurs en erreurs pour l'entité   
    values=Value.all(conditions: [ "etat = ? AND masteruid= ?",Value::KO,@entity])
    values.each do |value|
      # fixes : #6619
      # Ajout du test value.composante != nil (car si la composante a été supprimée, value.composante peut retourner nil) 
      if serveurs && value.composante != nil && ! serveurs.include?(value.composante.serveur.tag)
        next
      end
      @listes_des_erreurs<<{uid:value.uid,
                           message:value.message,
                           format:value.format,
                           serveur_name:value.composante.serveur.name,
                           composante_name:value.composante.name}      
    end
      
    respond_to do |format|
      format.json {render :json => @listes_des_erreurs.to_json}
      format.html  {
        if !@listes_des_erreurs.empty?
          render :layout => false
        else
          render :text => ""
        end
      }
    end
    
  end
  
  def sideheader
    @entity=params[:id]
    respond_to do |format| 
      format.html { render :partial => "sidebar" ,:locals => {:hideperspective=>false} }
    end  
  end
  
  def composantes_side
    @entity=params[:id]
    logger.info("TOPOEN: #{@nodesToOpen} / #{User.current.getEntityAction(@entity)} ")
    respond_to do |format| 
      format.html { render :partial => "entity/composantes" ,:locals => {:nodesToOpen=>@nodesToOpen}}
    end   
  end

  # Affiche les composantes  Arbre de gauche + Liste de droite
  # La liste de droite est rendu par l'action show
  def composantes
    @entity=params[:id]
    @hideLeadWithSearchContext=true
    @current_rubrique="composantes"
    User.current.showEntity(@entity,"composantes")
    respond_to do |format| 
      format.html { render :layout => nil if params[:nolayout] }
    end
  end

  def historiques
    @entity=params[:id]
    @current_rubrique="historiques"
    #User.current.showEntity(@entity,"historiques")
    respond_to do |format|
      format.html  { render :layout => nil if params[:nolayout] }
    end
  end
  
  def journal
    @entity=params[:id]
    @current_rubrique="journal"
    #User.current.showEntity(@entity,"journal")
    respond_to do |format|
      format.html { render :layout => nil if params[:nolayout] }
    end
  end
  
  
  private
  def custom_json_for(root,hideLeaf)
    
    return [] if root==nil
    
    if root.parent_id == -1
      # Master par défaut
      list=[Master.serveur.to_json]
      #Liste des serveur pour l'entité
      serveurs=Master.allServeursForEntity(User.current.current_entity,hideLeaf)
      
      list.append serveurs

      #On crée une liste avec tout ça
      list={   :attr =>  { :id => "#{root.id}" , :tag => root.tag.to_s,:name => root.name.to_s},
             :data =>  { :title =>   "#{root.name.to_s }"  , :icon =>   root.getImage(), :hideleaf => hideLeaf }   ,
             :children => list }
              
    else

      puts "====////// #{hideLeaf} "

      list=[]
      root.children.each do |node|
        next if  node.isLeaf?  && hideLeaf
        next if !node.hasValues(@serveur_uid,@entity)  && hideLeaf
        list<<node.to_json(@serveur_uid,false,hideLeaf) if node.isReadable?
      end
                    
    end
    
    list.to_json
  end




end
