# -*- coding: utf-8 -*-
class ImportationController < ApplicationController

  IMPORT_PATH="data/importations"
  include Utils
  include Importations


  def index
    set_menu menu: "gestion", rubrique: "importations"
    respond_to do |format|
      format.html {render :layout => false}# index.html.erb
      format.js
    end
  end


  def import


    @response=Importations::csv(File.join(IMPORT_PATH, params[:importid]),
                  params[:sep],
                  params[:columns],
                  params[:header]=="1",
                  params[:checkifexist]=="1")

    puts @response.to_s

    # Si de nouvelles clefs créées on supprime la variable de session des établisements
    if @response.code==Response::NEW_KEY
      session[:entities_filtered]=nil
      @response.message="De nouvelles entités ont été ajoutées"
      User.current.entitiesFilter=nil
      User.current.save
    end

    @newEtab=@response.code==Response::NEW_KEY

    respond_to do |format|
      format.js
    end


  end

  def uploadfile

    require 'fileutils'
    tmp = params[:uploadfile][:fichier].tempfile
    @sep = params[:uploadfile][:separateur]
    @hasHeader = params[:uploadfile][:header]
    @hasCheckifexist = params[:uploadfile][:ifexist]
    #logger.info(params[:uploadfile])

    @columns=tmp.first.split(@sep)
    if ! @hasHeader

    end

    @importid="~"+Time.new.to_time.to_i().to_s()+"_"+params[:uploadfile][:fichier].original_filename


    file = File.join(IMPORT_PATH, @importid)
    FileUtils.cp tmp.path, file
    respond_to do |format|
      #format.html
      format.js
    end


  end
end