# -*- coding: utf-8 -*-
class MainController < ApplicationController

  
  before_filter :unset_current_entity
  before_filter :setUserLastaction , :only => [:alive]

  include Entities

  def buildNavigation
    super
    @vues=Vue.filtres
  end
  
 # ================== GESTION DE LA GALLERY DE MARKERS =============
  def icone
    @ico = Icone.find(params[:id])
    send_data @ico.image, :type => 'image/png',:disposition => 'inline'
  end

  # Tous les markers d'un dossier
  def markers_gallery
    @filtre=Filtre.find_by_id(params[:current])
    @filtre=Filtre.createEmptyOne if @filtre == nil
    @files = Icone.getFiles params[:dossier]
    respond_to do |format|
      # HERE
      #format.json { render json: list.to_json }
      format.js
    end
  end

  def version
    respond_to do |format|
      format.js
      format.html { render  :text => Alizes::Application::VERSION }
    end
  end
  
  # Tous les dossiers d'un dossier
  def markers_folders

    folders = Icone.getFolders params[:dossier]
    list = folders.map do |folder|

      next if params[:exclusif] !=nil and  folder !=  params[:exclusif]

       { :data => { :title =>   File.basename(folder.gsub("-","/"))  },
         :icon => "/assets/picto/folder.png",
         :state =>  (Icone.hasFolders? folder)?"closed":"" ,
         :attr =>  {:id => folder}
       }
    end

    if params[:dossier]==nil || params[:dossier].empty?
      list= { :data => { :title =>   "Pictogrammes"  },
              :children=> list ,   :state =>  "open",
              :icon => "/assets/picto/folder.png",
              :attr =>  {:id => ""}
      }
    end
    
    respond_to do |format|
      format.json { render json: list.to_json }
    end
    
  end
  
  # ================================================================

  def alive
    # Modification d'une information sur la session
    session[:last]=Time.now

    handlerPending=Handler.pending

    status={
        :connected => !User.current.guest?,  # Est-ce que User.current est tjs connecté
        :handlerPending => handlerPending.count
    }

    status[:needchangepassword]= User.current.uid==UserSimple::ADMIN  && User.current.authenticate(UserSimple::ADMIN_DEFAULT_PASSWORD)!=false

    respond_to do |format|
      format.json { render :json => status.to_json }
    end
  end

  # ================= GESTION DES DROITS ==========================
  def rights
    @objet= Objet.find(params[:id])
    list = @objet.rights.map do |right|
      right.to_json
    end
    list = { :page => "1", :total => 1, :records => @objet.rights.count , :rows => list }
    respond_to do |format|
      format.json { render json: list.to_json }
    end

  end

  def right_add
    @objet= Objet.find(params[:id])
    right=Right.new
    right.user=Group.nobody
    right.droit=Permission::READ
    @objet.rights<<right
    @objet.save
    respond_to do |format|
      format.js { render js: "$('#listrights' ).jqGrid().trigger('reloadGrid');"}
    end

  end

  def right_save
      objet=Objet.find(params[:oid])
      right=Right.find(params[:id])
      user=User.find_by_uid(params[:uid])
      #if  objet.rights.include? right && user!=nil
        right.droit=params[:droits]
        right.user=user
      #end
      right.save
      respond_to do |format|
        format.js {render :js => 'UIUnBlock("body");' }
      end
  end


  def rights_delete
    rights = params[:to_delete].map   { |t| Right.find_by_id(t) }
    rights.delete(nil)
    rights.each { |t| t.destroy }
    respond_to do |format|
      format.js { render js: "$('#listrights' ).jqGrid().trigger('reloadGrid');"}
    end
  end
  
  def objet
    objet=Objet.find(params[:id])  
    objet.nom=params[:nom]
    type=objet.categorie
    logger.info("TYPE:#{type}")
    objet.save
    respond_to do |format|
      format.js { 
        render :js => '$( "#listvues" ).trigger("reloadGrid");'    if type==  Objet::FILTRE_VUE ||  type==  Objet::VUE
        render :js => '$( "#listfiltres" ).trigger("reloadGrid");' if type==  Objet::FILTRE
        render :js => ''  if type ==  Objet::PERSPECTIVE
      }
    end
  end
  
  # ===========================================================

  # Handler ======================================================
  def set_handler
    h=Handler.create(action: params[:handler], parameters: params[:parameters])
    respond_to do |format|
      format.json { render json: {uid: h.uid}.to_json }
    end
  end


  def get_handler
      h=Handler.first( :conditions => [ "uid = ? AND consumed = false AND created_at > ?",
                                   params[:uid],Time.now.since(-60)  ])

      commande=""
      if  h
         commande=h.commande
         h.consumed=true
         h.save
      end

      respond_to do |format|
        format.text { render :text=> commande }
      end


  end
  # =============================================================

  # return la description d'un objet
  def description
    o=Objet.find(params[:id])
    respond_to do |format|
      format.json { render json: {description:o.description}.to_json }
    end
  end

  def filtres

    list = @filtres.map do |filtre|
      filtre.json
    end
    list = { :page => "1", :total => 1, :records => @filtres.count , :rows => list }

    respond_to do |format|
      format.json { render json: list.to_json }
    end
  end

  def vues
    logger.info("#{Time.now} MainController:Start vues for #{User.current.uid}")
    @vues=Vue.filtres
    logger.info("#{Time.now} MainController:vues count=#{@vues.count}")
    #logger.info(@vues)
    filtersselected=User.hashSelectedFilter
    list = @vues.map do |filtre|
      filtre.json(filtersselected)
    end
    logger.info("#{Time.now} MainController: vues mapped")
    list = { :page => "1", :total => 1, :records => @vues.count , :rows => list }

    respond_to do |format|
      format.json { render json: list.to_json }
    end
  end

  def notifications
    notifications=Notification.currents
    list = notifications.map do |notif|
      notif.json
    end
    list = { :user => User.current.uid,:page => "1", :total => 1, :records => notifications.count , :rows => list }

    respond_to do |format|
      format.json { render json: list.to_json }
    end
  end

  def composantes

    @width=250
    @allowMove=false
    respond_to do |format|
      format.html  {
        render :partial => "sidebar/composantes"
      }
    end
  end
  
  def perspectives
    @perspectives=Perspective.currents
    list = @perspectives.map do |p|
      p.json
    end
    list = { :page => "1", :total => 1, :records => @perspectives.count , :rows => list }

    respond_to do |format|
      format.json { render json: list.to_json }
    end
  end 
  
  def scripts
    @scripts=Script.currents
    list = @scripts.map do |p|
      p.json
    end
    list = { :page => "1", :total => 1, :records => @scripts.count , :rows => list }

    respond_to do |format|
      format.json { render json: list.to_json }
    end  
  end

  def filtresfast
    respond_to do |format|
      format.html {
        render   :partial => "sidebar/filtersfast"
      }
    end
  end

  def show_mesrapports
    @rapports=Rapport.currents
    respond_to do |format|
      format.html {
        render   :partial => "rapports/mesrapports"
      }
    end
  end

  def show_perspectives_contextuelles
    @currentPerspectiveContexteId=User.current.profile.currentPerspectiveContexte
    @perspectivesContextuelles=Perspective.currents
    respond_to do |format|
      format.html {
        render   :partial => "sidebar/perspectives_contextuelles"
      }
    end
  end

  def objet_share
    @objet=Objet.find(params[:id])
    respond_to do |format|
      format.js  {
        render partial: "objet_share"
      }
    end
  end

  def filter_edit
    @objet=Objet.find_by_id(params[:id])

    if @objet == nil
      respond_to do |format|
        format.js  {
          render :js =>  "flasher('Cet Objet n'éxiste plus','red')"
        }
      end
      return
    end

    # Est-ce un filtre ?
    if @objet.filtre?
      @filtre=Filtre.find(params[:id])
      @files = Icone.getFiles ""
    end

    # Une perspective ? => Cela permet de mettre par défaut la perspective
    if  @objet.perspective?
      perspective=Perspective.find(params[:id])
      User.current.profile.affecterUneperspectiveParDefaut perspective
      User.current.profile.save
    end

    if  @objet.notification?
      @notif=Notification.find(params[:id])
    end


    respond_to do |format|
      format.js  {
        render partial: "filter_edit" if @objet.filtre?
        render partial: "notifications/edit" if @objet.notification?
        #render partial: "perspective/perspectives"  if @objet.perspective?
        render :js => "flasher('La perspective a été mise par défaut','green');$( '#listperspectives' ).trigger('reloadGrid');currentPerspective='#{User.current.profile.perspectiveId}';currentPerspectiveContextuelId='#{User.current.profile.contextualPerspective.id}'" if @objet.perspective?
      }
    end
  end

  def filter_activate
    @filtre=Filtre.find_by_id(params[:id])
    if @filtre==nil
      nofilter
      return
    end
    
    exclusif=params[:exclusif]
    
    # En mode exlusif ? on supprime le filtrage existant
    if exclusif=="true"
      vues=User.current.profile.getFiltresVue
      User.current.profile.filtres.clear #=User.current.profile.filtres.delete_if {|x| !x.filtreVue? }
      User.current.profile.filtres.concat(vues)
      User.current.profile.set(Profile::FILTRE_EXC,params[:id])
    else
      User.current.profile.set(Profile::FILTRE_EXC,-1)
    end
    
    if params[:actif]=="true"
      User.current.profile.filtres<<@filtre
      User.setSelectedFilter(@filtre)
    else
      User.current.profile.filtres.delete @filtre
      User.unsetSelectedFilter(@filtre)
    end

    # On affiche la boite de dialoque précisant qu'il est necessaire de rafraichir la carte
    js="NeedToRefreshMap();"
    js="DrawMap(true);skipNextEtabsStatus();" if exclusif  # Si exclusif (ie filtre rapide) on redessine la carte

    User.current.profile.save
    respond_to do |format|
      format.js  { render :js => js } #"NeedToRefreshMap();//DrawMap(true);skipNextEtabsStatus();"}
    end
  end
  
  def nofilter
    logger.info("#{User.current.profile.id} #{User.current.profile.filtres}")
    vues=User.current.profile.getFiltresVue
    User.current.profile.filtres.clear #=User.current.profile.filtres.delete_if {|x| !x.filtreVue? } 
    User.current.profile.filtres.concat(vues)
    User.clearSelectedFilter()
    User.current.profile.save
    #current=Filtre.find_by_id(User.current.profile.get(Profile::FILTRE_EXC)) 
    #User.current.profile.filtres.delete current if current != nil
    User.current.profile.set(Profile::FILTRE_EXC,-1)
    User.current.profile.save
    logger.info("#{User.current.profile.id}  #{User.current.profile.filtres}")
    respond_to do |format|
      format.js  { render :js => "DrawMap(true);skipNextEtabsStatus();"}
    end  
  end

  def filter_ui
    @filtre=Filtre.find_by_id(params[:id])
    respond_to do |format|
      format.json {render :json => @filtre.json()}
    end
  end

  def vue_ui
    @vue=Vue.find_by_id(params[:id])
    if ! @vue
      respond_to do |format|
        format.json {render :json => []}
      end
    end


    arr=[]
    @vue.mesFiltres.each do |filtre|
      arr<< filtre.json()
    end
    respond_to do |format|
      format.json {render :json => arr}
    end
  end

  def filters_ui
    arr=[]
    filters=User.current.visibleFilters
    if filters
      filters.each do |f|
        filtre=Filtre.find_by_id(f)
        next if filtre == nil
        arr<< filtre.json()
      end
    end

    respond_to do |format|
      format.json {render :json => arr}
    end
  end
  
  def filter_test
    @filtre=Filtre.new 
    @filtre.expression=params[:expression]
    Entities.computeFilter2(@filtre)
    #puts "Erreur #{@filtre.data.error?} -#{@filtre.data.error}-"
    respond_to do |format|
      format.html { render :layout => false}
    end
  end
  
  def filter_eval
     expression=params[:expression]
     entity=params[:entity]
     if entity.empty?
       entity=Entities.first
     end
     
     valeur=Entities.evalExpression(expression,entity)
    
     respond_to do |format|
      format.html { render :text=> valeur ,:layout => false}
    end  
  end
  

  def filter_save

    @filtre=Filtre.find(params[:id])
    @filtre.commun=params
    @filtre.groupe=params[:groupe] if !@filtre.filtreVue?
    @filtre.expression=params[:expression]
    @filtre.pictogramme=params[:pictogramme]
    if Value.to_bool(params[:exclusif])
      logger.info("°°°°EXCLUSIF°°°°")
      @filtre.mode= Filtre::EXCLUSIF
    else
      @filtre.mode= Filtre::NORMAL
    end

    if ! @filtre.save
      respond_to do |format|
        format.js {
          render :js => "flasher('Impossible de sauvegarder:<br> #{@filtre.errors.full_messages.first}','red')"
        }
      end
    else
      respond_to do |format|
        format.js  {
            render :js => "refreshFilter('#{@filtre.id}');$('#dialog-filter').dialog('close');"
        }
      end
    end
  end

  def filter_add

    @filtre=Filtre.new
    @filtre.nom=@filtre.defaultName
    @filtre.save
    respond_to do |format|
      #format.js  {render :partial => "filtres"}
      format.js  { render :js => '$( "#listfiltres" ).trigger("reloadGrid");'}
      
    end

  end

  def vue_add
    @vue=Vue.new
    @vue.nom=@vue.defaultName
    @vue.default
    @vue.save
    respond_to do |format|
      format.js  { render :js => '$( "#listvues" ).trigger("reloadGrid");'}
    end
  end
  
  def vue_change_name
    vue=Vue.find(params[:id])
    nom=params[:name].split("<span")[0]  
    return if ! writable? vue
    vue.nom=nom
    return if ! saveObject vue
    
    respond_to do |format|
      flash.now[:notice]="Le nom de la vue a été changé"
      format.js  { render :partial => "shared/flash" ,  :locals => { :flash => flash }}
    end
    
  end


  def vue_add_filter
    @vue=Vue.find(params[:id])
    if ! @vue.save
      error @vue.errors.full_messages.first
      return
    end


    f=Filtre.new
    f.categorie=Objet::FILTRE_VUE
    f.nom=f.defaultName
    f.groupe=@vue.id
    if ! f.save
      error f.errors.full_messages.first
      return
    end

    @vue.filtres<<f

    return if ! saveObject @vue

    respond_to do |format|
      #format.js  {render :partial => "vues"}
      format.js  { render :js => '$( "#listvues" ).trigger("reloadGrid");'}
    end
  end


  def vues_definition

    list = Vue.currents.map do |vue|
      { :id=>vue.id, :actif => vue.actif? , :nom=> ApplicationController.helpers.format_objet(vue) , :editable=>vue.writable?(false) }
    end

    respond_to do |format|
      format.json { render json: list.to_json }
    end
  end

  def vues_status
    list = Vue.currents.map do |vue|
      {id:vue.id,actif:vue.actif?,filtres:vue.filtres.map { |x| x.id} }
    end

    respond_to do |format|
      format.json  { render :json => list.to_json }
    end
  end

  def vue_toggle

    vue= Vue.find(params[:id])
    vues=User.current.profile.vues_active
    if vues==nil
      vues=[]
    end
    if vues.include?  vue.id
      vues.delete vue.id
    else
      vues << vue.id
    end
    User.current.profile.update_attribute(:vues_active,vues)

    respond_to do |format|
      format.json  { render :json => {actif:vue.actif?,filtres:vue.filtres.map { |x| x.id} } }
    end

  end

  def vue_reorder

    current=params[:current]
    replace=params[:replace]

    order=User.current.profile.vues_order
   # logger.info("BEFORE ====#{order}")

    c=order.index(current.to_i)
    r=order.index(replace.to_i)
    if c!=nil && r!=nil
      order[c]=replace
      order[r]=current
    end
    User.current.profile.update_attribute(:vues_order,order)
   # logger.info("AFTER ====#{order}")

    respond_to do |format|
      format.js  { render :js => ""}
    end
  end

  def vue_reorderfilters
    ids=params[:ids]
    fcurrent=Filtre.find_by_id(params[:id])
    vue=Vue.find(fcurrent.groupe)
    if ! vue.writable?(false)
      flash.now[:error]="Vous n'avez pas les droits pour modifier la position du filtre"
      flasher
      return
    end


    i=0
    ids.each do |id|
      f=Filtre.find_by_id(id)
      next if f==nil
      f.position=i
      i=i.next
      f.save
    end

    r=""
    r="DrawMap(true);skipNextEtabsStatus();" if fcurrent.selected?

    respond_to do |format|
      format.js  { render :js => r}
    end

  end

  # DELETE /main/filters_delete
  def filters_delete
    objets = params[:to_delete].map   { |t| Objet.find_by_id(t) }
    objets.delete(nil)
    type=objets.first.categorie
    objets.each { |t| t.destroy if t.writable? }
    respond_to do |format|
      format.js {
        flash.now[:notice]="supprimées"
        render :js => '$( "#listvues" ).trigger("reloadGrid");'    if type==  Objet::FILTRE_VUE
        render :js => '$( "#listfiltres" ).trigger("reloadGrid");' if type==  Objet::FILTRE
        render :js => '$( "#listnotifications" ).trigger("reloadGrid");' if type==  Objet::NOTIFICATION
        render :partial => "perspective/perspectives"              if type==  Objet::PERSPECTIVE
      }
    end
  end

  def vue_delete
    @vue=Vue.find(params[:to_delete])
    @vue.destroy
    respond_to do |format|
      format.js {
        flash.now[:notice]="Vue supprimée"
        #render :partial => "vues"
        render :js => '$( "#listvues" ).trigger("reloadGrid");'
      }
    end
  end



  def accueil

   # @currentPerspectiveContexteId=User.current.profile.currentPerspectiveContexte
   # @perspectivesContextuelles=Perspective.currents
    @uri=""
    if session.has_key?(:uri)
      @uri=session[:uri]
      session.except!(:uri)
    end

    respond_to do |format|
      format.html { render :layout => nil if params[:nolayout] }
    end

  end
  
  def sidebar
    unset_menu
    respond_to do |format| 
      format.html { render :partial => "sidebar" , :layout => nil }
    end  
  end
  
  def entities

  gpsMode=Entities.determineGpsMode(params[:zoom])

  Appconfig.getEntitiesToRefresh.each do |uid|
    Entities.clear uid
  end

  Appconfig.clearEntitiesToRefresh

  if params[:onlyOnglet]
    features=[]
  else
    features=Entities.getMarkers(gpsMode,logger)
  end
  list={ type: "FeatureCollection", mode:gpsMode  ,features:features  }
  list[:entities] = []

  # Rafraichissement des onglets
  onglet=Perspective.find_by_id(User.onglet_content)
  #onglet =nil
  if onglet != nil   and   params[:entities]
    values=Value.all( :conditions=> [ "composante_id in (?) AND masteruid in (?) ",onglet.composantes.split(","),params[:entities] ])
    entities=params[:entities]
      entities.each do |entity|
        value= onglet.evaluer(entity,values)
        list[:entities] << {entity: entity, value: value}
      end
  elsif params[:entities]

    params[:entities].each do |entity|
      list[:entities] << {entity: entity, value: entity}
    end

  end





   respond_to do |format|
      format.json { render json: list.to_json } 
    end
    
  end

end