# -*- coding: utf-8 -*-
class NotificationsController < ApplicationController

  include Notifications
  before_filter :require_auth

  def index
    respond_to do |format|
      format.html  { render :layout => nil}
    end
  end

  def sidebar

    respond_to do |format|
      format.html { render :partial => "sidebar/notifications" , :layout => nil }
    end
  end

  def parameters

    filtre=Filtre.find_by_id(params[:filtre])
    User.current.notificationsFiltre=filtre
    User.current.profile.notifiers = params[:notifiers]

    User.current.profile.save

    respond_to do |format|
      format.js
    end

  end

  # Rend actif/inactif une notification pour un utilisateur
  def toggle
    @notif=Notification.find(params[:id])
    actif= Value.to_bool(params[:actif])

    # Si c'est une notification individuelle, on met à jour le profil
    # de l'utilisateur
    if @notif.individual?
      puts "USER:#{User.current.uid}"
      notifications=User.current.profile.notifications
      if actif
        notifications<< @notif.id
      else
        notifications.delete_if { |x| x==@notif.id }
      end
      User.current.profile.update_attribute(:notifications_active,notifications)
    # Sinon si c'est l'admin, on active ou désactive la notification
    elsif User.current.admin?
      @notif.data.actif=actif
      @notif.save
    end
    respond_to do |format|
      format.js {
        if byUri?
          flash.now[:notice]="La notification '#{@notif.nom}' a été #{(actif)?'activée':'désactivée'}"
          flasher
        else
          render :js => ''
        end
      }
    end
  end

  def list

    if params[:dstart]=="-1" ||  params[:end]=="-1" || params[:dstart]==nil
      messages=Message.currents
      @dend=-1
    else
      @dstart=Time.at(params[:dstart].to_i)
      @dend=Time.at(params[:dend].to_i)
      messages=Message.fromTime(@dstart,@dend)
    end

    now=Time.now

    list = messages.map do |message|
      next if params[:ui]!=nil && message.system?
      next if message.system? && ( (now - message.created_at) > 120 ) # Message system de plus de 2 minutes, on ne les affiche pas
      message.json
    end
    list=[] if list==nil

    list = { :page => "1", :total => 1, :records => list.count , :rows => list }

    # Met a jour la date de consultation des messages si au moins un message
    #if Value.to_bool(params[:ui]) and list.count > 0 and (@dend==-1)
      User.current.profile.updateNotificationLastdate
    #end

    respond_to do |format|
      format.json { render json: list.to_json }
    end

  end

  def icone
    send_data Icone.notification(params[:count]), :type => 'image/png',:disposition => 'inline'
  end

  def count
    count=Message.currents.count
    respond_to do |format|
      format.json { render json: {count:count }.to_json }
    end
  end


  def details

    #@all=Message.find_by_nuid_and_user_id(params[:nuid],User.current.id)
    @all=Message.all( :conditions => { :nuid => params[:nuid], :user_id => User.current.id })
    respond_to do |format|
      format.js
    end

  end

  # Sauvegarde de la notification
  def save
    @notif=Notification.find(params[:id])
    return if ! writable? @notif           # Vérifie si l'objet est writable

    # Modifications des paramètres de la notification
    @notif.commun=params
    @notif.expression=params[:expression]
    @notif.data.actif=Value.to_bool(params[:actif])
    @notif.data.groupedSize=params[:groupedsize]

    if User.current.admin?
      @notif.data.individual=Value.to_bool(params[:individual])
    end

    # Récupération des notifiers
    notifiers=params[:notifiers]
    notifiers.each do |notifparams|
      notifier=Notifications::Notifier.new
      notifier.setParameters(notifparams[1])
      @notif.data.setNotifier(notifier)
    end

    # Récupération des paramètres de timing
    @notif.data.days=params[:days]
    @notif.data.frequence_in_minutes=params[:frequence_in_minutes].to_i
    f=[params[:hour_first].to_i,23].min
    l=[params[:hour_last].to_i,0].max
    @notif.data.hour_first=[f,l].min
    @notif.data.hour_last=[f,l].max

    # Sauvegarde de la notification
    if ! @notif.save

      respond_to do |format|
        format.js {
          render :js => "flasher('Impossible de sauvegarder:<br> #{@notif.errors.full_messages.first}','red')"
        }
      end

    else

      respond_to do |format|
        format.js {render :js => '$( "#listnotifications" ).trigger("reloadGrid");$("#dialog-filter").dialog("close");' }
      end

    end

  end

  def add
    @notif=Notification.new
    @notif.nom=@notif.defaultName
    @notif.save

    respond_to do |format|
      format.js
    end
  end


end
