# -*- coding: utf-8 -*-
class PermissionsController < ApplicationController


  def inherit
    @composante = Composante.find(params[:id])
    if ! @composante.isWritable?
      unauthorized 
      return
    end
    
    inheritedPermissions=@composante.inheritedPermissions
    inheritedPermissions[:perms].each do |p|
      perm=p.dup
      @composante.permissions << perm
    end

    if @composante.permissions.empty?
      perm=Permission.new
      perm.composante=@composante
      perm.droits=Permission::READ
      perm.user=Group.all
      perm.save

      @composante.permissions<< perm
    end

    @composante.save
    respond_to do |format|
      format.js 
    end
     
  end

  def reorder
    @composante = Composante.find(params[:id])
    order= params[:order]
    @composante.permissions.each do |p|
      p.position=order.index(p.id.to_s)
      p.save  
    end
    flash.now[:notice]="Ordre des permissions modifié"
    flasher
    
  end


  # POST /permissions/new/:composante_id
  def new
   
    @composante = Composante.find(params[:id])
    @user=Group.all
    
    @perm = nil
    if Permission.all( :conditions => ["user_id = ? AND composante_id=?",@user.id,@composante.id]) == []
      @perm=Permission.new
      @perm.composante=@composante
      @perm.droits=Permission::READ
      @perm.user=@user  
    end
      
    respond_to do |format|
      
     if  @perm == nil
       format.js {
          flash[:error]="Une permission par défaut (#{@user.prenom}) éxiste déja"
          render "composantes/setpermission"
          }   
     end 
     
     if  @perm != nil && @perm.save
        format.js
      else
        format.html {
          render action: "edit" , :layout => false   }
       format.json { render json: @composante.errors, status: :unprocessable_entity }
      end
    end
  end

  # DELETE /permissions/:id
  def delete
    
    perms = params[:to_delete].map   { |t| Permission.find_by_id(t) }
    perms.delete(nil)
    @composante=perms.first.composante
    perms.each { |t| t.destroy }
    respond_to do |format|
      format.js {
        flash[:notice]="Permissions supprimées"
        render "composantes/setpermission"
      }
    end
  end


end