# -*- coding: utf-8 -*-
class PerspectiveController < ApplicationController
 
  include Rapports

  before_filter :unset_menu

  # Création d'une nouvelle perspective
  def add
    @perspective=Perspective.new
    @perspective.nom=@perspective.defaultName
    @error=""
    if !@perspective.save
      @error="Impossible de créer:<br> #{@perspective.errors.full_messages.first}"
    end
    @entity=User.current.current_entity
    @nouveau=true

    respond_to do |format|
      format.js  {render :partial => "perspectives"}
    end  
  end

  # Récupération du format brut d'une perspective
  def get 
     @perspective=Perspective.find(params[:id])
     respond_to do |format|
      format.json {render :json => {data: @perspective.data.gsub('"',"'") ,
                                    contexte: @perspective.contexte,
                                    modeEntity: @perspective.modeEntite?,
                                    modeContexte: @perspective.modeContextuel? }.to_json
                  }
    end  
  end

  def source
    @perspective=Perspective.find_by_id(params[:id])
    @perspective=Perspective.find_by_tag(params[:id]) if @perspective==nil

    if ! @perspective
      error "Introuvable"
      return false
    end

    if ! @perspective.readable?
      unauthorized
      return false
    end

    if ! @perspective.perspective?
      error "N'est pas un tableau de bord"
      return false
    end

    respond_to do |format|
      format.js
    end

  end

  def compute
    @perspective=Perspective.find_by_id(params[:id])
    @perspective=Perspective.find_by_tag(params[:id]) if @perspective==nil

    if ! @perspective.perspective?
      error "N'est pas un tableau de bord"
      return false
    end

    @perspective.evaluer(params[:entity])
    @entity=params[:entity]
    @mode=params[:mode]
    @conteneur=params[:conteneur]
    respond_to do |format|
      format.js
    end
  end
  
  def default
    @entity=params[:id]
    nolayout=params[:nolayout]
    @perspective=Perspective.find_by_id(params[:pid])
    if @perspective==nil
      redirect_to :root
      return
    end

    return if ! readable? @perspective
    @current_rubrique="perspectives"
    @editMode=(params[:edit]=="true") && @perspective.writable?
    User.current.showEntity(@entity,"perspective&pid=#{@perspective.id}")
    respond_to do |format|
      if nolayout
        format.html { render layout: "empty"} 
      else  
        format.html 
      end
      
      format.js 
    end
  end

  def details
    @entity=params[:entity]
    if ! User.current.hasEntity?(@entity)
      unauthorized("Vous n'êtes pas autorisé à voir '#{@entity}'")
      return false
    end
    @perspective=Perspective.find_by_id(params[:id])

    if @perspective == nil and (params[:id] =~ Objet::TAG_FORMAT)
      @perspective=Perspective.find_by_tag(params[:id])
    end

    if @perspective == nil
      unauthorized("tableau de bord introuvable")
      return false
    end

    if ! @perspective.readable?
      unauthorized("Vous n'êtes pas autorisé à voir ce tableau de bord",true)
      return false
    end

    @noEdition=true
    respond_to do |format|
      format.html { render "showPerspective",:layout => "perspective"}
    end

  end

  def showPerspective
    @entity=params[:id]
    if !  User.current.hasEntity?(@entity)
      unauthorized("Vous n'êtes pas autorisé à voir '#{@entity}")
      return false
    end
    @perspective=Perspective.find_by_id(params[:pid])

    if @perspective == nil
      unauthorized("tableau de bord introuvable")
      return false
    end

    if ! @perspective.readable?
      unauthorized("Vous n'êtes pas autorisé à voir ce tableau de bord")
      return false
    end


    @current_rubrique="perspectives"
    User.current.showEntity(@entity,"perspective&pid=#{@perspective.id}")

    #@perspective.evaluer(@entity)

    respond_to do |format|
      format.html { render :layout => false}
      format.js
    end
  end
  
  def export
    @perspective=Perspective.find(params[:pid])
    @perspective.export(self) 
    
      
  end

  def evaluer
    @entity=params[:entity]
    aformater=params[:aformater]
    values=[]
    if aformater
      aformater.each do |format|
        value=Rapports::RapportColumn.formater(@entity,format,false)
        #logger.info("Perspective.evaluer:FORMAT:#{format} entity:#{@entity} => #{value}")
        values<<value
      end
    end
    
    render :text => values.to_json
  end

  def browser
    @filtre=Filtre.createEmptyOne
    @ckeditor={ :CKEditor => params[:CKEditor], :CKEditorFuncNum => params[:CKEditorFuncNum] }
    respond_to do |format|
      format.html  { render :layout=>"browser"}
    end
  end


  def save
    @perspective=Perspective.find(params[:id])
    @perspective.data=params[:portlets].gsub("&quot;",'"').gsub('&#39;',"'")
    @perspective.nom=params[:nom]
    @perspective.contexte=params[:contexte]
    @perspective.description=params[:description]
    @perspective.tag=params[:tag]
    @entity=params[:entity]

    @error=""
    if !@perspective.save
      @error="Impossible de sauvegarder:<br> #{@perspective.errors.full_messages.first}"
    end

    respond_to do |format|

        format.js {render :partial => "perspectives"}


    end
  end
  
  
end