# -*- coding: utf-8 -*-
class RapportsController < ApplicationController
  
  before_filter :unset_current_entity

  layout "rapport", :only => [ :data, :directlink ]

  include Rapports
  include Utils
  include Entities
  
  def mesrapports
    @rapports=Rapport.currents
    @randomid = rand(36**16).to_s(36)
  end

  def check_writable
    if ! @rapport.writable?
      flash.now[:error]="Vous ne disposez pas des autorisations nécessaires"
      flasher
      return false
    end
    @rapport.writable?
  end

  def index
    #set_menu menu: "rapports", rubrique: ""
    respond_to do |format|
      format.html {
        if params[:nolayout]
          render(template: "rapports/manage", :layout => nil) 
        else
          render template: "rapports/manage"
        end
       }
      format.js
    end
  end

  def manage
   # set_menu menu: "rapports", rubrique: "manage"

    respond_to do |format|
      format.html
    end
  end

  def create
    set_menu menu: "rapports", rubrique: "create"
    @rapport=Rapport.new
    @rapport.id=-1
    respond_to do |format|
      format.html # create.html.erb
      format.js
    end
  end
  
  def sidebar
    @rapports=Rapport.currents
    @entity=params[:id]
    respond_to do |format| 
      format.html { render :partial => "sidebar" }
    end  
  end
  
  def outils
    @rapport=Rapport.find(params[:id])
    @cache=Value.to_bool(params[:cache])
    respond_to do |format| 
      format.html { render :layout => nil }
    end  
  end

  def show
    set_menu menu: "rapports", rubrique: ""
    @rapport=Rapport.find(params[:id])
    respond_to do |format|
      format.html  { render :layout => nil if params[:nolayout] }
    end
  end
  
  def rendermesrapports
    respond_to do |format|
      format.html  { render :partial => "mesrapports" }
    end
  end

  def self.computeRapport(rapport,filtre)
    # On va récupérer dans toutes les colonnes, les composantes
    mapComposantes=[]
    rapport.columns.each do |column|

      arr=column.composantes2()
      #puts "Composante pour #{column.compiled}=#{arr.join(',')}"
      arr.each do |id|
        if ! mapComposantes.include?(id)
          mapComposantes<<id
        end
      end
      logger.debug("#{column.format} => #{column.compiled}")
    end
    #logMe("== buildRapport:Composantes #{mapComposantes}")

    # Récupération dans la base de toutes les valeurs
    allValues=ValueSimple.all(conditions: [ "composante_id in (?)",mapComposantes])

    # == Construction de la liste de données
    # Récupère toutes les entitées
    if filtre == nil
      entities=Entities.getCurrents()
    else
      entities=filtre.evaluation.content
    end

    user=User.current

    columns=rapport.columns
    list=[]
    entities.each do |entity|

      a=[]
      values=allValues.select { |x| x.masteruid == entity } # Sélection des valeurs pour l'entité courrante

      # Calcule de chacune des colonnes
      b=false
      columns.each do |column|
        next if !column.valid?

        v=column.compute2(entity,values)
        v="" if v=='""'
        a<<v
      end
      # Ajoute à la liste
      list<<{ :id => entity, :cell => a}
    end

    list
  end
  
  
  def buildRapport
    groupeby=@rapport.groupeby
    order=params[:sidx].to_i
    sord=params[:sord]

    if params[:groupeby]!=nil && params[:groupeby] != "undefined" && !params[:groupeby].empty?
      groupeby=params[:groupeby].to_i
    end
    
    if params[:filtreid]!=nil && params[:filtreid] != "-1" && !params[:filtreid].empty?  &&  params[:groupeby] != "undefined"
      logger.info("000000 === ==== = = |#{params[:filtreid]}| ============= ")
      @filtre=Filtre.find_by_id(params[:filtreid])
    else
      @filtre=@rapport.filtre
    end

    # PLUS NECESSAIRE, Car filtre par défaut changé en 'filtre défini par le créateur'
    #if  params[:filtreid]!=nil && params[:filtreid] == "-1" && params[:groupeby] != "undefined"
    #  @filtre=nil
    #end
    
    if params[:groupeby]!=nil && params[:groupeby].empty?
      groupeby=-1
    end
    

    if @rapport.writable?
      @rapport.filtre=@filtre
      @rapport.groupeby=groupeby.to_s()
      @rapport.save
    end


    list=RapportsController.computeRapport(@rapport,@filtre)


    if groupeby != -1 && params[:sidx]
      order=params[:sidx].split(",")[1].to_i
      list=list.sort_by {|a| [a[:cell][groupeby], a[:cell][order]] }
      if sord=="desc"
      list=list.reverse
      end
    else
      if sord=="desc"
        list.sort! { |b, a|  a[:cell][order] <=> b[:cell][order]}
      else
        list.sort! { |a, b|  a[:cell][order] <=> b[:cell][order]}
      end
    end
    list
  end

  def directlink
    data
  end
  
  def data
     
    @rapport=Rapport.find_by_id(params[:id])
    @rapport=Rapport.find_by_tag(params[:id]) if !@rapport

    if !@rapport
      error "Rapport #{params[:id]} introuvable"
      return false
    end

    if ! @rapport.rapport?
      error "N'est pas un rapport"
      return false
    end

    if ! @rapport.readable?
      unauthorized("Vous n'êtes pas autorisé à voir ce rapport",true)
      return false
    end



    @currentTime=Time.now.to_f
    list=buildRapport
    
    respond_to do |format|
      
      # Affcihage dans jqgrid
      format.json {
        json={ :page => "1", :total => 1, :records => list.size , :rows =>  list}.to_json
        render :json =>  json
       }
       
       # Sortie CSV
       format.csv {
          cols=[]
          @rapport.columns.each do |column|
            next if !column.valid?
            cols<<column.nom
          end
          separateur=";"
          separateur=params[:separateur] if params[:separateur]!=nil && !params[:separateur].empty?
          
          require 'csv'
          csv_string = CSV.generate(:col_sep => separateur) do |csv|
            csv << cols
            list.each do |entry|               
              csv << entry[:cell]
            end 
          end
          filename = "#{@rapport.nom}-#{Time.now.to_date.to_s}.csv" 
          send_data(csv_string, :type => 'text/csv; charset=utf-8; header=present', :filename => filename) 
       }
       
       format.html {
          @search=params[:search]
          @cols=[]
          @rapport.columns.each do |column|
            next if !column.valid?
            @cols<<column.nom
          end 
          
          @list=[]
          list.each do |entry|               
              @list << entry[:cell]
          end 
          
          
          @path=request.url
          render template: "rapports/data.html"
            
       }
       
    end  
  end
  
  def maj
    @response=Utils::Response.new
    @response.error "Erreur lors de la mise à jour"
    @rapport=Rapport.find(params[:id])
    source="Modifié par #{User.current.uid} depuis rapport '#{@rapport.nom}'"
    valeurs=params[:valeurs]
    valeurs.each do |valeur|
        valeur=valeur[1]
        #logger.info(valeur.to_s())
        column=@rapport.columns[valeur["column"].to_i]
        #@response=Value.setComposanteValue(uid: valeur["uid"],composante: column.composante,valeur: valeur["value"],source: source)
        @response=Value.setValue(ckey: Master.composanteKey, ckeyvalue: valeur["uid"], composante: column.composante,value: valeur["value"],source: source)
        break if @response.error?
    end
    
    respond_to do |format|
      format.html {
        flash.now[:error]=@response.message if @response.error?
        render :js => ""
      }
    end
    
    
  end

  # List des colonnes
  # Format json pour jqgrid
  def columns
    @rapport=Rapport.find(params[:id])
    list = @rapport.columns.map do |column|
      column.id = randomId if column.id==nil
      { :id => column.id, :cell => [ '',column.nom, column.format] }
    end
    render :json => {:page => "1", :total => 1, :records => @rapport.columns.size , :rows =>  list}.to_json
  end

  # Edition d'un rapport
  def edit
    set_menu menu: "rapports", rubrique: ""
    @rapport=Rapport.find(params[:id])
    respond_to do |format|
      format.html {
        render template: "rapports/create",  :layout => nil if check_writable
      }
    end
  end

  # Dupliquation d'un rapport
  def copy
    r=Rapport.find(params[:id])
    @rapport=r.dup
    @rapport.user = User.current
    @rapport.nom<< " (copie)"
    @rapport.tag=""
    @rapport.save
    respond_to do |format|
      format.html {
        render template: "rapports/show", :layout => nil if check_writable
      }
    end
  end

  # Suppression
  def delete
    @rapport=Rapport.find(params[:id])
    @rapport.destroy
    respond_to do |format|
      format.html {
        redirect_to :action => "manage"
      }
      
      format.js {
        render :js => "Rapports();refreshMesRapports();"
      }
    end
  end
  
  def columns_order
    @rapport=Rapport.find(params[:id]) 
    columns=[]
    cls=params[:columns] 
    cls.each do |c|
      columns<< @rapport.columns[c.to_i]
    end
    @rapport.columns=columns
    @rapport.save
    flash.now[:notice]="L'ordre des colonnes a été sauvegardé"
    flasher
    
  end
  
  
  def new
    
    columns=[]
    if (params[:id]==nil || params[:id]=="-1")
      @rapport=Rapport.new
      @rapport.nom=@rapport.defaultName
      @rapport.description="Description du rapport"
      c=RapportColumn.new
      c.nom=Master.composanteKey.name
      c.format="{" +Master.composanteKey.fullname + "}"
      columns<<c

      c=RapportColumn.new
      c.nom=Master::LIBELLE.name
      c.format="{" +Master::LIBELLE.fullname + "}"
      columns<<c

      @rapport.addColumn(Master.composanteKey.tag)
      @rapport.addColumn("libelle")
     
    else
      @rapport=Rapport.find(params[:id])
    end
    
    @rapport.nom=params[:nom] if params[:nom]
    @rapport.description=params[:description] if params[:description]
    @rapport.tag=params[:tag] if params[:tag]

    count=params[:count].to_i
    
    (0..count-1).each do |i|
      c=RapportColumn.new
      c.nom=params[:columns][i.to_s][:nom]
      c.format=params[:columns][i.to_s][:format]
      c.id=params[:columns][i.to_s][:id]
      columns<<c 
    end
    @rapport.columns=columns

    if !@rapport.save
      respond_to do |format|
        format.js {
          render :js => "flasher('Impossible de créer:<br> #{@rapport.errors.full_messages.first}','red')"
        }


      end
    else
      respond_to do |format|
        format.html {
          flash.now[:notice]="Rapport créé"
          render :js => "ShowRapport('#{@rapport.id}')"
        }

        format.js {
          render :js => "refreshMesRapports();ShowRapport('#{@rapport.id}');"
        }
      end
    end



    
  end

  def addcolumn
    @rapport=Rapport.find(params[:id])
    nom=params[:nom]
    format=params[:detail]
    id = randomId
    columns=@rapport.columns
    c=RapportColumn.new
    c.nom=nom
    c.format=format
    c.id = id
    columns<<c
    @rapport.columns=columns
    @rapport.save
    respond_to do |format|
      format.html
      format.js {
        render :partial => "rapport"
      }
    end
  end






end