# -*- coding: utf-8 -*-
class SessionController < ApplicationController

  skip_filter :checkCasClient, :getuser, :setConnectedUser,:buildNavigation,:buildRubriques ,:only=> :logout

  def login

    @uri="" # Url de retour
    @uri=params[:uri] if params[:uri]

    # La session existe déja, avec une session invité
    # On détruit l'utilisateur invité
    if session[:userid]!=nil
      logger.info("SessionController userid=#{session[:userid]} trouvé -> reset session")
      u=User.find_by_id( session[:userid])
      if u!=nil and u.guest?
        logger.info("SessionController user=#{u.uid} trouvé -> destroy it")
        u.destroy
      end

      # Supprime la session
      reset_session

    end

    session[:uri]=@uri

    logger.info("SessionController uri=#{session[:uri]} cas=#{params[:cas]}")

    # Indique que l'on souhaite une authentification SSO/CAS
    if params[:cas]=="true"
      logger.info("SessionController cas find -> redirect to root")
      session[:cas]=true
      redirect_to  :root  # Le plugin SSO , se chargera de recupérer l'utilisateur
      return
    end
    
    @nocas=params[:cas]=="false"

    # Si une session existe on renvoie vers la racine
    if session[:userid]
      logger.info("SessionController session[:userid] exists -> redirect to root")
      redirect_to  :root
      return
    end

    # Redirection vers le formulaire d'authentification
    respond_to do |format|
      format.html { render :layout => false } # login.html
    end

  end

  def connect

    # Recherche de l'utilisateur dans la base
    #u=User.first(conditions: [ "uid = ? AND password = ?", params[:login], params[:password]])
    u=User.find_by_uid(params[:login])

    if ! (u &&  u.authenticate(params[:password]) )
      flash.now[:error]="Echec de l'authentification"
      flasher
      return
    end
    
    # On enlève les groupes dynamiques
    u.groups=u.groups.delete_if  {|g| g.dynamic }
    u.save
    
    # OK, on initialise la session
    InitialiserLaSessionPour(u)

    uri=root_url
    if params[:uri] and !params[:uri].empty?
      uri=params[:uri]
    end
    
    # Le navigateur redirigera vers la racine
    respond_to do |format|
      format.html {
        render text: uri
      }
    end
  end
  

  def remove_entity
    User.current.remove_entity(params[:entity]) 
    User.current.save
    respond_to do |format|
      format.js { render :js => ""}
    end
  end

  
  def changeuser
    u = User.find(params[:id])
    if @connectedUser.admin? || @connectedUser.manager?
      session[:userid]=u.id
      User.current=u
    end
    redirect_to  :root
      
  end

  def self.current_user_id
   User.current.id if User.current != nil
    -1
  end

  def self.current_user
    User.current
  end

  def logout

    logoutUser

    if session[:cas]
      reset_session
      CASClient::Frameworks::Rails::Filter.logout(self,url_for( controller: "main", action: "accueil"))
      return true
    end


    
    reset_session
    redirect_to  :root
  end

  def self.verifyOldSessions
    # Toutes les date sont en utc, utilisons donc UTC_TIMESTAMP
    # Si pas de mise a jour de la session dans la derniere heure
    # On supprime la session
    ActiveRecord::Base.connection.delete("DELETE FROM sessions WHERE updated_at < UTC_TIMESTAMP() - 3600")
  end

end