# -*- coding: utf-8 -*-
class UsersController < ApplicationController

  before_filter :require_manager , :only => [:manage,:add]
  before_filter :check_user_manager  , :only => [:save,:usersavailable,:groupsavailable,:edit,:groups,:users]
  before_filter :mesfiltres , :only => [:edit,:add]

 # Mime::Type.register "image/png", :png

  include   ApplicationHelper



  # Vérifie si l'utilisateur actuel à le droit de "manager"
  # le user_id passé en paramètre
  def check_user_manager
    @user=User.find(params[:id])
    if ! @user.managed?
      unauthorized
      return  false
    end
  end

  def avatars
    @filtre=Filtre.createEmptyOne
    respond_to do |format|
      format.html  { render :layout=>"avatars"}
    end
  end

  def profile_get
    @user=User.current
    respond_to do |format|
      format.js
    end

  end

  def profile_set

    User.current.avatar=params[:avatar] if params[:avatar]

    if !(User.current.cas? && Appconfig.CAS_CHECK_UPDATE_CONNECTION)
      User.current.nom= params[:nom] if params[:nom]
      User.current.prenom= params[:prenom] if params[:prenom]
      User.current.mail= params[:mail] if params[:mail]
    end

    @plus=""

    # Gestion du mot de passe
    p1= params[:password1]
    p2= params[:password2]
    msg=""
    if p1  and p2 and !p1.empty?  and !p2.empty?
      if p1 != p2
        flash.now[:error]="Les mots de passe ne correspondent pas"
        flasher
        return false
      else
        User.current.password=p1
        @plus=" et votre mot de passe modifié."
      end
    end

    User.current.portable= params[:portable] if params[:portable]

    User.current.profile.set(Profile::ONGLET_CONTENT,params[:onglet_content])

    User.current.profile.save
    User.current.save

    respond_to do |format|
      format.js
    end
  end

  # Affichage de la page principale
  def manage
    set_menu menu: "gestion", rubrique: "users"
    respond_to do |format|
      format.html {render :layout=>false}
    end  
  end

  # Ajout d'un Utilisateur / Groupe
  def add
    lid=User.last.id + 1
    if params[:type]=="group"
      u=Group.create(:nom => "Groupe #{lid}", :prenom => "", :uid => "@groupe#{lid}" )
      @user=Group.find(u.id)
    else
      @user=User.create(:nom => "Nom", :prenom => "Prénom #{lid}", :uid => "user#{lid}" )
    end

    respond_to do |format|
      format.js { render :action => "edit" ,:id=> @user.id}
    end


  end
  
  def save
    @user.nom=params[:user][:nom]
    @user.prenom=params[:user][:prenom]
    @user.uid=params[:user][:uid]
    @user.dynamic=params[:user][:dynamic]
    @user.share=params[:user][:share]
    @user.zephir_uid=params[:user][:zephir_uid]
    @user.mail= params[:user][:mail]

    p1= params[:user][:password]
    p2= params[:user][:password2]

    # Gestion du mot de passe
    msg=""
    if p1  and p2
      if p1 != p2
        flash.now[:error]="Les mots de passe ne correspondent pas"
        flasher
        return false
      else
        msg="<br>Le mot de passe a été modifié"
        @user.password=p1
      end
    end

    # Gestion du filtre
    f=Filtre.find_by_id(params[:filters][:filtre])
    if f != nil && f.readable?
      @user.filtre=f
    elsif params[:filters][:filtre]=="-1"
      @user.filtre=nil
    else
      @user.filtre_id= params[:filters][:filtre]
    end

    if @user.save
      respond_to do |format|
        format.js {
          flash.now[:notice]="Les paramètres de <i>#{format_user_without_icon @user}</i> ont été modifiés."
          flasher
        }
      end
    else
      respond_to do |format|
        format.js {
          flash.now[:error]="Erreur: #{@user.errors.full_messages.first}"
          flasher
        }
      end
    end
  end

  # Via Post : sauvegarde des utilisateurs
  def users
    users=  params[:users]
    group=Group.find(params[:id])
    guest=   (params[:guest] == "true") || (params[:guest] == "1") ? true : false
    usersAvailable= User.find_all_by_user_id(User.current.id)

    group.users.clear
    if users != nil  && !guest
      users.each do |uid|
        u=User.find_by_id(uid)
        group.users << u  if usersAvailable.include? u
      end
    end

    if guest
      group.users.clear
      group.groups.clear
      group.groups << Group.guest
    else
      group.groups.delete  Group.guest
    end

    group.save
    respond_to do |format|
      format.js {
        flash[:notice]="Utilisateurs modifiés pour #{@user.uid}"
        render partial: "shared/flash" ,  :locals => { :flash => flash }
      }
    end

  end

  # Via Post : sauvegarde des groupes
  def groups
    groups= params[:groups]
    groupsAvailable=@user.groupsAvailable # Groupes posibles pour User.current

    @user.groups.clear
    @user.groups << Group.all
    groups.each do |gid|
      g=Group.find_by_id(gid)
      @user.groups << g if groupsAvailable.include? g
    end

    @user.save
  
    respond_to do |format|
      format.js {
        flash[:notice]="Groupes modifiés pour #{@user.uid} "
        render partial: "shared/flash" ,  :locals => { :flash => flash }
      }
    end   
  end
  
  def edit
    respond_to do |format|
      format.js 
    end   
  end

  # Tous les utilisateurs dont User.current est le créateur
  def usersavailable
    #group=Group.find(params[:id])
    #users=User.find_all_by_user_id(User.current.id,conditions: UsersController._conditions(params[:search]),limit: 50)
    #users.delete_if {|u| (group.users.include? u) || u.group? || u==nil}

    #render_json users
    render_json UsersController._search params[:search]
  end

  def usersforgroup
    group=Group.find(params[:id])
    render_json group.users

  end

  # Liste des groupes disponibles
  def groupsavailable

    # Tous les groupes possiblent pour User.current
    groups=@user.groupsAvailable.select {|x| (! @user.groups.include? x ) && !x.all? && !x.nobody?  }

    # Si il y a un paramètre de recherche , on enleve les groupe qui ne matchent pas
    if params[:search]!=nil && !params[:search].empty?
      a= params[:search].downcase
      groups.delete_if {|x| !x.match(a) }
    end

    render_json groups
  end

  # Liste des groupes pour user=:id
  def groupsforuser
    @user=User.find(params[:id])
    groups=@user.groups.delete_if {|x| x.all? }

    render_json groups
  end

  # ================== Gestion des options get/set =======================
  def setoption
    key=params[:key]
    value=params[:value]

    User.current.profile.reload.setAndUpdate(key,value)

    Objet.clearPermissionsCacheForUser(User.current) if key==Profile::SHOW_SHARED

    respond_to do |format|
      format.js { render js:"" }
    end
  end
  
  def getoption
    key=params[:key]
    respond_to do |format|
      format.js { render js:User.current.profile.get(key) }
    end  
  end
  # ====================================================================
  

  
  # Liste des users pour jqgrid  (Liste principale à gauche)
  # Cette liste contient les groupes et les utilisateurs
  def list

    logMe "list:start"
    f= params[:search] if params[:search]
    f="*" if params[:search]==nil || params[:search].empty?

    logMe "_search"
    users=UsersController._search(f)

    logMe "delete_if"
    users.delete_if {|g| g.special?}

    logMe "sort!"
    users.sort! { |a,b| a.categorie <=> b.categorie }

    logMe "render"
    render_json users

    logMe "list:end"
  end
  
  # Liste des users pour autocomplete
  def search
     arr=UsersController._search params[:term]
     a=[]
     arr.each do |user|
        a<< {label: "<small>#{user.nom} #{user.prenom}</small><right><b>[#{user.uid}]</b></right>", value: user.uid}
     end
     
     respond_to do |format|
        format.json { render json: a.to_json }
      end  
  end
  

private

  def render_json(objets)
    list = objets.map do |u|
      u.for_json
    end
    list = { :page => "1", :total => 1, :records => list.count , :rows => list }
    respond_to do |format|
      format.json { render json: list.to_json }
    end
  end

  def self._conditions(search=nil)

    searchterm= search if search
    searchterm="*" if search==nil || search.empty?

    #logMe "_conditions:start"
    #arrIds=[User.current.id]
    #User.current.groups.each do |g|
    #  arrIds<<g.id
    #end

    term="%"+searchterm  +"%"
    if searchterm != "*"
      return ["(uid like ? or nom like ? or prenom like ?) and (guest=0) and (uid not like ?)",
       term,term,term,"#{UserSimple::INVITE_PREFIX}%"]
    else
      return ["guest = 0 and uid not like ?","#{UserSimple::INVITE_PREFIX}%"]
    end


  end

  def self._search(searchterm)
    # Recherche les users dont le nom ressemble à params[:term]
    # Return: [ { label:"label1", value: "id1"  },...,{ label:"labelN", value: "idN"  }]
    
      # On récupère tous les users (non guest) qui correspondent au critère

      results=UserSimple.all(conditions: UsersController._conditions(searchterm),order: 'categorie')


      arr=[]

      bAdmin=User.current.admin?


      # Pour tous les groupes de l'utilisateur,
      # On ajoute les autres utilisateurs qui en font partie également
      if ! bAdmin
        User.current.groups.each do |g|
          next if g.special? #&& ! bAdmin # Groupe spécial et non admin, on ne l'ajoute pas
          next if ! g.share?
          arr<<g   if  g.uid =~ /#{searchterm}/i or  g.nom =~ /#{searchterm}/i
          g.users.each do |u|
            arr<<u if results.include? u
          end
        end
        arr << Group.nobody
        #User.current.groups.select {|v| ! v.special?  }
        #User.current.groups.each do |g|
        #  next if ! g.share?
        #  arr<<g
        #end
      else
         arr=results
      end

      arr.uniq!{|x| x.id}

      arr.sort! { |a,b| ApplicationController.helpers.format_user_without_icon(a) <=> ApplicationController.helpers.format_user_without_icon(b) }
      
      arr
      
    end


end
