# -*- coding: utf-8 -*-
module ApplicationHelper

  require 'extend_string'
  @@cacheUserFormat={}
  @@cacheObjetFormat={}

  def grouped_filtres(filtres,bOnlyName=false,bDefault=true,bCas=false)
    if bDefault
      grouped_options={""=>[["Aucun filtrage",-1]]}
    else
      grouped_options={}
    end

    if  bCas && Appconfig.CAS && Appconfig.CAS_ATTRIBUTE_FILTRE_RNE != ""
      grouped_options["Attribut CAS"] = [["Depuis attribut CAS #{Appconfig.CAS_ATTRIBUTE_FILTRE_RNE}",-2]]
    end

    # Groupe les filtres par 'groupe'
    filtres.group_by(&:groupe).map do |k,v|
      next if k==nil
      # Format chacun des filtres
      arr=v.each.collect {|f| [f.nom,f.id]}

      if k.is_a? Integer
        v=Vue.find_by_id(k)
        next if v!=nil && ( !v.readable?)
        if v!=nil
          k=v.nom.gsub(" ","_").gsub("'","-")
        else
          k="--"
        end
      end

      grouped_options[(k =~ /[a-z]$/)?(k.pluralize):k]=arr
    end
    grouped_options
  end

  def grouped_perspective(perspectives,bOnlyName=false)
    grouped_options={};grouped_options["Tableaux_de_bord"]=[]
    perspectives.group_by(&:contexte).map do |k,v|
      arr=v.each.collect {|f| [format_objet(f,false,bOnlyName),f.id]}
      grouped_options["Tableaux_de_bord"].concat(arr)
    end
    grouped_options
  end

  #def grouped_perspective(perspectives,bOnlyName=false)
  #  grouped_options={};grouped_options["Tableaux_de_bord"]=[]
  #  perspectives.delete_if{|p| p.contexte!=Perspective::CONTEXTUEL}.group_by(&:contexte).map do |k,v|
  #    arr=v.each.collect {|f| [f.nom,f.id]}
  #    grouped_options["Tableaux_de_bord"].concat(arr)
  #  end
  #  grouped_options
  #end

  def help(page)
    "<div class='onlinehelp'><a href='assets/guide/co/#{page}.html' target='_help'>Besoin d'aide ? </a></div>"
  end

  def helpsmall(page)
    "<a href='assets/guide/co/#{page}.html' class='helpicone' target='_help' tiltle='Aide'><span></span></a>"
  end


  def format_objet(objet,bOnlyIcon=false,bOnlyName=false)
    return "---" if objet==nil
    #key="#{bOnlyIcon}-#{bOnlyName}"
    #r=Objet.cacheGetObjectFormat(objet.id,key)
    #if r==nil
      r=format_objet2(objet,bOnlyIcon,bOnlyName)
    #  Objet.cacheSetObjectFormat(objet.id,key,r)
    #end
    r

    #if @@cacheObjetFormat.include?(key)
    #  puts " >>>>> GET Object #{key} from CACHE <<<<<"
    #  r = "CACHED:"+@@cacheObjetFormat[key]
    #else
    #  puts " >>>>> ENTRY CACHE FOR Object #{key}  <<<<<"
    #  r=format_objet2(objet,bOnlyIcon,bOnlyName)
    #  @@cacheObjetFormat[key] = r
    #end

    #r
  end

  # ATTENTION: Dans le formattage d'un objet le span doit TOUJOURS se trouver
  # après le nom
  def format_objet2 (objet,bOnlyIcon=false,bOnlyName=false)
    return "---" if objet==nil

    return "#{objet.uiDisplay}" if bOnlyName

    r="&nbsp;"
    r="#{objet.uiDisplay}"  if !bOnlyIcon

    if !objet.filtreVue? && !objet.rapport?
      r=r<< "<div style='float:right; margin-left:10px;display:inline-block' title='#{format_user_without_icon(objet.owner)}'>[#{format_user_icon(objet.owner)}]</div>"
    end

    #if (true || !objet.owner?) && !objet.filtreVue? && !objet.rapport?
    #  r=r<< "<div style='float:right; margin-left:10px;display:inline-block' title='#{format_user_without_icon(objet.owner)}'>[#{format_user_icon(objet.owner)}]</div>"
    #else
    #  if (objet.owner? || objet.writable?) && !objet.rights.empty? && !objet.filtreVue?
    #    r=r<< "<div style='float:right; margin-right: -20px;display:inline-block' title='Objet partagé'><img src='/assets/picto/share.png' width='16px' height='16px'/></div>"
    #  else
    #    r=r<< "<div style='float:right; width:20px; margin-left:10px;display:inline-block'>&nbsp;</div>"
    #  end
    #end

    r
  end

  def format_seveur(task)
     status=task.currentStatus
     "<span class='server #{status[:ui]}' title='#{status[:title]}'></span>"
  end

  def format_composante(composante,uid=nil,showServeur=false,showPermissions=false)
    return "---" if composante == nil

    r="#{composante.name}"
    if showServeur
      s="#{composante.serveur.tag}"
      s="#{s} (#{uid})" if uid!=nil
      r="<div style='white-space: pre-wrap;font-size:0.8em; width:30%; display:inline-block;'><b>#{s}</b></div> #{r}"
    end

    v=Value.getValue(uid,composante)

    if composante.serveur? &&uid==nil
      r="#{format_seveur(composante.serveurTask)} #{r}"
    elsif composante.isLeaf? or uid==nil
      e="error" if v!=nil && v.is_a?(Value) && v.etat==Value::KO
      r="<span class='composante #{composante.categorie} #{e}' title='#{composante.fullname}'></span> #{r}"
    elsif composante.isFolder?  && uid!=nil
      type=(composante.serveur?)?"SERVER":"#{Composante::FOLDER}"


      if v!=nil  && v.is_a?(Value) && v.nberreurs!=0
        r="<span class='composante #{type} error' title='#{composante.fullname}'></span> #{r} <div class='errors' title='#{v.nberreurs} erreur(s)'>#{v.nberreurs}</div>"
      else
        r="<span class='composante #{type}' title='#{composante.fullname}'></span> #{r}"
      end
    end


    if ! composante.permissions.empty? && showPermissions
      r="#{r} <span class='permissions #{(composante.inherite_perm? && !composante.permissions.empty?)?"inherited":""}' title='permissions'></span> "
    end



    r

  end


  def format_conf(conf)

    r="#{conf.value}"

    case conf.categorie

      when "texte" then
        r="<input name='conf[#{conf.key}]' id='#{conf.key}' type='text' value='#{conf.value}'/>"

      when "password" then
        r="<input name='conf[#{conf.key}]' id='#{conf.key}' type='password' value='#{conf.value}'/>"

      when "url" then
        r="<input name='conf[#{conf.key}]' id='#{conf.key}' type='text' value='#{conf.value}'/>"

      when "booleen" then
        checked=(Value.to_bool(conf.value))?"checked":""
        r="<input name='conf[#{conf.key}]' id='#{conf.key}' type='checkbox' class='checkbox' #{checked}/>"

    end



  end

  def sort_users (users,removeSpecial=true,addAll=false)
    if removeSpecial
      users=users.delete_if {|x| x.special}
    end
    if addAll
      users<< Group.all
    end
    if !users.include? User.connected
      users<<  User.connected
    end
    users.sort! { |a,b| format_user(a) <=> format_user(b) }

  end

  def group_users (users)
    #users.group_by(&:categorie).map {|k,v| { k => v.each.collect {|f| [format_user(f),f.id] }}}
    grouped_options={}
    users.group_by(&:categorie).map do |k,v|
      arr=v.each.collect {|f| [format_user(f,true),f.id]}
      grouped_options[format_user_categorie(k).pluralize]=arr
    end
    grouped_options

  end

  def format_profile_attribute(user,attr)
    if User.current.cas? && Appconfig.CAS_CHECK_UPDATE_CONNECTION
      return user[attr.to_sym]
    else
      return "<input id='profile_#{attr.to_s}' value='#{user[attr.to_sym]}'>"
    end
  end

  def  format_user_without_icon (user)
    "#{user.nom.upcase} #{user.prenom}"
  end

  def  format_user_icon (user)
    "<div class='avatar small' style='background-image:url(#{user.avatar_url})'></div>"
  end

  def format_user_id(id)

    if @@cacheUserFormat.include? id
      r=@@cacheUserFormat[id]
    else
      user=User.find(id)
      return "??" if user==nil
      classe=""  if ! user.group?
      classe="group" if  user.group?
      classe<<" guest" if  user.guest?

      r="#{format_user_icon(user)} #{format_user_without_icon(user)}"
      @@cacheUserFormat[id]=r
    end
    r
  end

  def format_user(user,identifyCurrent=false)

    classe=""  if ! user.group?
    classe="moi"  if user== User.connected && identifyCurrent
    classe="group" if  user.group?
    classe<<" guest" if  user.guest?

    "#{format_user_icon(user)} #{format_user_without_icon(user)}"

    #"<span class='user #{classe}'>#{format_user_without_icon(user)}</span>"
  end

  def format_user_categorie(cat)
    r="??"
    case cat
      when User::USER    then r="Utilisateur"
      when User::GROUP   then r="Groupe"
    end
    r
  end


  def format_droit(droit)

    r="??"
    case droit
      when Permission::DENY   then r="Interdit"
      when Permission::READ   then r="Voir"
      when Permission::MODIFY then r="Modification"
      when Permission::WRITE  then r="Gestion"
      when Permission::DELETE then r="Suppression"
    end
    r
  end

  def format_categorie(categorie)
    case categorie
      when Composante::TEXTE     then r="Chaîne de caractères"
      when Composante::BOOLEEN   then r="Booléen"
      when Composante::NUMERIC   then r="Numérique"
      when Composante::RATEbps   then r="Débit(bps)"
      when Composante::STATUT    then r="Statut"
      when Composante::PASSWORD  then r="Mot de passe"
      when Composante::UPTIME    then r="Uptime"
      when Composante::CAPACITYDISK then r="Capacité disque"
      when Composante::PING then r="Ping"
    end
    r
  end

  def format_contexte(c)
    case c
      when Perspective::ENTITE       then r="Détaillé"
      when Perspective::CONTEXTUEL   then r="Lateral"
      when Perspective::ONGLET       then r="Onglet"
    end
    r
  end

  def format_serveur_modele(m)
    m
  end

  def format_serveur_tunit(unit)
    r="--"
    case unit
      when Serveur::MINUTE   then r="minute"
      when Serveur::HOUR   then r="heure"
      when Serveur::DAY then r="jour"
    end
    r
  end


  def main_navigation
    html = ""
    html << "<b>mmm</b>"
  end

end
