module ComposantesHelper

  include ActionView::Helpers::NumberHelper

  def disable_field
    ",'disabled' => 'true'" if @composante.isWritable?
  end

  def format_statut(valeur,fullinfos)
    "<div class='composante value #{Value.to_bool(valeur)}' title='#{valeur}'>&nbsp;</div>"
  end
  
  def format_rate(value,fullinfos)
    number_to_human(value.attr(:rate),  :precision => 4 , :units => :bps, :separator => "." ,:delimiter => "'")
  end
  
  def format_uptime(value,fullinfos)
    "#{value.attr(:date)}"
  end
  
  def format_paswword(value,fullinfos)
    dateTime = Time.new
    id= dateTime.to_time.to_i+rand(1000) 
    r="<div id='#{id}' class='composante  password hidden' value='#{value.valeur}'>#{value.valeur}</div>"
    r<<"<script>registerPassword('##{id}')</script>" 
    r
  end

  def format_ping(value,fullinfos,tag)
   # id=rand(36**size).to_s(36)
    r="<ping  tag='#{tag}' min='#{value.attr(:min)}' max='#{value.attr(:max)}' avg='#{value.attr(:avg)}' lost='#{value.attr(:lost)}' samples='#{value.attr(:samples).join(" ")}'></ping>"
    r
  end
  
  def format_capacitydisk(value,fullinfos)
    dateTime = Time.new
    id= dateTime.to_time.to_i+rand(1000)
    #"<div id='yy'>&nbsp;</div>"
    r="<div id='#{id}' style='display:inline;'></div>"
    r<<"<script>gauge.add(document.getElementById('#{id}'),"
    r<<" {colors:['#66ff66','#ff0000'],width:130, height: 25, gradient: true,limit:true , values:[#{value.attr(:used)},#{value.attr(:capacity)}]})</script>"
    
    if fullinfos
      r<<"&nbsp;<div style='width:30px;vertical-align:top; display:inline-block;'>#{value.attr(:percent)}%</div> #{value.attr(:format)}&nbsp; #{value.attr(:used)}/#{value.attr(:capacity)}Mo "
      
    end
    r
  end


  def format_composante_valeur (categorie,value,fullinfos=false,tag='')


    case categorie

      when Composante::STATUT        then return format_statut(value.valeur,fullinfos)
      when Composante::CAPACITYDISK  then return format_capacitydisk(value,fullinfos)
      when Composante::RATEbps       then return format_rate(value,fullinfos)
      when Composante::UPTIME        then return format_uptime(value,fullinfos)
      when Composante::PASSWORD      then return format_paswword(value,fullinfos)
      when Composante::PING          then return format_ping(value,fullinfos,tag)

    end

    "#{value.valeur}"

  end

end
