class Action < ActiveRecord::Base
  
  attr_accessible :actif, :arguments
  attr_accessible :laststart, :lastduration, :laststatus, :current , :percent
  
  belongs_to :script
  
  
  
  def launch(server,uid=nil,masteruid=nil,maxseconds=60)

      
      output={:resultat => "---",:arguments => "---"}
   
      require 'timeout'
      output = Timeout::timeout(maxseconds) {
        script.execute arguments, server , uid,masteruid
      }
      output

  end
  
  def icone
    script.icone  
  end
  
  
  def to_s
    "#{script.nom}" 
  end
  
  
  def to_json
    { :id=>id, :cell => [ script.uiDisplay,  arguments,actif==true ]   }
  end
  
end