# -*- coding: utf-8 -*-
class Appconfig < ActiveRecord::Base

  attr_accessible :key , :value , :categorie, :desc , :groupe, :ssgroupe

  validates_uniqueness_of :key

                          # Généralités
  GEN_ALLOW_GUEST={key: :GEN_ALLOW_GUEST, categorie: "booleen",ssgroupe:"Mode invité",  value:"false",desc: "Autoriser l'accès en mode Invité" }
  GEN_GUEST_FILTER={key: :GEN_GUEST_FILTER,categorie: "filtre" , ssgroupe:"Mode invité", value:"",desc: "Filtre par défaut pour le mode Invité" }

  GEN_BASE_URL={key: :GEN_BASE_URL,ssgroupe:"",
                                           categorie: "url",  value:"",desc: "Url de base du serveur (Ex: https://sentinelle.ac-reunion.fr)" }

  GEN_AVATAR_EXTERNE={key: :GEN_AVATAR_EXTERNE, ssgroupe:"Avatar",  value:"",desc: "URL distante pour afficher les avatars" }
  GEN_AVATAR_EXTERNE_MODIF={key: :GEN_AVATAR_EXTERNE_MODIF, ssgroupe:"Avatar",  value:"",desc: "URL distante pour gérer les avatars" }

  GPS_LON_REF={key: :GPS_LON_REF, ssgroupe:"Positionnement GPS", value:"",desc: "Longitude de référence", value: "0" }
  GPS_LAT_REF={key: :GPS_LAT_REF, ssgroupe:"Positionnement GPS", value:"",desc: "Latitute de référence" , value: "0" }

  ENTITIES_TO_REFRESH={key: :ENTITIES_TO_REFRESH, ssgroupe:"", value:"",desc: "" , value: "" }



  # Zephir
  ZEPHIR={key: :ZEPHIR, categorie: "booleen", value: "true", desc: "Utiliser zephir pour la récupération des droits/groupes"}
  ZEPHIR_HOST={key: :ZEPHIR_HOST, desc: "Host zephir (Ex: zephir.ac-reunion.fr [ sans le https ]"}
  ZEPHIR_API_PORT={key: :ZEPHIR_API_PORT, desc: "Port d'accès à l'API", value: "7080" }
  ZEPHIR_LOGIN={key: :ZEPHIR_LOGIN, desc: "Login d'accès en lecture à zephir" }
  ZEPHIR_PASSWORD={key: :ZEPHIR_PASSWORD, categorie: "password", desc: "Mot de passe associé au compte en lecture" }

  # Kiwi
  KIWI={key: :KIWI, categorie: "booleen", value: "false", desc: "Utiliser l'irc Kiwi"}
  KIWI_URL={key: :KIWI_URL, desc: "Url de kiwi"}
  KIWI_CHANNEL={key: :KIWI_CHANNEL, desc: "Channel Sentinelle", value: "#sentinelle" }
  KIWI_CHANNEL_KEY={key: :KIWI_CHANNEL_KEY, desc: "Key du channel Sentinelle", value: "" }

  # Authentification CAS
  CAS={key: :CAS, categorie: "booleen", value: "false", desc: "Utiliser une authentification CAS"}
  CAS_URL={key: :CAS_URL, desc: "Url du serveur CAS (Ex: https://cas.serveur.com:port)"}
  CAS_URL_PASSWORD={key: :CAS_URL_PASSWORD, desc: "URL de gestion du mot de passe (laisser vide si aucun)"}
  CAS_ATTRIBUTE_GROUPE={key: :CAS_ATTRIBUTE_GROUPE,
                        desc: "Attributs CAS permettant de désigner les groupes (séparés par une , )"}

  # CAS => On The Fly
  CAS_USER_ONTHEFLY={key: :CAS_USER_ONTHEFLY, categorie: "booleen",ssgroupe:"Création à la voléé", value: "false",
                     desc: "Créer des utilisateurs à la volée"}

  CAS_CHECK_UPDATE_CONNECTION={key: :CAS_CHECK_UPDATE_CONNECTION, categorie: "booleen",ssgroupe:"Création à la voléé", value: "false",
      desc: "Mettre à jour les attributs à chaque connexion"}

  CAS_ATTRIBUTE_NAME={key: :CAS_ATTRIBUTE_NAME,ssgroupe:"Création à la voléé",
                                desc: "Attribut CAS décrivant le <b>nom</b> de l'utilisateur"}
  CAS_ATTRIBUTE_FIRSTNAME={key: :CAS_ATTRIBUTE_FIRSTNAME,ssgroupe:"Création à la voléé",
                      desc: "Attribut CAS décrivant le <b>prénom</b> de l'utilisateur"}
  CAS_ATTRIBUTE_MAIL={key: :CAS_ATTRIBUTE_MAIL,ssgroupe:"Création à la voléé",
                      desc: "Attribut CAS décrivant le <b>mail</b> de l'utilisateur"}
  CAS_ATTRIBUTE_MANDATORY_NAME={key: :CAS_ATTRIBUTE_MANDATORY_NAME,ssgroupe:"Création à la voléé",
                        desc: "Attribut CAS obligatoire pour la création d'un compte"}
  CAS_ATTRIBUTE_MANDATORY_VALUE={key: :CAS_ATTRIBUTE_MANDATORY_VALUE, ssgroupe:"Création à la voléé",
                        desc: "Valeur de l'attribut CAS obligatoire pour la création d'un compte"}
  CAS_ATTRIBUTE_FILTRE_RNE={key: :CAS_ATTRIBUTE_FILTRE_RNE, ssgroupe:"Création à la voléé",value: "",
                            desc: "Attribut CAS pouvant être utilisé pour le filtrage des établissements"}

  MAIL_FROM={key: :MAIL_FROM,ssgroupe: "Mail",value: "sentinelle-noreply@ac-academie.fr" ,
             desc: "Adresse mail avec laquelle les mails de Sentinelle seront envoyés"}

  MAIL_SMTP_HOST={key: :MAIL_SMTP_HOST,ssgroupe: "Mail",
            desc: "SMTP sortant",value: "smtp.ac-academie.fr"}

  MAIL_SMTP_PORT={key: :MAIL_SMTP_PORT,ssgroupe: "Mail",
      desc: "Port du SMTP sortant",value: "25"}

  MAIL_SMTP_TLS={key: :MAIL_SMTP_TLS, categorie: "booleen",ssgroupe:"Mail sécurisé", value: "false",
      desc: "Activer le support de TLS"}

  MAIL_SMTP_USER={key: :MAIL_SMTP_USER,ssgroupe: "Mail sécurisé",desc: "Utilisateur",value: ""}
  MAIL_SMTP_PWD={key: :MAIL_SMTP_PWD, categorie: "password",ssgroupe: "Mail sécurisé",desc: "Mot de passe",value: ""}
  MAIL_SMTP_AUTH={key: :MAIL_SMTP_AUTH,ssgroupe: "Mail sécurisé",
                  categorie: "enum:plain|login|cram_md5",
                  desc: "Mode d'authentification",value: "plain"}


  BATCH_DIR={key: :BATCH_DIR,ssgroupe: "Batch",
      value:"/home/sentinelle/alizes-local/batches",
      desc: "Repertoire de batch"}

  # Expert
  #EXPERT_MAX_THREAD={key: :EXPERT_MAX_THREAD , ssgroupe:"Tâche", value: "10",
  #                   desc: "Nombre maximal de thread pour une tâche"}

  GROUPES=[
          {
              name: "Générale",
              params: [GEN_BASE_URL,GEN_ALLOW_GUEST,GEN_GUEST_FILTER,GPS_LON_REF,GPS_LAT_REF,ENTITIES_TO_REFRESH,
                       GEN_AVATAR_EXTERNE,GEN_AVATAR_EXTERNE_MODIF]
          }  ,


          { name: "Authentification CAS",
            params: [CAS,CAS_URL,CAS_URL_PASSWORD,CAS_ATTRIBUTE_GROUPE,
                     CAS_USER_ONTHEFLY, CAS_ATTRIBUTE_NAME,CAS_ATTRIBUTE_FIRSTNAME,CAS_ATTRIBUTE_MAIL,
                     CAS_CHECK_UPDATE_CONNECTION,CAS_ATTRIBUTE_FILTRE_RNE,
                     CAS_ATTRIBUTE_MANDATORY_NAME,CAS_ATTRIBUTE_MANDATORY_VALUE]
          } , 
          
          { name: "Zephir",
            params: [ZEPHIR,ZEPHIR_HOST,ZEPHIR_API_PORT,ZEPHIR_LOGIN,ZEPHIR_PASSWORD]
          } ,

          {
              name: "Notifications",
              params: [MAIL_FROM,MAIL_SMTP_HOST,MAIL_SMTP_PORT,
                       MAIL_SMTP_TLS,MAIL_SMTP_USER,MAIL_SMTP_PWD,MAIL_SMTP_AUTH]
          },
          {
              name: "Kiwi (IRC)",
              params: [KIWI,KIWI_URL,KIWI_CHANNEL,KIWI_CHANNEL_KEY]
          } ,
          {
              name: "Avancé",
              params: [BATCH_DIR]
          }  ,
          

  ]


  before_save  do
    return false if User.current==nil
    User.current.admin?(false)
  end

  def self.createMethods

    return false if ! User.A

    puts "° Chargement de la configuration"

    GROUPES.each do |g|
      g[:params].each do |conf|
        #puts "#{conf}"
        key=conf[:key].to_s
        o=Appconfig.get(key)
        #puts "#{key}=#{o}"
        if o == nil
          v=""
          v=conf[:value] if conf.has_key?(:value)
          #puts "Création de #{key}"
          conf=Appconfig.new(conf)
          conf.value=v
          conf.groupe=g[:name]
          if ! conf.save
            puts " -> ECHEC, #{User.current.uid} n'est sans doute pas un administrateur"
            return false
          end
        else
          object=Appconfig.find_by_key(conf[:key])
          conf[:ssgroupe]="" if !conf[:ssgroupe]
          object.update_attributes(ssgroupe: conf[:ssgroupe],desc: conf[:desc], groupe: g[:name] )
          object.save
        end
      end
    end

    Appconfig.all(conditions: ["id != 0"]).each do |conf|
      self.class.send(:define_method, conf.key) do
        Appconfig.get(conf.key.to_sym)
      end

      self.class.send(:define_method, "#{conf.key}=") do  |value|
        Appconfig.set(conf.key.to_sym,value)
      end

    end



  end

  def self.getUrl(*o)
    ""
  end

  def self.initialisation

    ActiveRecord::Base.logger = ::Logger.new(nil)

    # Le compte admin existe déja, on ne fait rien
    if User.A
      puts "Appconfig.initialisation: User admin existe déja, rien a faire"
      return false
    end

    # On s'assure qu'ils n'y a aucun groupe/menu
    Group.destroy_all
    Menu.destroy_all
    User.destroy_all

    Group.create(:nom => "", :prenom => "Administrateurs", :uid =>  Group::ADMIN)
    User.current= Group.admin

    Group.create(:nom => "", :prenom => "Tout le monde", :uid => Group::ALL, :special =>true )
    Group.create(:nom => "", :prenom => "Positionnement GPS", :uid => Group::GPS, :special =>true)

    # Création du compte Administrateur
    puts "° Création du compte admin, avec le mot de passe par défaut #{User::ADMIN_DEFAULT_PASSWORD}"
    administrateur=User.create(:nom => "", :prenom => "Administrateur", :uid => User::ADMIN ,:password=> User::ADMIN_DEFAULT_PASSWORD)
    administrateur.password=User::ADMIN_DEFAULT_PASSWORD
    administrateur.groups << Group.admin
    administrateur.groups << Group.gps
    administrateur.save

    User.current=administrateur

    # Création des groupes
    puts "° Création des groupes"
    Group.create(:nom => "", :prenom => "Personne", :uid =>  Group::NOBODY, :special =>true)
    Group.create(:nom => "", :prenom => "Manager", :uid =>  Group::MANAGER, :special =>true)
    Group.create(:nom => "", :prenom => "Invité", :uid => Group::GUEST, :special =>true)
    Group.create(:nom => "", :prenom => "Utilisateur CAS", :uid => Group::CAS_USER, :special =>true , :dynamic => true)


    puts "° Création des menus"
    accueil=Menu.create(tag: "accueil",  nom: "Accueil")
    accueil.users << Group.guest # invité (non connectes)
    accueil.users << Group.all   # Tous les connectés
    accueil.save

    # Gestion
    gestion=Menu.create(tag: "gestion",  nom: "Gérer" )
    gestion.users << Group.manager
    gestion.users << Group.admin
    gestion.save


    gestion.rubriques << Rubrique.create(tag: "configuration", url: "/administration/configuration", nom: "Configuration", famille: "Administration")
    gestion.rubriques<< Rubrique.create(tag: "users", url: "/users/manage", nom: "Gérer les utilisateurs", famille: "Administration")
    gestion.rubriques<< Rubrique.create(tag: "composantes", url: "/composantes", nom: "Créer / Modifier les composantes", famille: "Gestion des Composantes")
    gestion.rubriques<< Rubrique.create(tag: "scripts", url: "/administration/scripts", nom: "Gérer les scripts", famille: "Gestion des Composantes")
    gestion.rubriques<< Rubrique.create(tag: "importations", url: "/importation/index", nom: "Peupler (Importation csv)", famille: "Gestion des Composantes")
    gestion.rubriques<< Rubrique.create(tag: "batches", url: "/batches", nom: "Batches", famille: "Gestion des Composantes")

    # Rapports
    rapports=Menu.create(tag: "rapports",  url: "/rapports/index", nom: "Rapports")
    rapports.users << Group.all
    rapports.save

    r=Rubrique.create(tag: "create",  url: "/rapports/create", nom: "Créer un rapport")
    r.save
    rapports.rubriques<< r

    r=Rubrique.create(tag: "manage",  url: "/rapports/manage", nom: "Gérer les rapports")
    r.save
    rapports.rubriques<< r


    puts "° Création des composantes "
    # Maitre
    infoetabs = Master.createMaster('Informations Etablissements')
    infoetabs.permission(Group.admin,Permission::WRITE)
    infoetabs.permission(Group.all,Permission::READ)
    infoetabs.save

    ident =  Composante.create(:tag => 'identite', :name => 'Identité',:parent_id => infoetabs.id, :categorie => Composante::FOLDER)
    Composante.create(:tag => 'uaj', :name => 'UAJ',:parent_id => ident.id, :flaguid => true)
    Composante.create(:tag => 'libelle', :name => 'libelle',:parent_id => ident.id)
    Composante.create(:tag => 'type', :name => 'Type',:parent_id => ident.id)
    Composante.create(:tag => 'adresse', :name => 'Adresse',:parent_id => ident.id)
    Composante.create(:tag => 'ville', :name => 'Ville',:parent_id => ident.id)
    Composante.create(:tag => 'cp', :name => 'Code postal',:parent_id => ident.id)
    Composante.create(:tag => 'tel', :name => 'Téléphone',:parent_id => ident.id)
    Composante.create(:tag => 'fax', :name => 'Fax',:parent_id => ident.id)
    Composante.create(:tag => 'remarques', :name => 'Remarques',:parent_id => ident.id)
    Composante.create(:tag => 'responsable', :name => 'Responsable',:parent_id => ident.id)
    Composante.create(:tag => 'mail', :name => 'Mail',:parent_id => ident.id)
    ident.permission(Group.admin,Permission::WRITE)
    ident.permission(Group.all,Permission::READ)
    ident.save

    # Coordonnées GPS
    gps =  Composante.create(:tag => 'gps', :name => 'Coordonnées GPS',:parent_id => infoetabs.id, :categorie => Composante::FOLDER)
    Composante.create(:tag => 'lon_precis', :name => 'Longitude (Précise)',:parent_id => gps.id)
    Composante.create(:tag => 'lat_precis', :name => 'Latitude (Précise)',:parent_id => gps.id)
    Composante.create(:tag => 'lon_approx', :name => 'Longitude  (Approximative)',:parent_id => gps.id)
    Composante.create(:tag => 'lat_approx', :name => 'Latitude  (Approximative)',:parent_id => gps.id)
    gps.permission(Group.find_by_uid("@gps"),Permission::MODIFY)
    gps.permission(Group.all,Permission::READ)
    gps.save


    gAll=Group.all

    # Création des rapports  ===============================================
    puts "° Création des rapports "
    rapport=Rapport.new
    rapport.nom="Coordonnées GPS"
    rapport.description="Coordonnées GPS des établissements"
    rapport.addColumn(Master.composanteKey.tag)
    rapport.addColumn("libelle")
    rapport.addColumn("lon_precis")
    rapport.addColumn("lat_precis")
    rapport.addRight(gAll,Permission::READ)
    rapport.save

    rapport=Rapport.new
    rapport.nom="Etablissements"
    rapport.description="Liste des établissements"
    rapport.addColumn(Master.composanteKey.tag)
    rapport.addColumn("libelle")
    rapport.addColumn("type")
    rapport.addColumn("adresse")
    rapport.addColumn("cp")
    rapport.addColumn("ville")
    rapport.addColumn("tel")
    rapport.addRight(gAll,Permission::READ)
    rapport.save

    # Création de filtres/vues  ===============================================

    puts "° Création de la vue : Type d'établissements"

    vue=Vue.create
    vue.nom= "Type d'établissements"
    filtre=Filtre.create
    filtre.nom= "Collèges"
    filtre.expression='"{infosetabs.type}" == "CLG"'
    filtre.pictogramme="MapMarker/MapMarker_Marker_Outside_Azure.png"
    vue.filtres << filtre
    gAll.profile.filtres << filtre
    administrateur.profile.filtres << filtre

    filtre=Filtre.create
    filtre.nom= "Lycées"
    filtre.expression='"{infosetabs.type}" == "LYC"'
    filtre.pictogramme="MapMarker/MapMarker_Marker_Outside_Pink.png"
    vue.filtres << filtre
    gAll.profile.filtres << filtre
    administrateur.profile.filtres << filtre

    filtre=Filtre.create
    filtre.nom= "Lycées Pro"
    filtre.expression='"{infosetabs.type}" == "LP"'
    filtre.pictogramme="MapMarker/MapMarker_Marker_Outside_Chartreuse.png"
    vue.filtres << filtre
    gAll.profile.filtres << filtre
    administrateur.profile.filtres << filtre

    gAll.profile.vues_active=[vue.id] ; gAll.profile.save
    administrateur.profile.vues_active=[vue.id] ;
    administrateur.profile.save

    vue.addRight(gAll,Permission::READ)

    vue.save!
    # ===========================================================================

    # Ajout de tableau de bord par défaut
    perspective=Perspective.new
    perspective.contexte=Perspective::CONTEXTUEL
    perspective.tag="defaultInfosEtabsLateral"
    perspective.nom="Informations Etablissements"
    perspective.description="Fiche d'itentité d'un établissement"
    perspective.data=File.read("data/importations/objets/t2b_defaultInfosEtabsLateral.txt")
    perspective.addRight(gAll,Permission::READ)
    perspective.save

    gAll.profile.affecterUneperspectiveParDefaut(perspective)
    administrateur.profile.affecterUneperspectiveParDefaut(perspective)

    perspective=Perspective.new
    perspective.contexte=Perspective::ENTITE
    perspective.tag="defaultInfosEtabsDetaille"
    perspective.nom="Informations Etablissements"
    perspective.description="Fiche d'itentité d'un établissement"
    perspective.data=File.read("data/importations/objets/t2b_defaultInfosEtabsDetaille.txt")
    perspective.addRight(gAll,Permission::READ)
    perspective.save
    gAll.profile.affecterUneperspectiveParDefaut(perspective)
    administrateur.profile.affecterUneperspectiveParDefaut(perspective)

    administrateur.profile.save
    gAll.profile.save

    administrateur.profile.save




    puts "-> Initialisation terminée"

    ""
  end

  def self.initZephir

    ActiveRecord::Base.logger = ::Logger.new(nil)

    if ! User.A
       puts "Il manque sans doute l'initialisation de Sentinelle !!!"
      return false
    end

    zephir=Composante.find_by_fullname("ZEPHIR.ZEPHIR")
    if zephir
      puts "L'initialisation a déja été effectuée pour zephir"
      puts "Si vous souhaitez modifier les paramètres de connexion, "
      puts "veuillez utiliser l'interface web en mode administrateur"
      return false
    end



    resp=Importations::csv("data/.zephir","±")
    if  resp.error? || !zephir
      puts ""
      puts "Veuillez renseigner vos paramètres de connexion à Zephir"

      bConnect=false
      while ! bConnect  do
        h = [(print 'Host Zephir (rien pour annuler): '), gets.rstrip][1]
        if h.strip.empty?
          puts "Abandon de la procédure Zephir"
          return
        end
        l = [(print 'Login: '), gets.rstrip][1]
        p = [(print 'Mot de passe: '), gets.rstrip][1]

        l.strip!
        p.strip!

        require 'open-uri'
        require 'openssl'
        puts "Vérification de l'accès a Zephir "

        begin
            open "https://#{h}:7080", :read_timeout => 15, :ssl_verify_mode =>  OpenSSL::SSL::VERIFY_NONE, :http_basic_authentication => [l, p] do |io|
              io.read
            end
            bConnect=true
        rescue  Exception => ex
            if ex.message=="500 Internal Server Error"
              bConnect=true
            else
              puts "Echec de la connexion à Zephir https://#{h}:7080"
              puts ex.message
              puts ""
            end
        end
      end

      # ZEPHIR =================================================
      zephir=Master.createServeur("ZEPHIR","Serveur ZEPHIR")
      Composante.create(:tag => 'site', :name => 'Site',:parent_id => zephir.id,:flaguid => true)
      Composante.create(:tag => 'host', :name => 'Adresse IP',:parent_id => zephir.id)
      Composante.create(:tag => 'login', :name => 'Identifiant zephir',:parent_id => zephir.id)
      Composante.create(:tag => 'password', :name => 'Mot de passe',:parent_id => zephir.id,:categorie=>Composante::PASSWORD)
      zephir.permission(Group.admin,Permission::WRITE)
      zephir.permission(Group.all,Permission::DENY)
      zephir.save

      Value.setComposanteValue(uid: "APPCONFIG",composante: Composante.find_by_fullname("ZEPHIR.host"),valeur: h, source: "")
      Value.setComposanteValue(uid: "APPCONFIG",composante: Composante.find_by_fullname("ZEPHIR.login"),valeur: l, source: "")
      Value.setComposanteValue(uid: "APPCONFIG",composante: Composante.find_by_fullname("ZEPHIR.password"),valeur: p, source: "")
    else
      h=Value.getValueFromFullname("APPCONFIG","ZEPHIR.host").valeur
      l=Value.getValueFromFullname("APPCONFIG","ZEPHIR.login").valeur
      p=Value.getValueFromFullname("APPCONFIG","ZEPHIR.password").valeur
    end

    Appconfig.createMethods()
    Appconfig.ZEPHIR="true"
    Appconfig.ZEPHIR_HOST=h
    Appconfig.ZEPHIR_LOGIN=l
    Appconfig.ZEPHIR_PASSWORD=p

    include Importations

    infoetabs=Master.serveur



    puts "° Création des scripts de récupération des données sur Zephir"
    # Script permettant de récupérer les infos établissements depuis Zephir
    script=Importations::script("data/zephir/RecupServeursFromZephir.py",
                                "RecupEtabsFromZephir.py",
                                "Récupération des informations d'établissement depuis zephir",false,[infoetabs])
    infoetabs.serveurTask.update_attributes({:commande => "#{script.id}",:tfrequence=>5,:tunit=>Serveur::MINUTE } )
    script.serveurs=[infoetabs.id]
    script.save
    infoetabs.save

    #Script de récupération de toutes les configurations/agents sur Zephir
    script=Importations::script("data/zephir/ServerConf.py",
                                "Serveurs.py",
                                "Récupération des informations des serveurs sur zephir",false)
    zephir.serveurTask.update_attributes(:commande=>"#{script.id}",:tfrequence=>3,:tunit=>Serveur::MINUTE )
    script.serveurs=[zephir.id]
    script.save
    zephir.save

    # Script qui va récupérer la configuration/agents pour un serveur
    zephir_measure_script=Importations::script("data/zephir/zephirmeasure.py",
                                               "zephirmeasure.py",
                                               "Récupération des états individuels des serveurs. Ces états devront être préalablement récupérés via Serveurs.py\nParamètre: <identifiant zephir>",true,[zephir])




    # Les utilisateurs ayant le droit d'enregistrement sur Zephir
    zenreg=Group.create(:nom => "Zephir", :prenom => "Enregistrement", :uid => "@ZENREGISTREMENT", :dynamic => true )
    zread=Group.create(:nom => "Zephir", :prenom => "Lecture", :uid => "@ZREAD", :dynamic => true )

    puts "° Création des modules Eole"

    # AMON ======================================================
    amon=Importations::CreateModuleEole("AMON",zephir_measure_script,5)

    # HORUS =================================================
    horus=Importations::CreateModuleEole("HORUS",zephir_measure_script,11)

    # SCRIBE ====================================================
    scribe=Importations::CreateModuleEole("SCRIBE",zephir_measure_script,7)

    capacities=Composante.find_all_by_categorie("CAPACITYDISK")
    capacities.each do |composante|
      composante.error_condition="{:percent} > 80"
      composante.error_message="Le pourcentage d'occupation de la partition <b>{:name}</b> est > à 80%, il reste {:available}Mo de disponible"
      composante.save
    end

    puts "° Création des tableaux de bord Eole"

    gAll=Group.all
    administrateur=User.A

    # Ajout de tableau de bord par défaut
    perspective=Perspective.new
    perspective.contexte=Perspective::CONTEXTUEL
    perspective.tag="defaultEoleInfosEtabsLateral"
    perspective.nom="Modules Eole"
    perspective.description="Informations sur les modules Eole"
    perspective.data=File.read("data/importations/objets/t2b_InfosEtabsLateral.txt")
    perspective.save
    gAll.profile.affecterUneperspectiveParDefaut(perspective)
    administrateur.profile.affecterUneperspectiveParDefaut(perspective)

    perspective=Perspective.new
    perspective.contexte=Perspective::ENTITE
    perspective.tag="defaultEoleInfosEtabsDetaille"
    perspective.nom="Infrastructures Eole"
    perspective.description=""
    perspective.data=File.read("data/importations/objets/t2b_InfosEtabsDetaille_v2.txt")
    perspective.save
    gAll.profile.affecterUneperspectiveParDefaut(perspective)
    administrateur.profile.affecterUneperspectiveParDefaut(perspective)

    gAll.profile.save
    administrateur.profile.save

    puts "-> Initialisation zephir terminée"
    return true

  end

  def self.getEtabsFromZephir

    ActiveRecord::Base.logger = ::Logger.new(nil)

    if ! User.A
      puts "Il manque sans doute l'initialisation de Sentinelle !!!"
      return false
    end

    infoetabs=Master.serveur
    zephir=Composante.find_by_fullname("ZEPHIR.ZEPHIR")




    if ! zephir
      puts " -> Zephir n'est pas encore initialisé"
      return
    end

    puts "° récupération des établissements depuis Zephir"
    infoetabs.serveurTask.execute       # Récupération des établissements et identifiant des serveurs
    zephir.serveurTask.execute          # Récupération des états des serveurs

    include Entities
    puts "Nombre d'établissements récupérés : #{Entities.getAll.count}"

  end


  def self.initEole

    ActiveRecord::Base.logger = ::Logger.new(nil)

    # Le compte admin existe déja, on ne fait rien
    if  ! User.A
      puts "Appconfig.initEole: User admin inexistant"
      return false
    end

    puts "° récupération des modules Eole"

    trap("SIGINT") { throw :ctrl_c }

    catch :ctrl_c do
      begin
        puts "AMON"
        eole=Composante.find_by_fullname("AMON.AMON")
        eole.serveurTask.execute if eole
      rescue Exception
        puts "Abandon"
      end
    end

    catch :ctrl_c do
      begin
        puts "HORUS"
        eole=Composante.find_by_fullname("HORUS.HORUS")
        eole.serveurTask.execute if eole
      rescue Exception
        puts "Abandon"
      end
    end

    catch :ctrl_c do
      begin
        puts "SCRIBE"
        eole=Composante.find_by_fullname("SCRIBE.SCRIBE")
        eole.serveurTask.execute if eole
      rescue Exception
        puts "Abandon"
      end
    end


   puts "========================================================="



    administrateur=User.A

    v=Vue.find_by_nom("Erreurs Eole")
    if v == nil
      puts "Création de la vue : Erreurs Eole"

      vue=Vue.create
      vue.nom= "Erreurs Eole"

      filtresactifs=[]

      filtre=Filtre.create
      filtre.nom= "AMON"
      filtre.expression='{AMON:nberreurs}.to_i > 0'
      filtre.pictogramme="symboles/warning_red.png"
      vue.filtres<<filtre
      filtresactifs<<filtre

      filtre=Filtre.create
      filtre.nom= "HORUS"
      filtre.expression='{HORUS:nberreurs}.to_i > 0'
      filtre.pictogramme="symboles/warning.png"
      vue.filtres<<filtre
      filtresactifs<<filtre

      filtre=Filtre.create
      filtre.nom= "SCRIBE"
      filtre.expression='{SCRIBE:nberreurs}.to_i > 0'
      filtre.pictogramme="symboles/warning_blue.png"
      vue.filtres<<filtre
      filtresactifs<<filtre

      filtre=Filtre.create
      filtre.nom= "OK"
      filtre.expression=''               # si vide, est utilisé par dépit (ie: aucun filtre précédent ne matche)
      filtre.pictogramme="led/GREEN.png"
      vue.filtres << filtre
      filtresactifs<<filtre

      vue.save!
      # ===========================================================================

      administrateur.profile.filtres = filtresactifs
      administrateur.profile.vues_active=[vue.id]
      administrateur.profile.save
    end

  end



  def self.init
    GROUPES.each do |g|
      #puts g
      Appconfig.creategroupe(g)
    end
  end

  def self.creategroupe(g)
      return if !User.current.admin?
      g[:params].each do |p|
        #puts "=>#{p}"
        conf=Appconfig.new(p)
        conf.groupe=g[:name]
        conf.save
      end
  end

  def self.get(key)
    conf=Appconfig.find_by_key(key)
    return nil if conf==nil

    return "n/a" if conf.password? and User.current!=nil and ! User.current.admin?

    v= conf.value
    if conf.booleen?
      v=Value.to_bool(v)
    end
    v
  end

  def self.set(key,value)
    conf=Appconfig.find_by_key(key)
    return if conf==nil
    conf.update_attributes({:value => value})
  end

  def self.setEntityToRefresh(uid)
    r=Appconfig.ENTITIES_TO_REFRESH
    a=r.split("|")
    a<<uid
    a.uniq!
    Appconfig.ENTITIES_TO_REFRESH=a.join("|")
  end

  def self.getEntitiesToRefresh
    Appconfig.ENTITIES_TO_REFRESH.split("|")
  end

  def self.clearEntitiesToRefresh
    Appconfig.ENTITIES_TO_REFRESH=""
  end

  def booleen?
    categorie=="booleen"
  end

  def password?
    categorie=="password"
  end

  def enum?
    categorie =~ /^enum:.*/
  end

  def enum
     return [] if ! enum?
     return categorie.gsub("enum:","").split("|")
  end

end
