class Batch  < Objet

  include Rapports
  require 'timeout'

  FILTRE_PREFIX="_batch_"


  def initialize(*params)
    super(*params)
    self.categorie=BATCH
    self.data=BatchData.new if self.data==nil
    self.tag=params[0][:tag]
    @arr=[]
  end

  # === CURRENTS
  def self.currents
    batches=(Batch.all(:conditions => ["categorie = ?",BATCH],:order=> [:tag]))
    batches.select { |x| !x.hidden?}
  end

  def setEntities(arr)
    @arr=arr
  end

  def getComposanteTag
    "batch_#{tag}"
  end

  def getComposante
    Composante.getComposanteFromFullname(Master::TAG+"."+getComposanteTag)
  end

  def clear
    filtres=Filtre.all_by_tag(FILTRE_PREFIX+"#{id}")
    filtres.each { |f| f.destroy}
    Value.find_all_by_composante_id(getComposante.id).each {  |v| v.destroy }
  end

  def columns
    columns=[]
    c=RapportColumn.new
    c.nom="#{Master.composanteKey.name}";c.format="{#{Master.composanteKey.fullname}}";columns<<c

    c=RapportColumn.new
    c.nom="#{Master::LIBELLE.name}";c.format="{#{Master::LIBELLE.fullname}}";columns<<c


    if data.colonnes
      data.colonnes.each do |colonne|
        c=RapportColumn.new
        c.nom=colonne[:libelle]
        c.format=colonne[:format]
        columns<<c
      end
    end


    c=RapportColumn.new
    c.nom="Etat";
    c.format="ret=''\n"

    data.statut.each  do |key, value|
      c.format<< "ret='<div style=\"width:80px;text-align:center; padding:3px;color:white;background-color:#{value[:couleur]}\">#{value[:message]}</div>'   if #{value[:filtre]}\n"
    end
    c.format<<"ret"
    columns<<c

    c=RapportColumn.new
    c.nom="Icone";
    c.format="ret=''\n"

    data.statut.each  do |key, value|
      c.format<< "ret='<div class=\"icone\" style=\"width:80px;text-align:center; padding:3px;background-image:url(/assets/#{value[:icone]})\"></div>'   if #{value[:filtre]}\n"
    end
    c.format<<"ret"



    columns<<c


    columns
  end

  def filtre
    Filtre.find_by_id(data.filtreid)
  end

  def json

    total=0
    filtre=Filtre.find_by_id(data.filtreid)
    if filtre
      total=filtre.evaluation.content.count
    end

    count=total
    infos={}
    data.statut.each  do |key, value|
      f=Filtre.find_by_id(value[:filtreid])
      next if ! f
      c=f.evaluation.content.count
      total=total- c
      infos[key]={count: c  ,couleur: value[:couleur], message: value[:message]}
    end

    { :id=> id, :description => "<b>#{nom}<b><br>#{description}",
      :status => data.etat, :message => data.message, :percent => data.percent,:count => count,:unknown => total ,
      :infos => infos}
  end

  def calculerLesFiltres

    data.statut.each  do |key, value|
      next if ! value[:filtre]

      tag="#{FILTRE_PREFIX}#{id}_#{key}"
      filtre=Filtre.find_by_tag(tag)
      if !filtre
        filtre=Filtre.create(nom:"#{Filtre::FILTRE_TEMPORAIRE_PREFIX}")
        filtre.expression=value[:filtre]  + getFiltreIfExist
        filtre.tag=tag
        filtre.save
        if filtre.data.error?
          puts "Erreur lors de la compilation du filtre #{value[:filtre]}"
          return  false
        end
      else
        filtre.expression=value[:filtre] + getFiltreIfExist
        filtre.needToBeCompiled
      end
      value[:filtreid]=filtre.id
      filtre.save


    end
    return true
  end




  def parcourir


    #trap("SIGINT") { throw :ctrl_c }

    #catch :ctrl_c do
    #  begin

    #Signal.trap("SIGINT") do
    #  puts "Terminating..."
    #  stop
    #end

        start

        count=@arr.count
        index=0
        @arr.each do |entity|

          reload
          break if ! running?

          setCurrent(entity)

          data.setPercent((index*100/count))
          save

          bOk=false
          begin
            Timeout::timeout(120) do
              yield entity
            end
              bOk=true
          rescue

          end

          index=index+1

          r=entity.getResult()
          if !r && bOk
            entity.setResult( "OK" )
          end

        end


        stop

     # rescue Exception
     #   puts "Ctrl+C detected"
     #   data.message="Break"
     #   save
     #   stop
     # end


    #end


  end

  def start
    data.start
    save
  end

  def stop
    data.stop
    save
  end

  def break
    data.break
    save
  end


  def hidden?
    data.hidden!=nil &&  data.hidden==true
  end

  def pending
    data.etat =  BatchData::PENDING
    data.message="---"
    save
  end

  def running?
    return data.etat ==  BatchData::RUNNING
  end

  def pending?
    return data.etat ==  BatchData::PENDING
  end

  def setMessage(message)
    puts message
    data.message=message
    save
  end

  def getFiltreIfExist
    return "" if data.filtre==nil || data.filtre.empty?
    " and (#{data.filtre})"
  end



  # Tous les étabs ou la composante batch_<tag> n'exsiste pas
  def self.nonRealise
    batch=Batch.createOrGetOne
    self.filtrer("#{Batch.composante} == '#{Value::NOTEXIST}' #{batch.getFiltreIfExist}")
  end

  # Tous les établissements
  def self.tous
    batch=Batch.createOrGetOne
    self.filtrer(batch.data.filtre,true)

  end

  # Que les établissements du tableau en paramètres
  def self.seuleument(arr)

    arr.shift
    filtre=arr.map { |a| "{#{Master.composanteKey.fullname}} == '#{a}'"}.join(" or ")
    self.filtrer(filtre)

  end



  def self.createOrGetOne
    # recherche du batch
    batch=Batch.find_by_tag(Batch.current)
    if !batch  # Non trouvé, on va en creer un
      batch=Batch.new(tag: Batch.current)
    end

    # Recherche de la composante assosciée
    comp=batch.getComposante
    if ! comp

      # Construction du parent si inexistant
      parent=Composante.find_by_fullname("#{Master::TAG}.BATCHES")
      if ! parent
        parent= Composante.create(:tag => "BATCHES", :name => "Batches",:parent_id => Master.serveur.id, :categorie => Composante::FOLDER)
      end

      #Création  de la composante
      comp=Composante.create(:tag => batch.getComposanteTag, :name => batch.tag,:parent_id => parent.id)
    end
    batch
  end

  def self.composante
    batch=Batch.createOrGetOne
    "{"+Master::TAG+"."+batch.getComposanteTag+"}"
  end

  def self.current=(tag)
    Thread.current[:batchtag] = tag.split(".")[0]
  end

  def self.current
    Thread.current[:batchtag]
  end





  def setCurrent(entity)
    data.setCurrent(entity)
  end

  private

      def self.filtrer(exp='true',bAll=false)
        exp='true' if exp==nil

        # Si on récupère tous les établissements , on met a jour le filtre global
        # Permettant de savori le nombre d'établissement concerné par ce batch
        if bAll
          batch=Batch.createOrGetOne
          tag="#{FILTRE_PREFIX}#{batch.id}"
          filtre=Filtre.find_by_tag(tag)
          if !filtre
            filtre=Filtre.create(nom:"#{Filtre::FILTRE_TEMPORAIRE_PREFIX}")
            filtre.expression=exp
            filtre.tag=tag
            filtre.save
          else
            filtre.expression= exp
          end
          filtre.save
          if filtre.data.error?
            puts "    /!\\ ATTENTION /!\\"
            puts "Le filtre est  invalide #{filtre.expression}"
            puts " ================================================"
            return nil
          end

          batch.data.filtreid=filtre.id
          batch.save
        else
          filtre=Filtre.new
          filtre.nom="#{Filtre::FILTRE_TEMPORAIRE_PREFIX}"
          filtre.expression=exp
        end

        print "° Récupération des établissments : "

        Entities.computeFilter2(filtre)


        if filtre.data.error?
          puts "    /!\\ ATTENTION /!\\"
          puts "Le filtre est  invalide #{exp}"
          puts " ================================================"
          return nil
        end



        arr=[]
        Entities.getCurrents.sort{|a,b| a<=>b }.each do |entity|
          next if ! filtre.evaluer(entity)
          e=Entities.get(entity)
          arr<<e if e!=nil
        end

        puts "#{arr.count} trouvé(s)"

        puts "   -> Filtre appliqué : #{exp}"

        batch=Batch.createOrGetOne

        batch.setEntities(arr)

        batch

      end




end