# -*- coding: utf-8 -*-
class Composante < ActiveRecord::Base


   attr_accessible :categorie, :description, :name, :parent_id, :tag, :icon , :flaguid, :error_condition,:error_message,:change_message,:logall
   
   attr_accessible :expert  ,:inherite_perm
   attr_accessible :unit, :legend , :color , :marker , :modele # options par défaut pour un graphique
   attr_protected   :fullname
   acts_as_tree :order => "categorie DESC , id ASC"
  
   has_many :permissions ,  :order => "position ASC"
   has_many :users, :through => :permissions , :dependent => :destroy

   has_and_belongs_to_many :filtres , :join_table => :filtres_composantes

   attr_protected   :serveur_id

   validates :name, :presence => true
   validates :tag, :presence => true

   #validates_format_of :tag, :with => /^([0-9,\/,_,-,A-Z]*)$/i,
   #                    :message => " format invalide, ne peut contenir que des chiffres ou des lettres"



   has_many :values
   belongs_to :user, :class_name => 'UserSimple', :foreign_key => 'user_id' # Créateur de la composante

   after_initialize :default_values

   UID_SEP="-"

   FOLDER="ZFOLDER"

   TEXTE="TEXTE"
   BOOLEEN="BOOLEEN"
   STATUT="STATUT"
   NUMERIC="NUMERIC"
   RATEbps="RATEbps"
   PASSWORD="PASSWORD"
   CAPACITYDISK="CAPACITYDISK"
   UPTIME="UPTIME"
   PING="PING"
   CATEGORIES=[TEXTE,BOOLEEN,STATUT,NUMERIC,PASSWORD,CAPACITYDISK,RATEbps,UPTIME,PING]
   ALL=CATEGORIES
   ALL.append(FOLDER)


   # ==================== FILTERS =========================
   before_destroy do
     #On ne supprime pas la racine
     if id == Composante.root.id
       errors[:base] << "Impossible de supprimer la racine de l'arbre des composantes"
       false
     end

     #L'utilisateur a t'il le droit pour supprimer
     if !isDeletable?
       errors[:base] << "Vous n'avez pas la permission de supprimer cette composante"
       false
     end

   end
   
   after_find do
     #return if ! User.current
     #self.id=-1 if !isReadable?
     
   end

   after_save  do
     self.update_attribute(:serveur_id , self.id )  if  self.serveur_id==nil
   end


   before_create do
      self.user=User.current
      self.error_condition=""
      self.error_message=""
      self.change_message=""

      if self.tag =~ /.*[\.,:, ].*/ && self.categorie!= FOLDER
        errors[:base] << "le tag ne doit pas avoir de . de : et d'espace"
        puts "Erreur de format pour le tag #{self.tag}"
        return false
      end

      self.unit="";self.legend=""; self.color=""; self.modele="line"
      
      case self.categorie
      when RATEbps
        self.unit="bps";self.legend="Débits"; self.color="#00FF00"; self.modele="area"
      when CAPACITYDISK
        self.unit="Mo";self.legend="Capacité utilisée"; self.color="#0000FF" ; self.modele="areaspline"
      when TEXTE
        self.modele="scatter";self.change_message="{:last} => {:valeur}"
      when  UPTIME 
        self.modele="column";self.change_message="";self.color="#FF0000"
        self.error_message="{:time} reboot du serveur";self.error_condition="{:valeur} < {:last}";
      when STATUT
        self.modele="scatter";self.change_message="{:statut}";self.legend="Statut"
        self.error_condition="'{:statut}'=='ECHEC'"; self.error_message="{:name} est en ECHEC"
      end
      
   end

   before_save do
     #L'utilisateur a t'il le droit pour modifier
     if !self.isWritable?
       errors[:base] << "Vous n'avez pas la permission de modifier cette composante"
       return false
     end

     if self.tag =~ /.*[\.,:, ].*/  && self.categorie!= FOLDER
       errors[:base] << "le tag ne doit pas avoir de . de : et d'espace"
       puts "Erreur de format pour le tag #{self.tag}"
       return false
     end

    # Calcul du fullname
     p=self
     root=Composante.root
     while p != nil do
       if p.parent==root
         self.fullname="#{p.tag}.#{self.tag}"
         self.serveur_id=p.id  #Serveur.find_by_tag(p.tag)
       end
       p=p.parent
     end

     #c=Composante.find_by_fullname(self.fullname)
     #if c!=nil
     #  errors[:base] << "Ce tag éxiste déja dans ce serveur"
     #  return false
     #end

     # Categorie par défaut
     self.categorie=TEXTE if self.categorie==nil
     
     # Pris en compte des formats Eole et Sentinelle v2
     upcase=self.categorie.upcase
     self.categorie=BOOLEEN if upcase=="OUI/NON"
     self.categorie=NUMERIC if upcase=="NUMBER"
     self.categorie=STATUT  if upcase=="STATUS"
     self.categorie=RATEbps if upcase=="RATEVALUE"
     self.categorie=NUMERIC if upcase=="BOUNDVALUE"
     self.categorie=CAPACITYDISK if upcase=="CAPACITYDISKVALUE"
     self.categorie=UPTIME if upcase=="UPTIMEVALUE"
     
     self.categorie=TEXTE   if ! ALL.include? self.categorie
     

   end
   
   
   after_save do
     # Changement de condition/message d'erreur
     if self.error_message_changed? || self.error_condition_changed?
        values=Value.all(conditions: [ "composante_id = ?", self.id ])
        values.each do |value|
          value.reEvaluerStatut
          #value.save
        end
       
     end

     if self.fullname==nil
       puts "#{tag} fullname is null"
     end
     
     # On force le recharge de la composante dans le cache
     Composante.getComposanteFromFullname(fullname,true)
     
     true
     
   end
   

   
   after_create do
       if self.serveur?
         serveur=Serveur.find_by_composante_id(self.id)
         if serveur == nil
           serveur=Serveur.new
           serveur.composante=self
           serveur.save
         end
      end
   end

   @serveur=nil

   # ==============================================================


   def fullPath(tag)
     "#{serveur.tag}.#{tag}"
   end

   def serveur
     return @serveur if @serveur!=nil
     return self if serveur_id==Composante.root.id
     return self if serveur_id==nil
     @serveur=Composante.find(serveur_id)
   end

   # Détermine si la composante fait partie du master
   def inMaster?
     serveur.tag==Master::TAG
   end

   def getComposante(tag)
     #Composante.find_by_fullname(serveur.tag+"."+tag)
     #puts("#{serveur.tag} #{tag}")
     Composante.getComposanteFromFullname(serveur.tag+"."+tag)
   end

   def self.getComposanteFromFullname(fullname,reload=false,composanteDeBase=nil)
     if Thread.main[:composantes] == nil
      Thread.main[:composantes]={}   
     end
     
     #puts("Cache:#{Thread.main[:composantes].first.name}")
     if Thread.main[:composantes].has_key?(fullname.to_s)  && !reload
      #puts("Cache:#{Thread.main[:composantes].first.name}")
      c=Thread.main[:composantes][fullname.to_s]
     else
       # Vérification si il y a un attribut
       name=fullname.split(":")[0] # On enlève les attributs

       return nil if name==nil

       # De la forme {:statut} => {composanteDeBase:statut}
       if name.empty? and composanteDeBase != nil
         name=composanteDeBase.fullname
       end

       a=name.split(".")
       # De la forme {AMON} => {AMON.AMON}
       if a.count==1
        name="#{name}.#{name}" # Cas d'un serveur
       end


       
       c=Composante.find_by_fullname(name)
       #puts("Get by_fullname [#{name}][#{fullname}] #{c}")
       Thread.main[:composantes][fullname.to_s] =c #if c!=nil
     end
     c
   end
   
   
  # ======== ELEMENTS GRAPIQUES ===================
  def graphiqueOptions
    type="areaspline"
    type="scatter" if categorie==TEXTE
    type=modele if modele!=nil
    a={nom:name,unit: unit,legend: legend , color: color, type: type}  
    
    if categorie==STATUT
      a[:legend] = "Statut"
      a[:plotband]={from: id-0.5,to: id+0.5, label: {text: name,style: {"font-size"=> "0.8em"} },
                    color: "rgba(200,200,#{id%255},0.2)"}
    end
    a
  end
  
  def TEXTE?
    categorie==TEXTE
  end
  
  def UPTIME?
    categorie==UPTIME  
  end
  
  def STATUT?
    categorie==STATUT
  end
  
  def NUMERIC?
    categorie==NUMERIC
  end
   
   
  
  # ==================== GESTION DES PERMISSIONS =========================
  def inheritedPermissions
    perms=permissions 
    composante=self
    while perms==[] && composante!=nil
      perms=composante.permissions
      break if perms != [] #&& ! composante.inherite_perm?
      composante=composante.parent 
    end

    #if  ( inherite_perm? || (permissions.empty? && parent!=nil ))
    #  ret=parent.getPermission
    #end

    #if permissions.empty?
    #  p=parent.inheritedPermissions
    #  perms.concat(p[:perms])
    #end

    {perms: perms,composante: composante}
  end
  

  def getPermission
    
    p=User.current.getPermissionsCache(self)
    if p != nil
      return p
    end
    
    perms=permissions
    composante=self
    heritage=false
    
    # On parcours l'héritage
    while perms==[] && composante!=nil
      perms=composante.permissions 
      composante=composante.parent 
    end 
    
    ret=nil
    perms.each do |p|
       break if ret!=nil # Stop on a trouvé une permission qui match
       next  if p.user.nobody?   # Personne ne doit être dans ce groupe
       ret=p if p.user.all?
       ret=p if p.user_id==User.current.id 
       ret=p if User.current.groups.exists? p.user
    end

    if ret==nil && ( inherite_perm? || (permissions.empty? && parent!=nil ))
      ret=parent.getPermission
    end
    
    User.current.addPermissionsCache(self,ret)
    
    ret
  end
  
  def owner?
    user!=nil && ( User.current.id==user.id  || User.current.memberOf?(user) )  
  end
 
  def admin?
    User.current.admin?
  end 
  
   def isDeletable?
     return true  if admin? || owner?
     perm=getPermission
     return perm.isDeletable? if perm !=nil
     User.current.admin?
   end

  def isWritable?
    return true if admin? || owner?
    perm=getPermission
    return perm.isWritable? if perm !=nil
    User.current.admin?
  end

   def isReadable?
    return true if owner?
    perm=getPermission
    return true if User.current.admin?
    return perm.isReadable? if perm !=nil

   end

   def isModifiable?(useEdmitMode=true)
     return false if useEdmitMode && !User.current.has(Profile::EDIT_MODE) 
     return true if  admin? || owner?
     perm=getPermission
     return perm.isModifiable? if perm !=nil
     false
   end
   
   def permission(user,droit,position=nil)
    return if user==nil
    perm=Permission.new
    perm.composante=self
    perm.user=user
    perm.droits=droit
    perm.position=position if position
    perm.save
    permissions<<perm
   end
   
   # ==============================================================

   # Retourne la composante servant de clef pour la classe Master
   def composanteKey
     Composante.find_by_serveur_id_and_flaguid(serveur_id,true)
   end

   def composanteKey?
    flaguid==true  
   end

   def refServeurUid?
     return tag.end_with? Master::UIDS_SUFFIX
   end


   def serveur?
     return parent if parent==nil
     parent.id==Composante.root.id
   end
   
   def serveurTask
     Serveur.find_by_composante_id(id)
   end

  def isFolder?
    categorie == FOLDER
  end
  
  def isLeaf?
    categorie != FOLDER
  end

  def getImage()
    if (icon != nil )
      return "/assets/apps/"+icon
    end
    return "/assets/picto/STRINGVALUE.png" if isLeaf?
    return "/assets/picto/serveur.png" if serveur?
    return "/assets/picto/folder.png" if isFolder?
  end

   def set(rne,value,source=nil)
     Value.setValue(ckey: Master.composanteKey, ckeyvalue: rne,composante: self,value: value,source: source)
   end

   def get(rne)
     return Master.get(rne,self.fullname)
   end
  
  def getChildrensId()
    arr=[]
    children.each do |child|
          next if !child.isReadable?  
          arr.concat(child.getChildrensId) if child.isFolder?
          arr<< child.id 
     end
     arr<< id
     arr
  end

  # Détermine si les composantes filles ont des valeurs
  def hasValues(serveur_uid,masteruid)
    childs=children.select { |x| ! x.isFolder? }.map { |x| x.id }
   # puts "#{fullname}/#{childs}"
    return true if childs.empty?

    serveur_uid=masteruid  if serveur_uid==nil

   # puts "#{fullname}/ #{serveur_uid} #{masteruid}"
    alls=Value.all(conditions: ["uid = ? and masteruid = ? and composante_id in (?)" ,
                    serveur_uid ,masteruid, childs  ],limit: 1)
   return !alls.empty? || User.edit_mode
   #return true
  end
  
  def to_json(serveur_uid=nil,showServeur=false,hideLeaf=false,showPermissions=false)

    #puts "~~~~~~~~##############to_json  #{serveur_uid}-#{showServeur}-#{hideLeaf}"

    if serveur_uid!=nil
      s="(#{serveur_uid})" if serveur?
      sid="#{serveur_uid}#{UID_SEP}"  
    end
    
    # Est-ce que cette composante dispose d'enfants qui sont des dossiers ?
    # Si oui on met le state a closed, afin d'afficher une + pour étendre 
    state=(hideLeaf)?"opened":"closed"
    children.each do |c|
      if c.isFolder?
        state="closed" 
        break
      end  
    end
    
    # Format json utilisé par un jstree
    { :data => { :title =>    "#{ApplicationController.helpers.format_composante(self,serveur_uid,showServeur,showPermissions)} #{s}"   },
      :state => isFolder?? state : "opened",   
      :attr =>  {:id => "#{sid}#{id}" , :tag => tag.to_s,:name => ApplicationController.helpers.format_composante(self,serveur_uid),
                 :fullname => fullname.to_s, :format =>  formatter, :nom=> name , :rawid => id,
                 :folder => isFolder?,:serveur_uid => serveur_uid,
                 :modifiable=> isModifiable?,:server => serveur?,:writable=> isWritable?}
    }
  end
  

   def addChridrenToTree(tree)
      return if tree.count > 2000
      children.each do |c|
         tree[c.id]=true
         c.addChridrenToTree(tree) if c.isFolder?
      end
   end

  def buildTree(tree,serveur_uid=nil,hideLeaf=false,showPermissions=false)

    list=to_json(serveur_uid,false,hideLeaf,showPermissions)
    puts "~~~~~~~~##############buildTree  #{children.count} #{hideLeaf}"
    childernsJson=[]
    children.each do |c|
      #puts "~~~~~~~~##############buildTree  #{c.fullname}"
      next if ! tree.has_key?(c.id)
      next if c.isLeaf? &&  hideLeaf
      childernsJson<<c.buildTree(tree,serveur_uid,hideLeaf,showPermissions)
    end
    list[:state]="opened"
    list[:children]=childernsJson
    list
  end
  
  def default
    return ""   if categorie==TEXTE
    return 0 
  end
  
  # Suppression de l'historique pour une composante (mode récursif)
  def delHistoriques
    ValueHistory.destroy_all(["composante_id = ?",id])  
    children.each do |c|
      c.delHistoriques 
    end
  end
  
   # Suppression du journal pour une composante (mode récursif)
  def delJournal
    Log.destroy_all(["composante_id = ?",id])  
    children.each do |c|
      c.delJournal 
    end
  end

  def format(value,fullinfo=false)
    ComposantesController.helpers.format_composante_valeur(categorie,value,fullinfo,fullname)
  end

  def formatter
    return '"{'+fullname+'}"'  #if categorie==TEXTE
  #  return  '{'+fullname+'}'
  end

   def self.root
     Composante.find_by_parent_id(-1)
   end

   def to_s
    "#{fullname} (id:#{id})"
   end
   

   private
   def default_values
     self.flaguid ||= false
   end

end
