class Evaluation < ActiveRecord::Base

  attr_accessible :compiled

  has_one  :filter
  serialize :entities

  def initialize(*params)
    super
    self.entities={}
    @updated=false
  end

  def clear
    self.compiled=false
    self.entities={}
  end

  # Retourne uniquement les entités ou :key=>True et User.current en dispose
  def count
    entities.count{|x| x[1] && User.current.hasEntity?(x[0]) }
  end

  def countVisible
    #puts "#{User.current.visibleEntities}"
    entities.count{|x| x[1] && User.current.visibleEntity?(x[0]) }
  end

  def size
    entities.count{|x| x[1]}
  end

  def compiled?
    compiled
  end
  
  def contains?(uid)
    entities.include?(uid)  
  end

  def remove(uid)
    entities.delete(uid)
  end

  def maj(uid,b)
    return b if entities[uid] == b # Pas de modification, on retourne la valeur
    @updated=true
    entities[uid]=b
  end
  
  def updated?
    @updated  
  end

  # Retourne uniquement les entités ou :key=>True
  def content
    entities.delete_if { |k,v| !v }.map { |k,v| k.upcase }
  end

  def valeur(uid)
    return entities[uid] if entities.include?(uid)
    nil
  end


end