class Filtre  < Objet
  
  include Rapports

  attr_accessible :groupe , :expression , :mode , :position
  
  NORMAL=0
  EXCLUSIF=1

  has_many :profiles
  belongs_to :evaluation

  #has_and_belongs_to_many :composantes  , :join_table => :filtres_composantes

  FILTRE_TEMPORAIRE_PREFIX="%!/.:,;"
  
  def initialize(*params)
      super(*params)
      self.categorie=FILTRE
      self.data=FiltreData.new if self.data==nil 
      self.mode=NORMAL
      self.evaluation=Evaluation.create   if self.nom!=Vue::BEFORE  &&   self.nom!=Vue::AFTER
      self.position=0
  end

  after_find do
    @needToBeCompiled=false
    self.evaluation=Evaluation.create  if self.evaluation == nil
    @active=false
    #self.data.compiled=self.compiled
    #self.data.valid= self.good?
    #self.data.composantes=self.composantes
  end


  before_save do
   # logger.info("===> Filtre before_save => #{self.expression} #{@needToBeCompiled}")
    Icone.destroy_all("uid like '%|#{id}|%'")
    if @needToBeCompiled
      logger.info("===> id=#{id} Filtre Data changed #{nom} => Compute Filter")
      clear
      #Entities.computeFilter(self)
      Entities.computeFilter2(self)
      self.compiled=self.data.compiled
      self.good=self.data.valid? &&  self.data.error.empty?
      #self.composantes=self.data.composantes
      logger.info("===>  Liste des Composantes du filtre id=#{id}  : #{self.data.composantes}")
      self.data.composantes.each do |cid|
        composante=Composante.find_by_id(cid)
        composante.filtres << self if composante!=nil and ! composante.filtres.include? self
      end
      @needToBeCompiled=false
    end

    true
  end

  def needToBeCompiled
    @needToBeCompiled=true
  end

  # === CURRENTS
  def self.currents
    fitres=Objet.filtrer(Filtre.all(:conditions => ["categorie = ? and nom != ?",FILTRE,FILTRE_TEMPORAIRE_PREFIX],:order=> [:nom],:include => [ :evaluation ]))
    fitres.sort_by { |filtre| [filtre.groupe,filtre.nom] }

  end
  
  def self.currentsFiltreVue
    Filtre.all(:conditions => ["categorie = ?",FILTRE_VUE],:order=> :nom,:include => [ :evaluation ])
  end
  
  def self.getAll
    Filtre.all(:conditions => ["categorie = ? or categorie = ?",FILTRE,FILTRE_VUE],:include => [ :evaluation ])
  end

  def filtreVue?
    self.categorie==FILTRE_VUE
  end


  
  def exclusif?
    mode==EXCLUSIF
  end
  
  def pique?
    expression==""
  end
  
  # Composantes utilisées pour le filtre
  # Nécessaire lors de l'affichage du résultat du test
  def composantes=(c)
    @composantes=c
  end
  
  def composantes
    @composantes
  end
  
  def compute(uid,values,bCheckReadable=true)
    b=data.compute(uid,values,bCheckReadable)
    if b==nil
      return nil
    end
    if ! (!!b == b)
      return nil
    end
    #puts "Filtre compute:evaluation"
    evaluation.maj(uid,b)
    b  
  end

  # Vérification de la validité d'un filtre
  # Si invalide on tente de le compiler
  #  => Si la compilation est OK, sauvegarde du filtre
  def checkValidity
    return true if good?
    data.composantes2
    if data.valid?
      @needToBeCompiled=true
      save
      return true
    end
    return false
  end

  # Evaluation d'un filtre
  # Utilisation de la valeur de evaluation si elle existe (Evite de recaluler a chaque fois)
  # Note : evaluation est mise a jour sur un prefiltre de Value::before_save
  # bForce : true => Force le recalcul du filtre
  # bSave  : true => Sauvegarde l'évalutaion
  def evaluer(uid,bForce=false,bSave=true)
    #return nil if data.error?
    return evaluation.valeur(uid) if !bForce && evaluation.contains?(uid)
    if bForce && bSave
      evaluation.reload 
      evaluation.remove(uid)  
    end
    # Verification si c'est bien un FiltreData
    return false if ! self.data.is_a?  FiltreData
    b=self.data.evaluer(uid)
    if b==nil
      return nil
    end
    if ! (!!b == b)
      #puts("EVAL:Evaluation de '#{self.data.expression}' pour #{uid} not bool (#{b})"  )
      return nil
    end 
    evaluation.maj(uid,b)
    evaluation.save if bForce  && bSave
    b
  end

  def clear
    evaluation.clear
    evaluation.save
  end

  def all?
    expression == "true"
  end
    
  def expression=(c)
      self.data=FiltreData.new if self.data==nil
      return if self.data.expression==c
      self.data.expression=c
      @needToBeCompiled=true
  end
  
  def expression
      self.data.expression
  end
  
  def compiled
    data.compiled
  end
  
  def groupe=(c)
    self.data=FiltreData.new if self.data==nil 
    self.data.groupe=c
  end

  def groupe
    self.data.groupe
  end

  def pictogramme=(c)
    self.data.pictogramme=c
  end

  def pictogramme
    self.data.pictogramme
  end

   def uiDisplay
    c="";v=""
    c="<count>#{countVisible}</count>" if !pique? && selected?
    v=" <span class='invalide'>ECHEC</span>" if ! good?
    return "#{nom}<sup title='exclusif'>&nbsp;x</sup> #{c}" if exclusif?
    "#{v} #{nom} #{c}"
   end

  def count
    return evaluation.count  if evaluation
    return -1
  end

  def countVisible
    return evaluation.countVisible  if evaluation
    return -1
  end

  def selected?(hashSelectedFilters=nil)
    #User.current.profile.filtres.include? self
    User.hasSelectedFilter(self,hashSelectedFilters)
  end

  def json(hashSelectedFilters=nil)
    #logger.info("GROUPE:#{data} #{id}")
    selected= selected?(hashSelectedFilters)
    #selected=false
    @active=selected
    #if  User.current.profile.vues_active!=nil && User.current.profile.vues_active.include?(data.groupe.to_i)
    #  @active = true
    #else
    #  @active = selected
    #end
    zid=id
    zid="separator#{nom}#{data.groupe}" if nom==Vue::AFTER || nom==Vue::BEFORE
    { :id=>zid, :cell => [ selected,  ApplicationController.helpers.format_objet(self), data.groupe, writable?(false),pictogramme,@active  ]   }

  end

  def self.createEmptyOne
    filtre = Filtre.new
    filtre.categorie=Filtre::FILTRE_VUE
    filtre.id=-1
    filtre
  end

  def self.etablissements(exp='true')
    filtre=Filtre.new
    filtre.nom="#{FILTRE_TEMPORAIRE_PREFIX}"
    filtre.expression=exp
    puts "° Récupération des établissmeents"

    Entities.computeFilter2(filtre)


    if filtre.data.error?
      puts "filtre invalide"
      return []
    end

    arr=[]
    Entities.getCurrents.sort{|a,b| a<=>b }.each do |entity|
      next if ! filtre.evaluer(entity)
      e=Entities.get(entity)
      arr<<e if e!=nil
    end

    arr
  end
  
  
end