class Handler < ActiveRecord::Base

  attr_accessible :action, :parameters, :uid, :consumed

  serialize  :parameters
  belongs_to :user , :foreign_key => "user_id" ,  :class_name => 'UserSimple'

  before_save do
    self.uid=rand(36**32).to_s(36)   if ! self.uid
    self.user=User.current           if ! self.user
    true
  end

  def self.pending
    Handler.all( :conditions => [ "consumed = false AND created_at > ?",Time.now.since(-120)])
  end

  def commande
    ret=action
    ret << "\n"
    parameters.each do |key,value|
      #ret << "'"
      ret << key
      ret << "='"
      ret << value
      ret << "'"
      #ret << "'"
      ret << "\n"
    end
    ret
  end

end