class Icone < ActiveRecord::Base

  require 'RMagick'
  include Magick

  attr_accessible :uid ,:image




  def self.notification(count)
    img=Image.read("app/assets/images/picto/notif.png")
    i=img.first
    gctext = Draw.new
    gctext.annotate(i, 0,0,0,1, "#{count}") do
      gctext.gravity = CenterGravity
      self.pointsize = 8
      self.font_family = "Arial"
      self.font_weight = BoldWeight
      self.stroke = "none"
    end
    i.to_blob
  end

  def self.createFromFilters(uidicone,filtres)
    ico=Icone.create(:uid => uidicone)
    list = ImageList.new()

    filtres.each do |filtre|
      img=Image.read("app/assets/images/markers/#{filtre.pictogramme}")
      next if img.empty?
      i=img.first
      i.background_color = "none"
      #i=i.colorize(0.95,0.25,0.25,'#cc9933') Test de coloration
      list<<  i
    end
    img=list.flatten_images
    ico.image=img.to_blob
    ico.save
    ico
  end

  def self.hasFolders?(dossier)
    dossier=dossier.gsub("-","/")
    all=Dir.glob("app/assets/images/markers#{dossier}/*")
    all.delete_if { |f| !File.directory?f}
    ! all.empty?
  end

  def self.getFiles(dossier)
    #dossier=dossier.gsub("app/assets/images/markers/","")
    dossier=dossier.gsub("-","/")
    Dir.glob("app/assets/images/markers#{dossier}/*.png")
  end
  
  def self.getFolders(dossier)
    dossier="" if dossier==nil
    dossier=dossier.gsub("-","/")
    all=Dir.glob("app/assets/images/markers/#{dossier}/*")
    all.delete_if { |f| !File.directory?f}
    all.collect { |f| f.gsub("app/assets/images/markers/","").gsub("/","-") }
  end


  def path
    "/main/icone/#{id}"
  end

end