class Master < Composante

  UIDS_SUFFIX="_uids"
  TAG="infosetabs"

  LAT_PRECIS=Composante.getComposanteFromFullname(TAG+"."+"lat_precis")
  LON_PRECIS=Composante.getComposanteFromFullname(TAG+"."+"lon_precis")
  LAT_APPROX=Composante.getComposanteFromFullname(TAG+"."+"lat_approx")
  LON_APPROX=Composante.getComposanteFromFullname(TAG+"."+"lon_approx")
  LIBELLE=Composante.getComposanteFromFullname(TAG+"."+"libelle")

  #@@serveur=Composante.find_by_tag(TAG)
  #@@composanteKey=Composante.find_by_serveur_id_and_flaguid(@@serveur.id,true) 
  @@serveur=nil
  @@composanteKey=nil


  include Rapports



  # Retourne la composante racine de Master
  def self.serveur
    return @@serveur if @@serveur
    @@serveur=find_by_tag(TAG)
  end
 
  # => [ HORUS, AMON, ..]
  def self.allServeurs
    arr=[]
    # Récupère le dossier contenant les uids des serveurs
    # [infosetabs.AMON_uids  , infosetabs.HORUS_uids , .... ]
    folderUid=Composante.find_by_tag_and_parent_id("_uids",Master.serveur.id)
    folderUid.children.each do |c|
      name=c.tag.scan(/(.*)_uid/)[0][0]
      arr<<Composante.find_by_tag_and_parent_id(name,Composante.root.id)
    end
    arr.sort { |a,b| a.id <=> b.id }
  end
  
  def self.allServeursWithMaster
    arr=[Master.serveur]
    arr.concat(Master.allServeurs)
  end
  
  def self.allServeursForEntity(master_uid,hideLeaf=false)
    arr=[]
    Master.allServeurs.each do |serveur|
      next if !serveur.isReadable?
      v=Value.getValue(master_uid,Master.serveur.getComposante("#{serveur.tag}_uids"))  
      next if v==nil
      v.toutesLesValeurs.each do |uid|
        arr<<serveur.to_json(uid,false,hideLeaf)
      end
    end
    arr
  end

  def self.hasGps(uid)
    v=Value.getValue(uid,LAT_PRECIS)
    return true if v!=nil

    v=Value.getValue(uid,LAT_APPROX)
    return true if v!=nil

    return false
  end
  
  def self.getLat(uid)
    v=Value.getValue(uid,LAT_PRECIS)
    return Appconfig.GPS_LAT_REF.to_f + ((Random.rand(1..2)%2==0)?-1:1) * Random.rand(0.8) if v==nil
    v.valeur.to_f
  end
  
  def self.getLon(uid)
    v=Value.getValue(uid,LON_PRECIS)
    return Appconfig.GPS_LON_REF.to_f  + ((Random.rand(1..2)%2==0)?-1:1) * Random.rand(1.3) if v==nil
    v.valeur.to_f
  end

  def self.getLatApprox(uid)
    v=Value.getValue(uid,LAT_APPROX)
    return getLat(uid) if v==nil
    v.valeur.to_f
  end

  def self.getLonApprox(uid)
    v=Value.getValue(uid,LON_APPROX)
    return getLon(uid) if v==nil
    v.valeur.to_f
  end
  
  def self.getLibelle(uid)
    Value.getValeur(uid,LIBELLE)
  end

  # Création du master de l'application'
  def self.createMaster(name)
    root = Composante.root
    if root == nil
      root = Composante.create(:tag => 'root', :name => 'root',:parent_id => -1, :categorie => Composante::FOLDER)
    end

    master=Master.serveur
    if master == nil
      master=Composante.create(:tag => TAG, :name => name,:parent_id => root.id, :categorie => Composante::FOLDER)
      Composante.create(:tag => UIDS_SUFFIX, :name => 'Uids',:parent_id => master.id, :categorie => Composante::FOLDER)
    end

    master
  end


  def self.get(uid,composante)
    valeur=FiltreData.evaluation(uid,"{#{composante}}")
    return nil if   valeur==Value::NOTEXIST
    return valeur
  end

  def self.set(rne,composante,value,source=nil)
    c=Composante.find_by_fullname(composante)
    return false if c==nil
    resp=Value.setValue(ckey: Master.composanteKey, ckeyvalue: rne,composante: c,value: value.to_s,source: source)
    if resp.error?
      puts resp.message
    end
    return !resp.error?
  end


  # Retourne la composante servant de clef pour la classe Master
  def self.composanteKey
    return @@composanteKey if @@composanteKey
    return nil if ! serveur
    @@composanteKey=find_by_serveur_id_and_flaguid(serveur.id,true)
  end

  # Retourne la composante des uids pour une composante
  # Cette information est stockée dans une composante du Master  (<serveurtag>_uids)
  # Ex. : composante= AMON.uptime 
  # return la composante infosetabs.AMON_uids
  def self.serveurUidsForComposante(composante)
    #logger.info("master::serveurUidsForComposante #{composante.fullname}")
    tag=composante.serveur.tag+UIDS_SUFFIX      # Ex: tag=AMON_uids
    cuid=Master.serveur.getComposante(tag)  # On a ici la composante des uids
    cuid
  end

  # Ex. composantekey : infosetabs.AMON_uids
  # return AMON.id (la composante clef de AMON)
  def self.serveurComposanteKeyFromMasterUid(composantekey)
    serveurname=composantekey.tag.gsub(UIDS_SUFFIX,"")
    composante=Composante.find_by_fullname(serveurname+"."+serveurname)
    return nil if  composante==nil
    composante.composanteKey
  end

  def self.uids
    Master.serveur.getComposante(UIDS_SUFFIX)
  end

  def self.createServeur(tag,name)
    c=Composante.create(:tag => tag, :name => name,:parent_id => Composante.root.id, :categorie => Composante::FOLDER)
    if c !=nil
      Composante.create(:tag => tag+UIDS_SUFFIX, :name => "UIDs pour #{name}",:parent_id => Master.uids.id)
    end
    c
  end

end
