class Message < ActiveRecord::Base

  attr_accessible :entity, :nuid, :objet , :message ,  :categorie , :icone ,:expression

  validates :nuid, :uniqueness => {:scope => :user_id}

  belongs_to :user
  belongs_to :notification

  MAIL="MAIL"
  POPUP="POPUP"
  SMS="SMS"
  SYSTEM="SYSTEM"

  INFO="green"
  WARNING="yellow"

  COLUMNS="id,user_id, created_at,notification_id,expression,entity,nuid,objet,message,GROUP_CONCAT(categorie SEPARATOR ',') as categorie"

  def initialize(*params)
    super(*params)

  end

  def system?
    categorie==SYSTEM
  end

  def self.system(user,content,type)
    m=Message.new(:entity => "",
                  :objet  => type,
                  :message=> content,
                  :nuid   => Time.now.to_s,
                  :expression => "",
                  :categorie=> "SYSTEM" )
    m.user=user
    m.notification=nil
    m.save
    m
  end

  def self.fromTime(dstart,dend)
    Message.find_by_sql(sanitize_sql(["SELECT #{COLUMNS} FROM `messages` WHERE (categorie != 'SYSTEM') AND (user_id = ?) AND (created_at>=?) AND (created_at<=?) GROUP BY nuid order by id DESC",
                                    User.current.id,dstart,dend]))
  end

  def self.currents
    Message.find_by_sql(sanitize_sql(["SELECT #{COLUMNS} FROM `messages` WHERE (user_id = ?)  AND (created_at>=?) GROUP BY nuid order by id DESC",
                                      User.current.id,User.current.profile.notification_lastdate]))
  end

  def json

    { :id=>id, :cell => [categorie,
                         I18n.localize(created_at,:format =>:day_month).capitalize,created_at.to_f * 1000,

                         ((system?)?(message):notification.nom),objet,nuid]}
  end

end