# -*- coding: utf-8 -*-
class Notification  < Objet

  include Notifications

  def self.notifiers
    return ["mail","popup","sms","script"]
  end

  before_save do
    # La notification globale n'est pas autorisé pour autres que admin
    self.data.individual=true if ! User.current.admin?
  end

  # Avant de  supprimer on va déférencer
  # dans les profiles la notifcations si elle est présente
  before_destroy do

      users.each do |u|
        notifications=u.profile.notifications
        if notifications.reject! { |x| x==id }
          u.profile.update_attribute(:notifications_active,notifications)
        end
      end

  end


  def initialize(*params)
    super(*params)
    self.categorie=NOTIFICATION
    self.data=Notifications::NotificationData.new
  end


  # === CURRENTS
  def self.currents
    Objet.filtrer(Notification.all(:conditions => ["categorie = ?",NOTIFICATION],:order=> :nom))
  end

  # Expression ====================
  def expression=(c)
    self.data.expression=c
  end

  def expression
    self.data.expression
  end
  # ===============================

  def hasDay? (day)
    self.data.days.include? day.to_s
  end



  def actif?
    self.data.actif
  end

  def individual?
    self.data.individual
  end

  # Tous les users ayant activé la notification
  def users
    if individual?  &&  self.data.getNotifier("mail").get("cc").empty?
      u=User.all.select { |u| u.profile!=nil and u.profile.notifications_active!=nil and u.profile.notifications_active.include? id}
    else
      u=[]
      u=rights.map { |r| r.user} if self.data.getNotifier("mail").get("cc").empty?
      u<<owner if  u.empty?
    end
    u
  end

  def notificationuid
    @notificationuid
  end

  def base_url
    @base_url
  end

  # Vérification de toutes les notifications
  # avec auparavant quelques tâches annexes
  def self.checkAll

    puts "======================================="

    # Suppression des profils non attaché à un user
    usedProfile=UserSimple.all.map  { |u| u.profile_id}
    profiles=Profile.all(:conditions => ["id not in (?)",usedProfile])
    profiles.each do |p|
      p.destroy
    end

    #On purge les comptes guest  de plus d'une heure =====================================
    conditions=["categorie = ? AND guest = 1 AND (lastaction < ? or lastaction is null) AND uid like ?",
                User::USER,Time.now.utc - 1.hour,"#{UserSimple::INVITE_PREFIX}%"]
    users=UserSimple.all(conditions: conditions)
    if users.count>0
      puts "Suppression des #{users.count} users invités #{users.map {|x| [x.id,x.lastaction]}}"
      User.destroy_all(conditions)
    end
    # ====================================================================================

    #On profite pour vérifier si les sessions sont tjs actives
    #afin de notifier les users
    User.checkIfUserIsAlreadyConnected

    User.A

    ActionMailer::Base.smtp_settings = {
        :delivery_method => :smtp,
        :address        => Appconfig.MAIL_SMTP_HOST,
        :port           => Appconfig.MAIL_SMTP_PORT.to_i,
        :tls            => Appconfig.MAIL_SMTP_TLS,
        :enable_starttls_auto => Appconfig.MAIL_SMTP_TLS
    }

    user=Appconfig.MAIL_SMTP_USER
    pwd=Appconfig.MAIL_SMTP_PWD
    if !user.empty? and !pwd.empty?
      ActionMailer::Base.smtp_settings[:user_name]=user
      ActionMailer::Base.smtp_settings[:password]=pwd
      ActionMailer::Base.smtp_settings[:authentication]=Appconfig.MAIL_SMTP_AUTH
    end

    ActionMailer::Base.perform_deliveries = true
    ActionMailer::Base.raise_delivery_errors = true


    # Suppression des anciennes sessions
    #SessionController.verifyOldSessions

    # Vérification des notifications
    Notification.all(:conditions => ["categorie = ?",NOTIFICATION]).each do  |notif|
      puts ""
      puts "[="
      puts notif.nom
      code=notif.check
      puts code.to_s
      puts "=]"
    end

    puts "======================================="

    true
  end

  # Lancement de la vérification de la notification
  def check

    User.A

    return :not_actif if !actif? # Est-ce que la notif est active ?

    time=self.data.now?
    return time if time != :ok   # Est-ce que c'est le moment de la lancer

    # Mise a jour du timestamp du lastCheck
    data.lastCheck=Time.now.utc
    save

    return :no_users if users.empty?  # Aucun utilisateur ne souhaite voir cette notif , on ne fait rien

    # Création d'un filtre factice
    filtre= Filtre.new(:groupe=>"--",:nom=>Vue::BEFORE)
    filtre.expression=expression
    filtre.evaluation=Evaluation.new                 # Auquel on associe d'une Evaluation factice
    Entities.computeFilter2(filtre)                  # filtre.evaluation a été mise a jour

    return :no_entities if  filtre.evaluation.size==0

    @notificationuid=rand(36**32).to_s(36)

    @base_url=Appconfig.GEN_BASE_URL

    # Pour chacun des users on va construire les messages
    users.each do |user|
      User.current=User.find_by_id(user.id)
      data.initMessages(self)

      # Récupération du filtre user s'il existe
      userFilter=Filtre.find_by_id(User.current.notificationsFiltre)

      # Pour chacune des entités
      filtre.evaluation.content.each do |entity|
        next if userFilter!=nil and !userFilter.evaluer(entity)  # Est-ce filtré par le profil de User
        bErb=owner.admin?
        data.buildMessages(entity,bErb)
      end

      # Notification
      data.notify()

    end

    :ok


  end

  def notifier(type)
    data.getNotifier(type)
  end

  def uiDisplay
    v=""
   # v=" <span class='notification individuelle' title='Notification individuelle'>&nbsp;</span>" if individual? && User.current.admin?
    return "<del title='Cette notification a été désactivée par son propriétaire'>#{nom}</del>" if !actif?
    "#{nom}"
  end

  def json()

    # Si notification non indivivuelle actif = statut global
    bActif=actif?
    bActif=User.current.profile.notificationActive?(self) if individual?  # Sinon en fonction du profil utilisateur

    { :id=>id, :cell => [ bActif, ApplicationController.helpers.format_objet(self), "", writable?,(individual?)?"user":"global"  ]   }
  end

end