class Objet < ActiveRecord::Base

  attr_accessible :nom , :description , :data , :categorie, :tag
  attr_accessible :compiled , :good  , :composantes

  @@cacheReadPermissions={}
  @@cacheWritePermissions={}
  @@cacheDeletePermissions={}

  @@cacheObjetFormat={}

  serialize :data

  TAG_FORMAT=/^([_,A-Z,0-9]*)$/i

  RAPPORT="RAPPORT"
  FILTRE="FILTRE"
  FILTRE_VUE="FILTRE_VUE"
  VUE="VUE"
  PERSPECTIVE="PERSPECTIVE"
  SCRIPT="SCRIPT"
  NOTIFICATION="NOTIFICATION"
  BATCH="BATCH"

  has_many   :rights
  belongs_to :user   , :foreign_key => "owner_id" ,  :class_name => 'UserSimple'

  validates_format_of :tag, :with => TAG_FORMAT,:message => " format incorrect" ,:allow_nil => true,:allow_blank=> true
  validates_uniqueness_of :tag, :message => " existant" ,:allow_nil => true,:allow_blank=> true

  before_create do
    self.tag="" if self.tag==nil
    true
  end

  before_save do
    #L'utilisateur a t'il le droit pour modifier
    if !aLeDroitDe Permission::WRITE
      #errors.new[:base] << "Vous n'avez pas la permission de modifier cet objet"
      return false
    end



  end

  before_update do
    if (nom == defaultName  or nom =~ /^~.*~$/)  #and !User.current.admin?
      errors[:base] << "veuillez changer le nom de cet objet"
      return false
    end
  end

  after_save do
    Objet::clearPermissionsCache(self.id)
    Objet::cacheClearObjectFormat(self.id)
  end

  
  before_destroy do

    # L'utilisateur a t'il le droit de supprimer ?
    if ! writable?(false)
      return false
    end

    if filtreVue?
      sql = "DELETE FROM filtres_vues WHERE filtre_id=#{id}"
      logger.info("===== BEFORE DESTROY==== #{sql}")
      ActiveRecord::Base.connection.execute(sql)  
    end


  end

  def self.clearPermissionsCache(id)
    @@cacheReadPermissions.delete(id)
    @@cacheWritePermissions.delete(id)
    @@cacheDeletePermissions.delete(id)
  end

  def self.clearPermissionsCacheForUser(user)
    @@cacheReadPermissions.each { |k,v| v.delete(user.id)}
    @@cacheWritePermissions.each { |k,v| v.delete(user.id)}
    @@cacheDeletePermissions.each { |k,v| v.delete(user.id)}
  end

  def self.cacheSetObjectFormat(id,key,format)
    if ! @@cacheObjetFormat.include?(id)
      @@cacheObjetFormat[id]={}
    end
    @@cacheObjetFormat[id][key]=format
  end

  def self.cacheGetObjectFormat(id,key)
    r=@@cacheObjetFormat[id]
    return nil if r==nil
    r[key]
  end

  def self.cacheClearObjectFormat(id)
    @@cacheObjetFormat.delete(id)
  end

  def initialize(*params)
    super(*params)
    self.owner=User.current
    self.position=0
  end

  def expression
    ""
  end

  def defaultName
    "~"+ApplicationController.helpers.format_user_without_icon(User.current)+" ("+ categorie.downcase +  ") ~"
  end

  def setDefaultName
    update_attribute(:nom,"~"+ApplicationController.helpers.format_user_without_icon(owner)+" ("+ categorie.downcase +  ") ~")
  end

  def linkid
    return tag if tag && !tag.empty?
    return id
  end

  def filtre?
    categorie==FILTRE ||  categorie==FILTRE_VUE
  end
  
  def filtreVue?
    categorie==FILTRE_VUE
  end

  def rapport?
    categorie==RAPPORT
  end

  def perspective?
    categorie==PERSPECTIVE
  end
  
  def script?
    categorie==SCRIPT  
  end

  def batch?
    categorie==BATCH
  end

  def notification?
    categorie==NOTIFICATION
  end

  def addRight(user,droit)

    right=Right.new
    right.user=user ; right.objet=self
    right.droit=Permission::READ
    right.save
    self.rights<<right
    self.save

    #right=Right.new(droit: droit)
    #right.objet=self; right.user=user
    #right.save
    #rights<<right
    #save
  end

  def commun=(params={})
    self.nom=params[:nom]
    self.description=params[:description]
  end

  def self.currents(cat)
    Objet.all(:conditions => ["owner_id = ? AND categorie = ?",User.current.id,cat])
  end

  def writable?(useEdmitMode=true)

    if useEdmitMode && !User.current.has(Profile::EDIT_MODE)
      writable=false
    elsif  User.current.admin?
      writable=true
    else
      writable=able?(@@cacheWritePermissions,Permission::WRITE)
    end

    writable

  end

  def deletable?
    able?(@@cacheDeletePermissions,Permission::DELETE)
  end

  def readable?
    able?(@@cacheReadPermissions,Permission::READ)
  end

  def able?(cache,p)

    #return aLeDroitDe p

    # bypass cache permission
    if ! cache.include? id
      cache[id]={}
    end

    if ! cache[id].include? User.current.id
      r=aLeDroitDe p
      cache[id][User.current.id ]=r
    else
      r=cache[id][User.current.id]
    end
    r
  end

  def aLeDroitDe(droit)
    return true if owner.id==User.current.id || User.current.admin?
    #return true if User.current.groups.exists? owner
    return false if !User.current.has(Profile::SHOW_SHARED)
    rights.each do |r|
      return true if r.droitForCurrentUser?(droit)
    end
    false
  end

  def owner=(o)
    self.user=o
  end

  def owner()
    self.user
  end
  
  def owner?
    user.id==User.current.id
  end

  def self.filtrer(objets)
    objets.delete_if {|o| !o.readable? }
    #logger.info("OBJETS: #{objets}")
    #objets
  end
  
  def ui
    categorie.downcase+"s"
  end
  
  def uiDisplay
    nom
  end
  
  def cast
    Script.find(id) if categorie==SCRIPT
  end

end
