class Permission < ActiveRecord::Base
  
  DENY  = 0 # Accès refuser
  READ  = 10000000 # Voir
  MODIFY= 20000000 # Modifier la valeur
  WRITE = 30000000 # Modifier les attributs
  DELETE= 40000000 # Supprimer
  DROITS=[DENY,READ,MODIFY,WRITE,DELETE]
  
  belongs_to :composante
  belongs_to :user , :class_name => 'UserSimple' #, :join_table => "groups_users" , :association_foreign_key => 'user_id'
  attr_accessible :droits
  attr_accessible :position
  
  default_scope :order => 'position ASC'
  
  attr_accessor :heritage
  
  #L'utilisateur a t'il le droit de modifier
  before_save do
    if !composante.isWritable?
      errors[:base] << "Vous n'avez pas la permission de modifier cette composante"
      false
    end
  end

  # Position par défaut, après la dernière
  before_create do
    perm=composante.permissions.last
    if perm != nil
      self.position=perm.position+1
    else
      self.position=0
    end
  end

  
  def isDeletable?
    droits>=DELETE ||  User.current.admin?
  end

  def isWritable?
    (droits>=WRITE) # || isDeletable?  ) && ! isDeny?
  end
  
  def isModifiable?
    (droits>=MODIFY) 
  end

  def isReadable?
    (droits>=READ )#|| isModifiable?  ) && ! isDeny?
  end

  def isDeny?
    droits==DENY
  end

  def to_json()
      { :id=>id, :cell => [ user.uid,  ApplicationController.helpers.format_droit(droits) ]   }
  end

end
