# -*- coding: utf-8 -*-
class Perspective  < Objet
  
   attr_accessible :contexte
   
   ENTITE=0
   CONTEXTUEL=1   # Attention utilisé dans perspective .js 
   ONGLET=2
   CONTEXTES=[ENTITE,CONTEXTUEL,ONGLET]


   include Rapports
  
   def initialize(attributes = {})
    super
    self.categorie=PERSPECTIVE
    self.nom="Nouveau"
    self.description="Description"

    id="#{User.current.uidtronque}#{rand(36**8).to_s(36)}"

    self.data=<<-eos
      <style>
/* Ajoutez vos styles ici */
##{id} {
   padding:10px;
   margin:10px;
   width:90%;
   border:1px solid gray;
   border-radius:5px;
   moz-border-radius:5px;
}

##{id} .onlinehelp {
   width:100px;
   margin-top:30px;
   margin-left:50%;
}
</style>

      <div id='#{id}'>

        Votre contenu ici,
        #{ApplicationController.helpers.help('t2b_creation')}

      </div>

<script>
         /* S'il est nécessaire de mettre du script, c'est ici */

</script>

    eos
    self.contexte=ENTITE
    self.tag=""
   end

   before_save do
    compile
    true
   end

   # === CURRENTS
  def self.currents
    Objet.filtrer(Perspective.all(:conditions => ["categorie = ?",PERSPECTIVE],:order => ["contexte","nom"]) )
  end
  
  def self.currentsContextuel
    Objet.filtrer(Perspective.all(:conditions => ["categorie = ? AND contexte = ?",PERSPECTIVE,CONTEXTUEL]) )
  end
  
  def export(controller)
    file = Tempfile.new([id, '.txt'])
    infos={nom: nom, description: description, contexte: contexte, data: data}
    File.open(file,'w') do |f|
      f.puts infos.to_json
    end
    controller.send_file file.path, :filename => "perspective_#{nom}.txt"
  end
  
  def self.import(content)
    infos=ActiveSupport::JSON.decode(content)  
    p=Perspective.new
    p.nom=infos["nom"]
    p.description=infos["description"]
    p.contexte=infos["contexte"]
    p.data=infos["data"]
    p.save
    p
  end
  
  def modeEntite?
    contexte==ENTITE 
  end
  
  def modeContextuel?
    contexte==CONTEXTUEL 
  end

  def modeOnglet?
     contexte==ONGLET
  end
  
  def uiDisplay
    ui=nom
   # ui="#{nom} <div class='default' title='Par défaut'>&nbsp;</div>" if User.current.profile.default?(self)
    "<span class='contexte_#{contexte}' title='#{ApplicationController.helpers.format_contexte(contexte)}'>&nbsp;</span>"+ui
  end


  
  def json()
    selected= User.current.profile.filtres.include? self
    { :id=>id, :cell => [ selected, ApplicationController.helpers.format_objet(self), "", writable?,User.current.profile.default?(self)  ]   }
  end


  def html?
    data.is_a? String and data.first() != "["  and data.first() != "]"
  end

  def canHaveErb?
    return mode==1
  end

  def compile

    return false  if ! html?

    self.mode = owner.admin?

    # Initialisation
    self.composantes=""
    self.compiled=""
    self.good=false

    # Compilation
    result=FiltreData.compile(data.gsub('"',"'"),false)
    if result.empty?
      self.compiled="Erreur lors de la compilation"
      return false
    end

    self.compiled=result[:compiled]
    self.good=result[:valid]
    if ! self.good
      return false
    end

    # Récupérations des composantes
    #mapComposantes=[]
    #result[:composantes].each do |c|
    #  if ! mapComposantes.include?(c.id)
    #    mapComposantes<<c.id
    #  end
    #end

    self.composantes = result[:composantes].join(",")

  end

  def compiled?
    compiled != "" and good
  end


  def evaluer (entity,prechargedValues=nil)
    @evaluated="--"
    if html?

        compile if ! compiled?

        # Récupération dans la base de toutes les valeurs
        if prechargedValues==nil
          values=Value.all( :conditions=> [ "composante_id in (?) AND masteruid = ? ",composantes.split(","),entity ])
        else
           values=prechargedValues.select { |v| v.masteruid==entity}
        end
        t=FiltreData.boxEval(entity,'"'+self.compiled+'"',values,prechargedValues==nil,canHaveErb?)

        @evaluated=t.value;
    else
      @evaluated="not in HTML format"
    end
  end

  def evaluated
    @evaluated
  end

  

end