class Profile < ActiveRecord::Base

  attr_accessible :perspective_entite,:perspective_contextuelle,:vues_order,:vues_active,:notifications_active
  attr_accessible :notification_lastdate , :notifiers , :options
  has_and_belongs_to_many :filtres , :include => [ :evaluation ]
  has_one  :user  , :dependent => :destroy

  serialize :options
  serialize :vues_order
  serialize :vues_active
  serialize :notifications_active
  serialize :notifiers


  GPS_PRECIS="precis"
  GPS_APPROX="approx"
  GPS_AUTO="auto"

  SHOW_SHARED="SHOW_SHARED"
  EDIT_MODE="EDIT_MODE"
  FILTRE_FAST="FILTRE_FAST"
  FILTRE_MODE="FILTRE_MODE"
  FILTRE_EXC="FILTRE_EXC"
  SET_GPS="SET_GPS"
  MAP_ZOOM="MAP_ZOOM"
  MAP_CENTER="MAP_CENTER"
  COMPOSANTE="COMPOSANTE"
  NOTIFICATIONS_FILTRE="NOTIFICATIONS_FILTRE"
  AVATAR="AVATAR"
  GPS_MODE="GPS_MODE"
  ADMIN_MODE="ADMIN_MODE"

  VISIBLE_ENTITIES="VISIBLE_ENTITIES"
  VISIBLE_FILTERS="VISIBLE_FILTERS"

  ONGLET_CONTENT="ONGLET_CONTENT"


  OPTIONS=[SHOW_SHARED,EDIT_MODE,FILTRE_FAST,FILTRE_EXC,SET_GPS,MAP_ZOOM,MAP_CENTER,FILTRE_MODE,COMPOSANTE,
           NOTIFICATIONS_FILTRE,AVATAR,GPS_MODE,VISIBLE_ENTITIES,VISIBLE_FILTERS,ADMIN_MODE,ONGLET_CONTENT]

  DEFAULT_VALUES={"SHOW_SHARED" => true,"EDIT_MODE"=> false,"FILTRE_FAST" => true,"SET_GPS" => false,
                  "MAP_CENTER" => -1, "MAP_ZOOM" => 11,"FILTRE_MODE"=>0,"COMPOSANTE"=>1,ADMIN_MODE=> false,
                  "NOTIFICATIONS_FILTRE"=>-1,"AVATAR"=>"", "GPS_MODE"=> "precis", "VISIBLE_ENTITIES"=>{} ,"VISIBLE_FILTERS"=>[],
                  "ONGLET_CONTENT" => -1
  }

  before_create do
    self.options=DEFAULT_VALUES
    notifiers=Notification.notifiers
  end

  def gpsAuto?
    (get(GPS_MODE)  == GPS_AUTO) ||  !get(GPS_MODE)
  end

  def gpsApprox?
    get(GPS_MODE)  == GPS_APPROX
  end

  def gpsPrecis?
    get(GPS_MODE)  == GPS_PRECIS
  end

  def adminMode?
    return has(ADMIN_MODE)
  end


  def getFiltres
    filtres.select {|f| f.categorie == Objet::FILTRE}
  end
  
  def getFiltresVue
    filtres.select {|f| f.categorie == Objet::FILTRE_VUE}
  end

  def notifications
    return notifications_active if notifications_active
    return []
  end

  def notificationActive?(notif)
    notifications.include?(notif.id)
  end

  def hasNotifier?(type)
    return true if notifiers==nil
    return notifiers.include? type
  end
  
  
  def affecterUneperspectiveParDefaut(p)
    if p.modeEntite?
      update_attributes({:perspective_entite => p.id})  
    end
    
    if p.modeContextuel?
      update_attributes({:perspective_contextuelle => p.id})
    end
 
  end

  def default?(p)
    return  perspective?(p) || contextualPerspective?(p)
  end

  # Perspective par defaut 
  def perspective=(p)
    self.perspective_entite=p.id
  end

  def perspective
     return nil if self.perspective_entite==nil
     Perspective.find_by_id(self.perspective_entite)
  end

  def perspectiveId
    p=perspective
    return "" if p==nil
    p.id
  end

  def perspective?(p)
    return p.id== self.perspective_entite
  end
  # =============================
  
  # Perspective par defaut du mode contextuel
  def contextualPerspective=(p)
    self.perspective_entite=p.id
  end

  def contextualPerspective
     return nil if self.perspective_contextuelle==nil
     Perspective.find_by_id(self.perspective_contextuelle)
  end

  def contextualPerspective?(p)
    return p.id== self.perspective_contextuelle
  end
  
  def currentPerspectiveContexte
    p=contextualPerspective
    if p==nil
      p=Perspective.currentsContextuel.first  
    end
    return p.id if p !=nil
    -1
  end
  # =============================


  def updateNotificationLastdate
    update_attributes({:notification_lastdate => Time.now})
  end


  def has(key)
    v=get(key)
    return true if v == true || v =~ (/(true|t|yes|y|1)$/i)
    false
  end

  def get(key)
    if self.options==nil
      update_attributes({:options => DEFAULT_VALUES})
      self.options=DEFAULT_VALUES
    end

    return self.options[key] if self.options.include? key
    DEFAULT_VALUES[key] if DEFAULT_VALUES.include? key
  end

  def set(key,value)
    return false if ! OPTIONS.include? key
    self.options[key] = value
    true
  end

  def setAndUpdate(key,value)
    update_attributes({:options => self.options}) if set(key,value)
  end


end
