class Rapport < Objet

  attr_accessible :groupeby

  include Rapports
  
  belongs_to :filtre
  
   def initialize(attributes = {})
    super
    self.categorie=RAPPORT
    self.nom="Nouveau rapport"
    self.description="Description du rapport"
    self.data=[]
    self.groupeby=-1
   end

  # === CURRENTS
  def self.currents
    Objet.filtrer(Rapport.all(:conditions => ["categorie = ?",RAPPORT]) ).sort! { |x,y| x.nom <=> y.nom }
  end

  def columns
      self.data
  end
    
  def columns=(c)
      self.data=c
  end
  
  def getColumns
    ret=[]
    self.data.each do |column|
      column.composantes
      next if ! column.valid?
      ret<<column
    end  
    ret
  end
  
  def addColumn(tag,serveur=nil)
    serveur=Master.serveur if serveur==nil
    composante=Master.serveur.getComposante(tag)
    if composante != nil
      c=RapportColumn.new 
      c.nom=composante.name
      c.format="\"{#{composante.fullname}}\""
      data << c  
    end
  end


  def self.csv(composantes,filtre,separateur=";")

    rapport=Rapport.new
    cols=[]
    composantes.each do |c|
      composante=Composante.find_by_fullname(c)
      next if ! composante
      col=RapportColumn.new
      col.nom=composante.fullname
      col.format="{#{composante.fullname}}"
      cols<<col
    end
    rapport.columns=cols

    list=RapportsController.computeRapport(rapport,filtre)

    cols=[]
    rapport.columns.each do |column|
      next if !column.valid?
      cols<<column.nom
    end


    require 'csv'
    csv_string = CSV.generate(:col_sep => separateur) do |csv|
      csv << cols
      list.each do |entry|
        csv << entry[:cell]
      end
    end
    csv_string
  end


end