class Right < ActiveRecord::Base

  DROITS=[Permission::DENY,Permission::READ]

  belongs_to :user , :foreign_key => "user_id" ,  :class_name => 'UserSimple'
  belongs_to :objet
  attr_accessible :droit

  before_save do
    self.objet.writable? false
    return false if ! self.user
    # On vérifie si User.current a
    if UsersController._search(self.user.uid).include? self.user
      self.user = Group.nobody
    end

    self.user = Group.nobody if self.user == nil



  end

  after_save do
    Objet::clearPermissionsCache(self.objet.id)
  end


  def droitForCurrentUser?(d)
      return false if d>droit
      return false  if user == nil
      User.current.id == user.id || User.current.groups.exists?(user)
  end

  def isDeletable?
    droit==Permission::DELETE ||  User.current.admin?
  end

  def isWritable?
    (droit==Permission::WRITE || isDeletable?  ) && ! isDeny?
  end

  def isModifiable?
    (droit==Permission::MODIFY)
  end

  def isReadable?
    (droit==Permission::READ || isModifiable?  ) && ! isDeny?
  end

  def isDeny?
    droit==Permission::DENY
  end

  def to_json()
    u= self.user
    u=Group.nobody if self.user == nil
    { :id=>id, :cell => [u.uid,  ApplicationController.helpers.format_droit(droit) ]   }
  end

end
