# -*- coding: utf-8 -*-
class Script  < Objet
  
  include Rapports
  
  def initialize(*params)
      super(*params)
      self.categorie=SCRIPT
      self.description="Description du script"
      self.data=ScriptData.new
      self.nom="Nouveau script"
  end
  
  after_find do
      byserver=true if byserver? == nil
      serveurs=[] if serveurs==nil
   end
  
  # === CURRENTS
  def self.currents
    Objet.filtrer(Script.all(:conditions => ["categorie = ?",SCRIPT]) )
  end
  
  def self.currentsForServeur(composanteId)
    scripts=Script.currents
    s=composanteId.to_s
    scripts.select { |x| x.serveurs.include?(s)}   
  end
  
  def json()
    used=false
    { :id=>id, :cell => [ used, ApplicationController.helpers.format_objet(self), "", writable?,""  ]   }
  end
  
  def usage
    data.usage
  end
  
  def script
    data.script
  end
  
  def script=(src)
    data.script=src
  end
  
  def byserver?
    data.byserver
  end
  
  def byserver=(b)
    data.byserver=b
  end
  
  def uiDisplay
    "<span class='#{(byserver?)?"each":"once"}' title=''>#{nom}</span>"
  end
 
  
  def serveurs
    return [] if data.serveurs==nil
    data.serveurs
  end
  
  def serveurs=(serveurs)
    data.serveurs=[]
    data.serveurs.concat(serveurs)
  end

  def self.tester(src,args)

    script=Value.remplacer(src)
    scriptname="data/scripts/#{User.current.uid}-test"
    File.open(scriptname, "w") do |f|
      f.write(script)
    end

    inperpreteur=ScriptData.getInterpreteur(src.split("\n").first)
    cmd=[inperpreteur, "#{scriptname}"]
    cmd.concat(args.split(";"))
    cmd<< " 2>&1"
    cmd=cmd.join(" ")
    output=IO.popen(cmd,"w+").read
    output.encode!('UTF-8', 'UTF-8', :invalid => :replace)
    output
  end
  
  
  def execute(args,serveur=nil,uid=nil,masteruid=nil)
    
    output="Le script n'est pas accessible pour #{User.current.uid}"
    composante=nil
    name=""
    arguments=""
    
    if  readable? || User.current.admin?(false)
      if serveur!=nil
        composante=serveur.composante 
        name=serveur.id
      end
      
      script=Value.remplacer(data.script,uid,composante).gsub("\r","")
      #script=FiltreData.evaluation(masteruid,data.script,serveur)

      #arguments=RapportColumn.formater(uid,args,false,composante,nil,masteruid) if args!=nil
      if args!=nil
        arguments=args.gsub("{ID}",uid)  if uid != nil
      else
        arguments=args
      end
      arguments=FiltreData.evaluation(masteruid,arguments,serveur,nil,false) if arguments!=nil

      puts "\tArguments: #{args} => #{arguments}"
      #puts("Arguments (uid=#{uid},composante=#{composante}): #{args} => #{arguments}")

      scriptname="data/scripts/#{id}-#{name}"
      File.open(scriptname, "w") do |f|
        f.write(script)
      end
      inperpreteur=ScriptData.getInterpreteur(script.split("\n").first)
      cmd=[ "#{scriptname}"]
      cmd.concat(arguments.split(";"))   if arguments!=nil
      cmd<< " 2>&1"
      #puts(cmd)
      system "chmod +x #{scriptname}"
      output=IO.popen(cmd,"w+").read
      #puts output
      #logger.info(output)
    end
    output.encode!('UTF-8', 'UTF-8', :invalid => :replace)
    
    return {:resultat => output,:arguments => arguments}
    
  end

end